/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Sourcable;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class Normalize
extends PotentialClassIgnorer
implements UnsupervisedFilter,
Sourcable,
OptionHandler {
    static final long serialVersionUID = -8158531150984362898L;
    protected double[] m_MinArray;
    protected double[] m_MaxArray;
    protected double m_Translation = 0.0;
    protected double m_Scale = 1.0;

    public String globalInfo() {
        return "Normalizes all numeric values in the given dataset (apart from the class attribute, if set). The resulting values are by default in [0,1] for the data used to compute the normalization intervals. But with the scale and translation parameters one can change that, e.g., with scale = 2.0 and translation = -1.0 you get values in the range [-1,+1].";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe scaling factor for the output range.\n\t(default: 1.0)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tThe translation of the output range.\n\t(default: 0.0)", "T", 1, "-T <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setScale(Double.parseDouble(string));
        } else {
            this.setScale(1.0);
        }
        string = Utils.getOption('T', stringArray);
        if (string.length() != 0) {
            this.setTranslation(Double.parseDouble(string));
        } else {
            this.setTranslation(0.0);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-S");
        vector.add("" + this.getScale());
        vector.add("-T");
        vector.add("" + this.getTranslation());
        return vector.toArray(new String[vector.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        this.m_MaxArray = null;
        this.m_MinArray = null;
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_MinArray == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_MinArray == null) {
            int n;
            Instances instances = this.getInputFormat();
            this.m_MinArray = new double[instances.numAttributes()];
            this.m_MaxArray = new double[instances.numAttributes()];
            for (n = 0; n < instances.numAttributes(); ++n) {
                this.m_MinArray[n] = Double.NaN;
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                double[] dArray = instances.instance(n).toDoubleArray();
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    if (!instances.attribute(i).isNumeric() || instances.classIndex() == i || Instance.isMissingValue(dArray[i])) continue;
                    if (Double.isNaN(this.m_MinArray[i])) {
                        this.m_MinArray[i] = this.m_MaxArray[i] = dArray[i];
                        continue;
                    }
                    if (dArray[i] < this.m_MinArray[i]) {
                        this.m_MinArray[i] = dArray[i];
                    }
                    if (!(dArray[i] > this.m_MaxArray[i])) continue;
                    this.m_MaxArray[i] = dArray[i];
                }
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                this.convertInstance(instances.instance(n));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    protected void convertInstance(Instance instance) throws Exception {
        Instance instance2 = null;
        if (instance instanceof SparseInstance) {
            double[] dArray = new double[instance.numAttributes()];
            int[] nArray = new int[instance.numAttributes()];
            double[] dArray2 = instance.toDoubleArray();
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                double d;
                if (instance.attribute(i).isNumeric() && !Instance.isMissingValue(dArray2[i]) && this.getInputFormat().classIndex() != i) {
                    if (Double.isNaN(this.m_MinArray[i]) || this.m_MaxArray[i] == this.m_MinArray[i]) {
                        d = 0.0;
                    } else {
                        d = (dArray2[i] - this.m_MinArray[i]) / (this.m_MaxArray[i] - this.m_MinArray[i]) * this.m_Scale + this.m_Translation;
                        if (Double.isNaN(d)) {
                            throw new Exception("A NaN value was generated while normalizing " + instance.attribute(i).name());
                        }
                    }
                    if (d == 0.0) continue;
                    dArray[n] = d;
                    nArray[n] = i;
                    ++n;
                    continue;
                }
                d = dArray2[i];
                if (d == 0.0) continue;
                dArray[n] = d;
                nArray[n] = i;
                ++n;
            }
            double[] dArray3 = new double[n];
            int[] nArray2 = new int[n];
            System.arraycopy(dArray, 0, dArray3, 0, n);
            System.arraycopy(nArray, 0, nArray2, 0, n);
            instance2 = new SparseInstance(instance.weight(), dArray3, nArray2, instance.numAttributes());
        } else {
            double[] dArray = instance.toDoubleArray();
            for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
                if (!instance.attribute(i).isNumeric() || Instance.isMissingValue(dArray[i]) || this.getInputFormat().classIndex() == i) continue;
                if (Double.isNaN(this.m_MinArray[i]) || this.m_MaxArray[i] == this.m_MinArray[i]) {
                    dArray[i] = 0.0;
                    continue;
                }
                dArray[i] = (dArray[i] - this.m_MinArray[i]) / (this.m_MaxArray[i] - this.m_MinArray[i]) * this.m_Scale + this.m_Translation;
                if (!Double.isNaN(dArray[i])) continue;
                throw new Exception("A NaN value was generated while normalizing " + instance.attribute(i).name());
            }
            instance2 = new Instance(instance.weight(), dArray);
        }
        instance2.setDataset(instance.dataset());
        this.push(instance2);
    }

    public String toSource(String string, Instances instances) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = new boolean[instances.numAttributes()];
        for (int i = 0; i < instances.numAttributes(); ++i) {
            blArray[i] = instances.attribute(i).isNumeric() && i != instances.classIndex();
        }
        stringBuffer.append("class " + string + " {\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** lists which attributes will be processed */\n");
        stringBuffer.append("  protected final static boolean[] PROCESS = new boolean[]{" + Utils.arrayToString(blArray) + "};\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** the minimum values for numeric values */\n");
        stringBuffer.append("  protected final static double[] MIN = new double[]{" + Utils.arrayToString(this.m_MinArray).replaceAll("NaN", "Double.NaN") + "};\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** the maximum values for numeric values */\n");
        stringBuffer.append("  protected final static double[] MAX = new double[]{" + Utils.arrayToString(this.m_MaxArray) + "};\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** the scale factor */\n");
        stringBuffer.append("  protected final static double SCALE = " + this.m_Scale + ";\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** the translation */\n");
        stringBuffer.append("  protected final static double TRANSLATION = " + this.m_Translation + ";\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * filters a single row\n");
        stringBuffer.append("   * \n");
        stringBuffer.append("   * @param i the row to process\n");
        stringBuffer.append("   * @return the processed row\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public static Object[] filter(Object[] i) {\n");
        stringBuffer.append("    Object[] result;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    result = new Object[i.length];\n");
        stringBuffer.append("    for (int n = 0; n < i.length; n++) {\n");
        stringBuffer.append("      if (PROCESS[n] && (i[n] != null)) {\n");
        stringBuffer.append("        if (Double.isNaN(MIN[n]) || (MIN[n] == MAX[n]))\n");
        stringBuffer.append("          result[n] = 0;\n");
        stringBuffer.append("        else\n");
        stringBuffer.append("          result[n] = (((Double) i[n]) - MIN[n]) / (MAX[n] - MIN[n]) * SCALE + TRANSLATION;\n");
        stringBuffer.append("      }\n");
        stringBuffer.append("      else {\n");
        stringBuffer.append("        result[n] = i[n];\n");
        stringBuffer.append("      }\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * filters multiple rows\n");
        stringBuffer.append("   * \n");
        stringBuffer.append("   * @param i the rows to process\n");
        stringBuffer.append("   * @return the processed rows\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public static Object[][] filter(Object[][] i) {\n");
        stringBuffer.append("    Object[][] result;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    result = new Object[i.length][];\n");
        stringBuffer.append("    for (int n = 0; n < i.length; n++) {\n");
        stringBuffer.append("      result[n] = filter(i[n]);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public double[] getMinArray() {
        return this.m_MinArray;
    }

    public double[] getMaxArray() {
        return this.m_MaxArray;
    }

    public String scaleTipText() {
        return "The factor for scaling the output range (default: 1).";
    }

    public double getScale() {
        return this.m_Scale;
    }

    public void setScale(double d) {
        this.m_Scale = d;
    }

    public String translationTipText() {
        return "The translation of the output range (default: 0).";
    }

    public double getTranslation() {
        return this.m_Translation;
    }

    public void setTranslation(double d) {
        this.m_Translation = d;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5543 $");
    }

    public static void main(String[] stringArray) {
        Normalize.runFilter(new Normalize(), stringArray);
    }
}

