/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.baderlab.brain.ColorPaintScale;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinProfileDistance;
import org.baderlab.brain.util.FileReaderUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;

public class ComparisonSpecificityDiagram {
    int numRows;
    int numColumns;
    DefaultXYZDataset dataset;
    String[] yAxisLabels;
    boolean normalizePerColumn = false;

    public ComparisonSpecificityDiagram(String mutantProfileProjectFileName, String mutantSortOrderFileName, List profilePositionsToDisplay, boolean normalizePerColumn) {
        this.setNormalizePerColumn(normalizePerColumn);
        ArrayList originalProfileList = (ArrayList)PeptideToProfileReader.readPeptidesAsProfiles(new File(mutantProfileProjectFileName), 0.0);
        ArrayList sortOrderFileLines = null;
        try {
            sortOrderFileLines = FileReaderUtil.readFileAsLineList(new File(mutantSortOrderFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String referenceLine = (String)sortOrderFileLines.get(0);
        String referenceProfileName = referenceLine.split("\t")[1];
        ArrayList<String> sortedProfileNames = new ArrayList<String>();
        for (int i = 1; i < sortOrderFileLines.size(); ++i) {
            String s = (String)sortOrderFileLines.get(i);
            sortedProfileNames.add(s);
        }
        this.yAxisLabels = new String[sortedProfileNames.size()];
        this.yAxisLabels = sortedProfileNames.toArray(this.yAxisLabels);
        this.yAxisLabels = this.reduceYAxisLabels(this.yAxisLabels);
        HashMap<String, ProteinProfile> profileNameStringToProfileMap = new HashMap<String, ProteinProfile>();
        for (int i = 0; i < originalProfileList.size(); ++i) {
            ProteinProfile profile = (ProteinProfile)originalProfileList.get(i);
            profileNameStringToProfileMap.put(profile.getProteinName(), profile);
        }
        ProteinProfile referenceProfile = (ProteinProfile)profileNameStringToProfileMap.get(referenceProfileName);
        ArrayList sortedProfileList = new ArrayList();
        for (int i = 0; i < sortedProfileNames.size(); ++i) {
            String s = (String)sortedProfileNames.get(i);
            sortedProfileList.add(profileNameStringToProfileMap.get(s));
        }
        this.numRows = sortedProfileList.size();
        this.numColumns = profilePositionsToDisplay != null ? profilePositionsToDisplay.size() : referenceProfile.getNumColumns();
        double[][] stdevMatrix = this.calculateStandardDeviationMatrixUsingRandomReferenceProfileSubsets(referenceProfile, 50, 1000, sortedProfileList, profilePositionsToDisplay);
        double[][] data = this.calculateDifferenceMatrix(sortedProfileList, profilePositionsToDisplay, referenceProfile, 1, stdevMatrix);
        this.dataset = new DefaultXYZDataset();
        this.dataset.addSeries((Comparable)((Object)"Series 1"), data);
    }

    public static void main(String[] args) {
        String projectFile = "/Users/shirleyhui/Data/E14/ProjectFiles/projectFileE14-WT_A_Singles.txt";
        String sortOrderFile = "/Users/shirleyhui/Desktop/singlemutants.txt";
        ComparisonSpecificityDiagram diag = new ComparisonSpecificityDiagram(projectFile, sortOrderFile, null, true);
        diag.saveDiagram("/Users/shirleyhui/Desktop/test5.pdf");
    }

    public boolean isNormalizePerColumn() {
        return this.normalizePerColumn;
    }

    public void setNormalizePerColumn(boolean normalizePerColumn) {
        this.normalizePerColumn = normalizePerColumn;
    }

    private double[][] calculateDifferenceMatrix(ArrayList sortedProfileList, List profilePositionsToDisplay, ProteinProfile referenceProfile, int zValue, double[][] stdevMatrix) {
        int i;
        double[] xvalues = new double[this.numRows * this.numColumns];
        double[] yvalues = new double[this.numRows * this.numColumns];
        double[] zvalues = new double[this.numRows * this.numColumns];
        double[][] data = new double[][]{xvalues, yvalues, zvalues};
        ProteinProfile[] referenceProfileColumnArray = new ProteinProfile[referenceProfile.getNumColumns()];
        for (int i2 = 0; i2 < referenceProfile.getNumColumns(); ++i2) {
            referenceProfileColumnArray[i2] = referenceProfile.getProfileSubsetCopy(Integer.toString(i2));
        }
        double minValue = 0.0;
        double maxValue = 0.0;
        double[] minValuesPerColumn = new double[this.numColumns];
        double[] maxValuesPerColumn = new double[this.numColumns];
        for (i = 0; i < sortedProfileList.size(); ++i) {
            ProteinProfile profile = (ProteinProfile)sortedProfileList.get(i);
            for (int j = 0; j < profile.getNumColumns(); ++j) {
                ProteinProfile profileColumnTest = profile.getProfileSubsetCopy(Integer.toString(j));
                double distance = ProteinProfileDistance.calculateDistributionDistance(profileColumnTest, referenceProfileColumnArray[j]);
                this.setValue(data, j, i, distance, this.numColumns);
                minValue = Math.min(minValue, distance);
                maxValue = Math.max(maxValue, distance);
                minValuesPerColumn[j] = Math.min(minValuesPerColumn[j], distance);
                maxValuesPerColumn[j] = Math.max(maxValuesPerColumn[j], distance);
            }
        }
        if (stdevMatrix != null) {
            for (i = 0; i < this.numColumns; ++i) {
                if (i == 6) {
                    System.out.println("Column 6");
                }
                for (int j = 0; j < this.numRows; ++j) {
                    double reducedValue = this.getValue(data, i, j, this.numColumns) - stdevMatrix[j][i] * (double)zValue;
                    if (reducedValue < 0.0) {
                        reducedValue = 0.0;
                    }
                    this.setValue(data, i, j, reducedValue, this.numColumns);
                }
            }
            if (this.isNormalizePerColumn()) {
                this.normalizeDataPerColumn(data, referenceProfile.getNumColumns(), sortedProfileList.size(), minValuesPerColumn, maxValuesPerColumn);
            } else {
                this.normalizeDataOverAllColumns(data, referenceProfile.getNumColumns(), sortedProfileList.size(), minValue, maxValue);
            }
        }
        return data;
    }

    private double[][] calculateStandardDeviationMatrixUsingRandomReferenceProfileSubsets(ProteinProfile referenceProfile, int peptideSampleSize, int iterations, ArrayList sortedProfileList, List profilePositionsToDisplay) {
        double[][][] iterationData = new double[this.numRows][this.numColumns][iterations];
        for (int i = 0; i < iterations; ++i) {
            ProteinProfile refProfile = referenceProfile.getProfileFromRandomPeptideSubset(peptideSampleSize);
            double[][] data = this.calculateDifferenceMatrix(sortedProfileList, profilePositionsToDisplay, refProfile, 0, null);
            for (int k = 0; k < this.numColumns; ++k) {
                for (int j = 0; j < this.numRows; ++j) {
                    iterationData[j][k][i] = this.getValue(data, k, j, this.numColumns);
                }
            }
        }
        double[][] stdevMatrix = new double[this.numRows][this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                stdevMatrix[j][i] = this.sdKnuth(iterationData[j][i]);
            }
        }
        return stdevMatrix;
    }

    private double sdKnuth(double[] data) {
        int n = data.length;
        if (n < 2) {
            return Double.NaN;
        }
        double avg = data[0];
        double sum = 0.0;
        for (int i = 1; i < data.length; ++i) {
            double newavg = avg + (data[i] - avg) / (double)(i + 1);
            sum += (data[i] - avg) * (data[i] - newavg);
            avg = newavg;
        }
        return Math.sqrt(sum / (double)(n - 1));
    }

    private double[] stddev(double[][] data) {
        double[] stddevValuePerColumn = new double[this.numColumns];
        double[] tempDataArray = new double[this.numRows];
        for (int i = 0; i < this.numColumns; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                tempDataArray[j] = this.getValue(data, i, j, this.numColumns);
            }
            stddevValuePerColumn[i] = this.sdKnuth(tempDataArray);
        }
        return stddevValuePerColumn;
    }

    private double[] mean(double[][] data) {
        double[] meanValuePerColumn = new double[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            double mean = 0.0;
            for (int j = 0; j < this.numRows; ++j) {
                mean += this.getValue(data, i, j, this.numColumns);
            }
            meanValuePerColumn[i] = mean / (double)this.numRows;
        }
        return meanValuePerColumn;
    }

    private void normalizeDataOverAllColumns(double[][] data, int numColumns, int numRows, double minValue, double maxValue) {
        for (int i = 0; i < numColumns; ++i) {
            for (int j = 0; j < numRows; ++j) {
                double normalizedValue = this.getValue(data, i, j, numColumns) / (maxValue - minValue);
                this.setValue(data, i, j, normalizedValue, numColumns);
            }
        }
    }

    private void normalizeDataPerColumn(double[][] data, int numColumns, int numRows, double[] minValuesPerColumn, double[] maxValuesPerColumn) {
        for (int i = 0; i < numColumns; ++i) {
            for (int j = 0; j < numRows; ++j) {
                double normalizedValue = maxValuesPerColumn[i] - minValuesPerColumn[i] == 0.0 ? maxValuesPerColumn[i] : this.getValue(data, i, j, numColumns) / (maxValuesPerColumn[i] - minValuesPerColumn[i]);
                this.setValue(data, i, j, normalizedValue, numColumns);
            }
        }
    }

    public String[] reduceYAxisLabels(String[] yAxisLabels) {
        ArrayList<String> newLabels = new ArrayList<String>();
        String previousPosition = "";
        for (int i = 0; i < yAxisLabels.length; ++i) {
            String yAxisLabel = yAxisLabels[i];
            String firstAAposition = yAxisLabel.substring(0, 3);
            String secondAA = yAxisLabel.substring(3, 4);
            if (previousPosition.equals(firstAAposition)) {
                newLabels.add(secondAA);
            } else {
                newLabels.add(new String(firstAAposition + "  " + secondAA));
            }
            previousPosition = firstAAposition;
        }
        String[] newLabelsArray = new String[yAxisLabels.length];
        return newLabels.toArray(newLabelsArray);
    }

    private void setValue(double[][] data, int col, int row, double value, int totalColumnNumber) {
        data[0][row * totalColumnNumber + col] = col;
        data[1][row * totalColumnNumber + col] = row;
        data[2][row * totalColumnNumber + col] = value;
    }

    private double getValue(double[][] data, int col, int row, int totalColumnNumber) {
        return data[2][row * totalColumnNumber + col];
    }

    private JFreeChart createChart() {
        float fontMultiplier = 40.0f;
        String[] xAxisLabels = new String[]{"-6", "-5", "-4", "-3", "-2", "-1", "0"};
        SymbolAxis xAxis = new SymbolAxis("Peptide Ligand Position", xAxisLabels);
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        xAxis.setLabelFont(xAxis.getLabelFont().deriveFont(fontMultiplier));
        xAxis.setTickLabelFont(xAxis.getLabelFont().deriveFont(fontMultiplier));
        SymbolAxis yAxis = new SymbolAxis("Erbin Mutant", this.yAxisLabels);
        yAxis.setLowerMargin(0.0);
        yAxis.setUpperMargin(0.0);
        yAxis.setInverted(true);
        yAxis.setLabelFont(yAxis.getLabelFont().deriveFont(fontMultiplier));
        yAxis.setTickLabelFont(yAxis.getLabelFont().deriveFont(fontMultiplier));
        XYBlockRenderer renderer = new XYBlockRenderer();
        ColorPaintScale paintScale = new ColorPaintScale(0.0, 1.0, Color.blue, Color.red);
        System.out.println("finished");
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                int item = i * this.numColumns + j;
                double val = this.dataset.getZValue(0, item);
                Paint p = paintScale.getPaint(val);
                System.out.print(p.toString() + "\t");
            }
            System.out.println();
        }
        renderer.setPaintScale((PaintScale)paintScale);
        XYPlot plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setDomainAxis(1, (ValueAxis)xAxis);
        plot.setDomainAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        JFreeChart chart = new JFreeChart("Erbin Mutant Specificity", (Plot)plot);
        TextTitle title = chart.getTitle();
        title.setFont(title.getFont().deriveFont(fontMultiplier));
        chart.removeLegend();
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    public void saveDiagram(String diagramFileName) {
        try {
            ComparisonSpecificityDiagram.saveChartAsPDF(new File(diagramFileName), this.createChart(), 100 * this.numColumns, 100 * this.numRows, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeChartAsPDF(OutputStream out, JFreeChart chart, int width, int height, FontMapper mapper) throws IOException {
        Rectangle pagesize = new Rectangle((float)width, (float)height);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphics((float)width, (float)height, mapper);
            Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, (Rectangle2D)r2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        document.close();
    }

    public static void saveChartAsPDF(File file, JFreeChart chart, int width, int height, FontMapper mapper) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        ComparisonSpecificityDiagram.writeChartAsPDF(out, chart, width, height, mapper);
        ((OutputStream)out).close();
    }
}

