/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.MinusMatrix;
import org.ujmp.core.calculation.MinusMatrixCalculation;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MinusMatrixMatrix
implements MinusMatrixCalculation<Matrix, Matrix, Matrix> {
    MinusMatrixMatrix() {
    }

    @Override
    public final void calc(Matrix source1, Matrix source2, Matrix target) {
        if (source1 instanceof DenseMatrix && source2 instanceof DenseMatrix && target instanceof DenseMatrix) {
            MinusMatrix.DENSEMATRIX.calc((DenseMatrix)source1, (DenseMatrix)source2, (DenseMatrix)target);
        } else if (source1 instanceof SparseMatrix && source2 instanceof SparseMatrix && target instanceof SparseMatrix) {
            MinusMatrix.SPARSEMATRIX.calc((SparseMatrix)source1, (SparseMatrix)source2, (SparseMatrix)target);
        } else {
            VerifyUtil.assertSameSize(source1, source2, target);
            for (long[] c : source1.allCoordinates()) {
                BigDecimal v1 = source1.getAsBigDecimal(c);
                BigDecimal v2 = source2.getAsBigDecimal(c);
                BigDecimal result = MathUtil.minus(v1, v2);
                target.setAsBigDecimal(result, c);
            }
        }
    }
}

