/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.creators;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class Randn
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 3846626738610954086L;
    private double mean = 0.0;
    private double sigma = 1.0;

    public Randn(Matrix matrix) {
        super(matrix);
    }

    public Randn(Matrix matrix, double mean, double sigma) {
        super(matrix);
        this.mean = mean;
        this.sigma = sigma;
    }

    public double getDouble(long ... coordinates) {
        return MathUtil.nextGaussian(this.mean, this.sigma);
    }

    public static Matrix calc(long ... size) throws MatrixException {
        return Randn.calc(ValueType.DOUBLE, size);
    }

    public static Matrix calc(Matrix source) throws MatrixException {
        return Randn.calc(source, 0.0, 1.0);
    }

    public static Matrix calc(Matrix source, double mean, double sigma) throws MatrixException {
        Matrix ret = Matrix.factory.zeros(source.getSize());
        for (long[] c : source.allCoordinates()) {
            ret.setAsDouble(MathUtil.nextGaussian(mean, sigma), c);
        }
        return ret;
    }

    public static Matrix calc(ValueType valueType, long ... size) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(valueType, size);
        for (long[] c : ret.allCoordinates()) {
            ret.setAsDouble(MathUtil.nextGaussian(0.0, 1.0), c);
        }
        return ret;
    }
}

