/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;

public class DefaultDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements HasColumnMajorDoubleArray1D {
    private static final long serialVersionUID = -3605416349143850650L;
    private final double[] values;
    private final long[] size;
    private final int rows;
    private final int cols;

    public DefaultDenseDoubleMatrix2D(Matrix m) throws MatrixException {
        this.rows = (int)m.getRowCount();
        this.cols = (int)m.getColumnCount();
        this.size = new long[]{this.rows, this.cols};
        if (m instanceof DefaultDenseDoubleMatrix2D) {
            double[] v = ((DefaultDenseDoubleMatrix2D)m).values;
            this.values = new double[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new double[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setDouble(m.getAsDouble(c), c);
            }
        }
    }

    public DefaultDenseDoubleMatrix2D(long ... size) {
        this.rows = (int)size[0];
        this.cols = (int)size[1];
        this.size = new long[]{this.rows, this.cols};
        this.values = new double[this.rows * this.cols];
    }

    public DefaultDenseDoubleMatrix2D(long rows, long cols) {
        this.rows = (int)rows;
        this.cols = (int)cols;
        this.size = new long[]{rows, cols};
        this.values = new double[this.rows * this.cols];
    }

    public DefaultDenseDoubleMatrix2D(double[] v, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.size = new long[]{rows, cols};
        this.values = v;
    }

    public final long[] getSize() {
        return this.size;
    }

    public final long getRowCount() {
        return this.rows;
    }

    public final long getColumnCount() {
        return this.cols;
    }

    public final double getDouble(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public final double getAsDouble(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public final double getAsDouble(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public final void setDouble(double value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public final void setAsDouble(double value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public final double getDouble(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public final void setDouble(double value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    public final void setAsDouble(double value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    public final Matrix copy() throws MatrixException {
        double[] result = new double[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        DefaultDenseDoubleMatrix2D m = new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    public final double[] getColumnMajorDoubleArray1D() {
        return this.values;
    }
}

