/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.longmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.longmatrix.LongMatrix;
import org.ujmp.core.longmatrix.calculation.LongCalculation;
import org.ujmp.core.longmatrix.impl.LongCalculationMatrix;

public abstract class AbstractLongCalculation
extends AbstractCalculation
implements LongCalculation {
    private static final long serialVersionUID = -2401843008270253704L;

    public AbstractLongCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractLongCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final LongMatrix calcLink() throws MatrixException {
        return new LongCalculationMatrix(this);
    }

    public final LongMatrix calcNew() throws MatrixException {
        LongMatrix result = (LongMatrix)MatrixFactory.zeros(ValueType.LONG, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsLong(this.getLong(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsLong(this.getLong(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setLong(long value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.LONG;
    }
}

