/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.statusbar;

import java.awt.Dimension;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JProgressBar;
import org.ujmp.gui.util.GlobalTimer;

public class MemoryUsage
extends JProgressBar {
    private static final long serialVersionUID = 5692292627429288637L;

    public MemoryUsage() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setMinimumSize(new Dimension(50, 30));
        GlobalTimer.getInstance().schedule((TimerTask)new UpdateTask(this), 0L, 1000L);
    }

    public void update() {
        int max = (int)Runtime.getRuntime().maxMemory() / 0x100000;
        int total = (int)Runtime.getRuntime().totalMemory() / 0x100000;
        int free = (int)Runtime.getRuntime().freeMemory() / 0x100000;
        int used = total - free;
        this.setMinimum(0);
        this.setMaximum(max);
        this.setValue(used);
        this.setToolTipText(used + "MB of " + max + "MB used");
    }

    class UpdateTask
    extends TimerTask {
        private MemoryUsage memoryUsage = null;

        public UpdateTask(MemoryUsage memoryUsage2) {
            this.memoryUsage = memoryUsage2;
        }

        public void run() {
            this.memoryUsage.update();
        }
    }
}

