/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jung;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.jung.JungGraphPanel;

public class MatrixGraphWrapper
extends DirectedSparseGraph
implements TableModelListener {
    public static final int MAXEDGES = 256000;
    public static final int MAXVERTICES = 128000;
    public static final double MINEDGEVALUE = 0.5;
    private MatrixGUIObject matrix = null;
    private final Map<Integer, Vertex> vertices = new HashMap<Integer, Vertex>();

    public MatrixGraphWrapper(Matrix m) throws MatrixException {
        this((MatrixGUIObject)m.getGUIObject());
    }

    public MatrixGraphWrapper(MatrixGUIObject m) throws MatrixException {
        this.matrix = m;
        if (m != null) {
            int stepsize = this.matrix.getColumnCount() / 128000 + 1;
            int i = 0;
            while (i < this.matrix.getColumnCount()) {
                DirectedSparseVertex v = new DirectedSparseVertex();
                v.setUserDatum((Object)JungGraphPanel.Data.Column, (Object)i, UserData.SHARED);
                if (this.matrix.getColumnName(i) != null) {
                    v.setUserDatum((Object)JungGraphPanel.Data.Label, (Object)this.matrix.getColumnName(i), UserData.SHARED);
                } else {
                    v.setUserDatum((Object)JungGraphPanel.Data.Label, (Object)("" + i), UserData.SHARED);
                }
                this.addVertex((Vertex)v);
                this.vertices.put(i, (Vertex)v);
                if (i % 100 == 0) {
                    System.out.println(i);
                }
                i += stepsize;
            }
            System.out.println("edges");
            i = 0;
            for (long[] rc : this.matrix.coordinates()) {
                double value;
                if (i++ % 100 == 0) {
                    System.out.println(i);
                }
                if (!(Math.abs(value = this.matrix.getDoubleValueAt(rc).doubleValue()) >= 0.5)) continue;
                Vertex v1 = this.getVertex((int)rc[0]);
                Vertex v2 = this.getVertex((int)rc[1]);
                if (v1 == null || v2 == null || this.numEdges() >= 256000) continue;
                DirectedSparseEdge e = new DirectedSparseEdge(v1, v2);
                e.addUserDatum((Object)JungGraphPanel.Data.Label, (Object)this.matrix.getDoubleValueAt(rc), UserData.SHARED);
                e.addUserDatum((Object)JungGraphPanel.Data.RowColumn, (Object)rc, UserData.SHARED);
                e.addUserDatum((Object)JungGraphPanel.Data.Value, (Object)this.matrix.getDoubleValueAt(rc), UserData.SHARED);
                this.addEdge((Edge)e);
            }
            m.addTableModelListener(this);
        }
    }

    public void tableChanged() throws MatrixException {
    }

    private Vertex getVertex(int index) {
        return this.vertices.get(index);
    }

    public void tableChanged(TableModelEvent e) {
        try {
            this.tableChanged();
        }
        catch (MatrixException e1) {
            e1.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.matrix.removeTableModelListener(this);
    }
}

