/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.lsimpute;

import java.io.File;
import java.lang.reflect.Method;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.Impute;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.io.IntelligentFileWriter;

public class LSImpute
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -5527190803466818167L;
    private int method = 0;
    private Matrix xImputed = null;

    public LSImpute(Matrix matrix, Impute.ImputationMethod impMethod) {
        super(matrix);
        switch (impMethod) {
            case RowMean: {
                this.method = 0;
                break;
            }
            case EMimputeGene: {
                this.method = 1;
                break;
            }
            case EMimputeArray: {
                this.method = 2;
                break;
            }
            case LSimputeGene: {
                this.method = 3;
                break;
            }
            case LSimputeArray: {
                this.method = 4;
                break;
            }
            case LSimputeCombined: {
                this.method = 5;
                break;
            }
            case LSimputeAdaptive: {
                this.method = 6;
                break;
            }
            default: {
                throw new MatrixException("Imputation method is not supported: " + (Object)((Object)impMethod));
            }
        }
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        if (this.xImputed == null) {
            this.createMatrix();
        }
        return this.xImputed.getAsDouble(coordinates);
    }

    private void createMatrix() {
        try {
            Matrix m = this.getSource();
            m = m.replaceRegex(Calculation.Ret.NEW, "NaN", "NULL");
            File file1 = File.createTempFile("matrix", ".csv");
            File file2 = File.createTempFile("matrix", ".csv");
            IntelligentFileWriter fw = new IntelligentFileWriter(file1);
            fw.write("---\t");
            int c = 0;
            while ((long)c < m.getColumnCount()) {
                fw.write("Col" + c + "\t");
                ++c;
            }
            fw.write("\n");
            int r = 0;
            while ((long)r < m.getRowCount()) {
                fw.write("Row" + r + "\t");
                int c2 = 0;
                while ((long)c2 < m.getColumnCount()) {
                    fw.write("" + m.getAsObject(r, c2));
                    fw.write("\t");
                    ++c2;
                }
                fw.write("\n");
                ++r;
            }
            fw.close();
            Class<?> c2 = Class.forName("Impute");
            Method me = c2.getMethod("main", String[].class);
            me.invoke(null, new Object[]{new String[]{file1.toString(), file2.toString(), "" + this.method}});
            m = MatrixFactory.importFromFile(FileFormat.CSV, file2, "\t");
            m = m.deleteRows(Calculation.Ret.NEW, 0L);
            m = m.deleteColumns(Calculation.Ret.NEW, 0L);
            m = m.replaceRegex(Calculation.Ret.NEW, ",", "");
            file1.delete();
            file2.delete();
            this.xImputed = m;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

