/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatFileInputStream;
import com.jmatio.io.MatTag;
import com.jmatio.io.MatlabIOException;
import com.jmatio.types.ByteStorageSupport;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLEmptyArray;
import com.jmatio.types.MLInt64;
import com.jmatio.types.MLInt8;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLSparse;
import com.jmatio.types.MLStructure;
import com.jmatio.types.MLUInt64;
import com.jmatio.types.MLUInt8;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import sun.misc.Cleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileReader {
    public static final int MEMORY_MAPPED_FILE = 1;
    public static final int DIRECT_BYTE_BUFFER = 2;
    public static final int HEAP_BYTE_BUFFER = 4;
    private MatFileHeader matFileHeader;
    private Map<String, MLArray> data;
    private ByteOrder byteOrder;
    private MatFileFilter filter = new MatFileFilter();
    private static final int DIRECT_BUFFER_LIMIT = 0x2000000;
    byte[] bytes;

    public MatFileReader(String string) throws FileNotFoundException, IOException {
        this(new File(string), new MatFileFilter());
    }

    public MatFileReader(String string, MatFileFilter matFileFilter) throws IOException {
        this(new File(string), matFileFilter);
    }

    public MatFileReader(File file) throws IOException {
        this(file, new MatFileFilter());
    }

    public MatFileReader(File file, MatFileFilter matFileFilter) throws IOException {
        this();
        this.read(file, matFileFilter, 1);
    }

    public MatFileReader() {
        this.data = new LinkedHashMap<String, MLArray>();
    }

    public synchronized Map<String, MLArray> read(File file) throws IOException {
        return this.read(file, new MatFileFilter(), 1);
    }

    public synchronized Map<String, MLArray> read(File file, int n) throws IOException {
        return this.read(file, new MatFileFilter(), n);
    }

    public synchronized Map<String, MLArray> read(File file, MatFileFilter matFileFilter, int n) throws IOException {
        Map<String, MLArray> map;
        RandomAccessFile randomAccessFile;
        WeakReference<MappedByteBuffer> weakReference;
        ByteBuffer byteBuffer;
        block24: {
            this.filter = matFileFilter;
            for (String object2 : this.data.keySet()) {
                this.data.remove(object2);
            }
            Object object3 = null;
            RandomAccessFile randomAccessFile2 = null;
            byteBuffer = null;
            weakReference = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                object3 = randomAccessFile.getChannel();
                switch (n) {
                    case 2: {
                        byteBuffer = ByteBuffer.allocateDirect((int)((FileChannel)object3).size());
                        ((FileChannel)object3).read(byteBuffer, 0L);
                        byteBuffer.rewind();
                        break;
                    }
                    case 4: {
                        int iOException = (int)((FileChannel)object3).size();
                        System.gc();
                        byteBuffer = ByteBuffer.allocate(iOException);
                        int n2 = iOException / 0x2000000 + (iOException % 0x2000000 > 0 ? 1 : 0);
                        if (n2 > 1) {
                            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(0x2000000);
                            for (int i = 0; i < n2; ++i) {
                                byteBuffer2.clear();
                                ((FileChannel)object3).read(byteBuffer2, i * 0x2000000);
                                byteBuffer2.flip();
                                byteBuffer.put(byteBuffer2);
                            }
                            byteBuffer2 = null;
                        } else {
                            ((FileChannel)object3).read(byteBuffer, 0L);
                        }
                        byteBuffer.rewind();
                        break;
                    }
                    case 1: {
                        byteBuffer = ((FileChannel)object3).map(FileChannel.MapMode.READ_ONLY, 0L, (int)((FileChannel)object3).size());
                        weakReference = new WeakReference<MappedByteBuffer>((MappedByteBuffer)byteBuffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown file allocation policy");
                    }
                }
                this.readHeader(byteBuffer);
                while (byteBuffer.remaining() > 0) {
                    this.readData(byteBuffer);
                }
                map = this.getContent();
                Object var13_16 = null;
                if (object3 == null) break block24;
            }
            catch (IOException iOException) {
                try {
                    throw iOException;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    if (object3 != null) {
                        ((AbstractInterruptibleChannel)object3).close();
                    }
                    if (randomAccessFile2 != null) {
                        randomAccessFile2.close();
                    }
                    if (byteBuffer != null && weakReference != null && n == 1) {
                        try {
                            this.clean(byteBuffer);
                        }
                        catch (Exception exception) {
                            int n3 = 1000;
                            byteBuffer = null;
                            long l = System.currentTimeMillis();
                            while (weakReference.get() != null && System.currentTimeMillis() - l <= (long)n3) {
                                System.gc();
                                Thread.yield();
                            }
                        }
                    }
                    throw throwable;
                }
            }
            ((AbstractInterruptibleChannel)object3).close();
        }
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        if (byteBuffer != null && weakReference != null && n == 1) {
            try {
                this.clean(byteBuffer);
            }
            catch (Exception exception) {
                int n4 = 1000;
                byteBuffer = null;
                long l = System.currentTimeMillis();
                while (weakReference.get() != null && System.currentTimeMillis() - l <= (long)n4) {
                    System.gc();
                    Thread.yield();
                }
            }
        }
        return map;
    }

    private void clean(final Object object) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = object.getClass().getMethod("cleaner", new Class[0]);
                    method.setAccessible(true);
                    Cleaner cleaner = (Cleaner)method.invoke(object, new Object[0]);
                    cleaner.clean();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }

    public MatFileHeader getMatFileHeader() {
        return this.matFileHeader;
    }

    public ArrayList<MLArray> getData() {
        return new ArrayList<MLArray>(this.data.values());
    }

    public MLArray getMLArray(String string) {
        return this.data.get(string);
    }

    public Map<String, MLArray> getContent() {
        return this.data;
    }

    private ByteBuffer inflate(ByteBuffer byteBuffer, int n) throws IOException {
        if (byteBuffer.remaining() < n) {
            throw new MatlabIOException("Compressed buffer length miscalculated!");
        }
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new _InputStreamFromBuffer(byteBuffer, n));
        byte[] byArray = new byte[128];
        _ByteArrayOutputStream _ByteArrayOutputStream2 = new _ByteArrayOutputStream(n);
        try {
            int n2;
            do {
                n2 = inflaterInputStream.read(byArray, 0, byArray.length);
                int n3 = Math.max(0, n2);
                _ByteArrayOutputStream2.write(byArray, 0, n3);
            } while (n2 > 0);
        }
        catch (IOException iOException) {
            throw new MatlabIOException("Could not decompress data: " + iOException);
        }
        finally {
            inflaterInputStream.close();
        }
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(_ByteArrayOutputStream2.getReferenceToByteArray(), 0, _ByteArrayOutputStream2.size());
        byteBuffer2.order(this.byteOrder);
        return byteBuffer2;
    }

    private void readData(ByteBuffer byteBuffer) throws IOException {
        ISMatTag iSMatTag = new ISMatTag(byteBuffer);
        switch (iSMatTag.type) {
            case 15: {
                this.readData(this.inflate(byteBuffer, iSMatTag.size));
                break;
            }
            case 14: {
                int n;
                int n2;
                int n3 = byteBuffer.position();
                MLArray mLArray = this.readMatrix(byteBuffer, true);
                if (mLArray != null) {
                    this.data.put(mLArray.getName(), mLArray);
                } else {
                    n2 = byteBuffer.position() - n3;
                    n = iSMatTag.size - n2;
                    byteBuffer.position(byteBuffer.position() + n);
                }
                n2 = byteBuffer.position() - n3;
                n = iSMatTag.size - n2;
                if (n == 0) break;
                throw new MatlabIOException("Matrix was not red fully! " + n + " remaining in the buffer.");
            }
            default: {
                throw new MatlabIOException("Incorrect data tag: " + iSMatTag);
            }
        }
    }

    private MLArray readMatrix(ByteBuffer byteBuffer, boolean bl) throws IOException {
        MLArray mLArray;
        int[] nArray = this.readFlags(byteBuffer);
        int n = nArray.length != 0 ? nArray[0] : 0;
        int n2 = nArray.length != 0 ? nArray[1] : 0;
        int n3 = n & 0xFF;
        int[] nArray2 = this.readDimension(byteBuffer);
        String string = this.readName(byteBuffer);
        if (bl && !this.filter.matches(string)) {
            return null;
        }
        switch (n3) {
            case 2: {
                int n4;
                MLStructure mLStructure = new MLStructure(string, nArray2, n3, n);
                ISMatTag iSMatTag = new ISMatTag(byteBuffer);
                int n5 = byteBuffer.getInt();
                iSMatTag = new ISMatTag(byteBuffer);
                int n6 = iSMatTag.size / n5;
                int n7 = iSMatTag.size % 8 != 0 ? 8 - iSMatTag.size % 8 : 0;
                String[] stringArray = new String[n6];
                for (n4 = 0; n4 < n6; ++n4) {
                    byte[] byArray = new byte[n5];
                    byteBuffer.get(byArray);
                    stringArray[n4] = this.zeroEndByteArrayToString(byArray);
                }
                byteBuffer.position(byteBuffer.position() + n7);
                for (n4 = 0; n4 < mLStructure.getM() * mLStructure.getN(); ++n4) {
                    for (int i = 0; i < n6; ++i) {
                        iSMatTag = new ISMatTag(byteBuffer);
                        if (iSMatTag.size > 0) {
                            MLArray mLArray2 = this.readMatrix(byteBuffer, false);
                            mLStructure.setField(stringArray[i], mLArray2, n4);
                            continue;
                        }
                        mLStructure.setField(stringArray[i], new MLEmptyArray(), n4);
                    }
                }
                mLArray = mLStructure;
                break;
            }
            case 1: {
                MLCell mLCell = new MLCell(string, nArray2, n3, n);
                for (int i = 0; i < mLCell.getM() * mLCell.getN(); ++i) {
                    ISMatTag iSMatTag = new ISMatTag(byteBuffer);
                    if (iSMatTag.size > 0) {
                        MLArray mLArray3 = this.readMatrix(byteBuffer, false);
                        mLCell.set(mLArray3, i);
                        continue;
                    }
                    mLCell.set(new MLEmptyArray(), i);
                }
                mLArray = mLCell;
                break;
            }
            case 6: {
                mLArray = new MLDouble(string, nArray2, n3, n);
                ISMatTag iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getRealByteBuffer(), (MLNumericArray)mLArray);
                if (!mLArray.isComplex()) break;
                iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getImaginaryByteBuffer(), (MLNumericArray)mLArray);
                break;
            }
            case 9: {
                mLArray = new MLUInt8(string, nArray2, n3, n);
                ISMatTag iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getRealByteBuffer(), (MLNumericArray)mLArray);
                if (!mLArray.isComplex()) break;
                iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getImaginaryByteBuffer(), (MLNumericArray)mLArray);
                break;
            }
            case 8: {
                mLArray = new MLInt8(string, nArray2, n3, n);
                ISMatTag iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getRealByteBuffer(), (MLNumericArray)mLArray);
                if (!mLArray.isComplex()) break;
                iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getImaginaryByteBuffer(), (MLNumericArray)mLArray);
                break;
            }
            case 14: {
                mLArray = new MLInt64(string, nArray2, n3, n);
                ISMatTag iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getRealByteBuffer(), (MLNumericArray)mLArray);
                if (!mLArray.isComplex()) break;
                iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getImaginaryByteBuffer(), (MLNumericArray)mLArray);
                break;
            }
            case 15: {
                mLArray = new MLUInt64(string, nArray2, n3, n);
                ISMatTag iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getRealByteBuffer(), (MLNumericArray)mLArray);
                if (!mLArray.isComplex()) break;
                iSMatTag = new ISMatTag(byteBuffer);
                iSMatTag.readToByteBuffer(((MLNumericArray)mLArray).getImaginaryByteBuffer(), (MLNumericArray)mLArray);
                break;
            }
            case 4: {
                MLChar mLChar = new MLChar(string, nArray2, n3, n);
                ISMatTag iSMatTag = new ISMatTag(byteBuffer);
                char[] cArray = iSMatTag.readToCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    mLChar.setChar(cArray[i], i);
                }
                mLArray = mLChar;
                break;
            }
            case 5: {
                MLSparse mLSparse = new MLSparse(string, nArray2, n, n2);
                ISMatTag iSMatTag = new ISMatTag(byteBuffer);
                int[] nArray3 = iSMatTag.readToIntArray();
                iSMatTag = new ISMatTag(byteBuffer);
                int[] nArray4 = iSMatTag.readToIntArray();
                iSMatTag = new ISMatTag(byteBuffer);
                double[] dArray = iSMatTag.readToDoubleArray();
                int n8 = 0;
                for (int i = 0; i < mLSparse.getN(); ++i) {
                    while (n8 < nArray4[i + 1]) {
                        mLSparse.setReal(dArray[n8], nArray3[n8], i);
                        ++n8;
                    }
                }
                if (mLSparse.isComplex()) {
                    iSMatTag = new ISMatTag(byteBuffer);
                    double[] dArray2 = iSMatTag.readToDoubleArray();
                    n8 = 0;
                    for (int i = 0; i < mLSparse.getN(); ++i) {
                        while (n8 < nArray4[i + 1]) {
                            mLSparse.setImaginary(dArray2[n8], nArray3[n8], i);
                            ++n8;
                        }
                    }
                }
                mLArray = mLSparse;
                break;
            }
            default: {
                throw new MatlabIOException("Incorrect matlab array class: " + MLArray.typeToString(n3));
            }
        }
        return mLArray;
    }

    private String zeroEndByteArrayToString(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (int i = 0; i < byArray.length && byArray[i] != 0; ++i) {
            dataOutputStream.writeByte(byArray[i]);
        }
        return byteArrayOutputStream.toString();
    }

    private int[] readFlags(ByteBuffer byteBuffer) throws IOException {
        ISMatTag iSMatTag = new ISMatTag(byteBuffer);
        int[] nArray = iSMatTag.readToIntArray();
        return nArray;
    }

    private int[] readDimension(ByteBuffer byteBuffer) throws IOException {
        ISMatTag iSMatTag = new ISMatTag(byteBuffer);
        int[] nArray = iSMatTag.readToIntArray();
        return nArray;
    }

    private String readName(ByteBuffer byteBuffer) throws IOException {
        ISMatTag iSMatTag = new ISMatTag(byteBuffer);
        char[] cArray = iSMatTag.readToCharArray();
        String string = new String(cArray);
        return string;
    }

    private void readHeader(ByteBuffer byteBuffer) throws IOException {
        int n;
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[116];
        byteBuffer.get(byArray2);
        String string = this.zeroEndByteArrayToString(byArray2);
        if (!string.matches("MATLAB 5.0 MAT-file.*")) {
            throw new MatlabIOException("This is not a valid MATLAB 5.0 MAT-file.");
        }
        byteBuffer.position(byteBuffer.position() + 8);
        byte[] byArray3 = new byte[2];
        byteBuffer.get(byArray3);
        byteBuffer.get(byArray);
        if ((char)byArray[0] == 'I' && (char)byArray[1] == 'M') {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            n = byArray3[1] & 0xFF | byArray3[0] << 8;
        } else {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            n = byArray3[0] & 0xFF | byArray3[1] << 8;
        }
        byteBuffer.order(this.byteOrder);
        this.matFileHeader = new MatFileHeader(string, n, byArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ISMatTag
    extends MatTag {
        public ByteBuffer buf;
        private int padding;

        public ISMatTag(ByteBuffer byteBuffer) throws IOException {
            super(0, 0);
            boolean bl;
            this.buf = byteBuffer;
            int n = byteBuffer.getInt();
            if (n >> 16 == 0) {
                this.type = n;
                this.size = byteBuffer.getInt();
                bl = false;
            } else {
                this.size = n >> 16;
                this.type = n & 0xFFFF;
                bl = true;
            }
            this.padding = this.getPadding(this.size, bl);
        }

        public void readToByteBuffer(ByteBuffer byteBuffer, ByteStorageSupport<?> byteStorageSupport) throws IOException {
            MatFileInputStream matFileInputStream = new MatFileInputStream(this.buf, this.type);
            int n = this.size / this.sizeOf();
            matFileInputStream.readToByteBuffer(byteBuffer, n, byteStorageSupport);
            if (this.padding > 0) {
                this.buf.position(this.buf.position() + this.padding);
            }
        }

        public byte[] readToByteArray() throws IOException {
            int n = this.size / this.sizeOf();
            byte[] byArray = new byte[n];
            MatFileInputStream matFileInputStream = new MatFileInputStream(this.buf, this.type);
            for (int i = 0; i < n; ++i) {
                byArray[i] = matFileInputStream.readByte();
            }
            if (this.padding > 0) {
                this.buf.position(this.buf.position() + this.padding);
            }
            return byArray;
        }

        public double[] readToDoubleArray() throws IOException {
            int n = this.size / this.sizeOf();
            double[] dArray = new double[n];
            MatFileInputStream matFileInputStream = new MatFileInputStream(this.buf, this.type);
            for (int i = 0; i < n; ++i) {
                dArray[i] = matFileInputStream.readDouble();
            }
            if (this.padding > 0) {
                this.buf.position(this.buf.position() + this.padding);
            }
            return dArray;
        }

        public int[] readToIntArray() throws IOException {
            int n = this.size / this.sizeOf();
            int[] nArray = new int[n];
            MatFileInputStream matFileInputStream = new MatFileInputStream(this.buf, this.type);
            for (int i = 0; i < n; ++i) {
                nArray[i] = matFileInputStream.readInt();
            }
            if (this.padding > 0) {
                this.buf.position(this.buf.position() + this.padding);
            }
            return nArray;
        }

        public char[] readToCharArray() throws IOException {
            int n = this.size / this.sizeOf();
            char[] cArray = new char[n];
            MatFileInputStream matFileInputStream = new MatFileInputStream(this.buf, this.type);
            for (int i = 0; i < n; ++i) {
                cArray[i] = matFileInputStream.readChar();
            }
            if (this.padding > 0) {
                this.buf.position(this.buf.position() + this.padding);
            }
            return cArray;
        }
    }

    private static class _InputStreamFromBuffer
    extends InputStream {
        private ByteBuffer buf;
        private int limit;

        public _InputStreamFromBuffer(ByteBuffer byteBuffer, int n) {
            this.buf = byteBuffer;
            this.limit = n;
        }

        public synchronized int read() throws IOException {
            throw new RuntimeException("Not yet implemented");
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.limit <= 0) {
                return -1;
            }
            n2 = Math.min(n2, this.limit);
            this.buf.get(byArray, n, n2);
            this.limit -= n2;
            return n2;
        }
    }

    private static class _ByteArrayOutputStream
    extends ByteArrayOutputStream {
        _ByteArrayOutputStream() {
        }

        _ByteArrayOutputStream(int n) {
            super(n);
        }

        byte[] getReferenceToByteArray() {
            return this.buf;
        }
    }
}

