/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.automata;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.automata.AutomatonException;

public class FiniteAutomaton {
    private FiniteAlphabet alfa;
    private AlphabetIndex alfaIdx;
    private String name;
    private int nodeCount = 2;
    protected Set nodes = new HashSet();
    protected Set transitions = new HashSet();
    private Map transitionMap = new HashMap();
    private int START = 0;
    private int END = -1;
    protected Node start;
    protected Node end;

    FiniteAutomaton(String name, FiniteAlphabet alfa) {
        this.alfa = alfa;
        this.name = name;
        this.alfaIdx = AlphabetManager.getAlphabetIndex(alfa);
        this.start = new Node(this.START);
        this.nodes.add(this.start);
        this.end = new Node(this.END);
        this.nodes.add(this.end);
    }

    FiniteAlphabet getAlphabet() {
        return this.alfa;
    }

    String getName() {
        return this.name;
    }

    public Node getStart() {
        return this.start;
    }

    public Node getEnd() {
        return this.end;
    }

    public FiniteAutomaton getAutomaton() {
        return this;
    }

    public Transition addTransition(Node start, Node end, Symbol sym) {
        Transition newTransition = new Transition(start, end, sym);
        this.transitions.add(newTransition);
        return newTransition;
    }

    public Node addNode(boolean terminal) {
        Node node = new Node(terminal);
        this.nodes.add(node);
        return node;
    }

    int nodeCount() {
        return this.nodes.size();
    }

    public NodeSet getNodes() {
        NodeSet nodeSet = this.createNodeSet();
        nodeSet.addAll(this.nodes);
        return nodeSet;
    }

    NodeSet getClosure(Node source, Symbol sym) {
        NodeSet closureSet = this.createNodeSet();
        Iterator transI = this.getTransitions(source).iterator();
        while (transI.hasNext()) {
            Transition currTransition = (Transition)transI.next();
            try {
                if (currTransition.sym != sym) continue;
                closureSet.addNode(currTransition.dest);
            }
            catch (AutomatonException ae) {
                throw new AssertionError((Object)ae);
            }
        }
        return closureSet;
    }

    Set getSymbols(Node source) {
        HashSet<Symbol> symbolSet = new HashSet<Symbol>();
        Iterator transI = this.getTransitions(source).iterator();
        while (transI.hasNext()) {
            Transition currTransition = (Transition)transI.next();
            symbolSet.add(currTransition.sym);
        }
        return symbolSet;
    }

    public Set getTransitions() {
        return Collections.unmodifiableSet(this.transitions);
    }

    private Set getTransitions(Node source) {
        HashSet<Transition> transitionSet = (HashSet<Transition>)this.transitionMap.get(source);
        if (transitionSet == null) {
            transitionSet = new HashSet<Transition>();
            Iterator transI = this.transitions.iterator();
            while (transI.hasNext()) {
                Transition currTransition = (Transition)transI.next();
                if (currTransition.source != source) continue;
                transitionSet.add(currTransition);
            }
            this.transitionMap.put(source, transitionSet);
        }
        return transitionSet;
    }

    public NodeSet createNodeSet() {
        return new NodeSet();
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("Nodes: ");
        int count = 0;
        Iterator nodeI = this.nodes.iterator();
        while (nodeI.hasNext()) {
            Node node = (Node)nodeI.next();
            if (count++ != 0) {
                output.append(", ");
            }
            output.append(node.getID());
        }
        output.append("\n");
        output.append("Transitions: source, dest, symbol\n");
        Iterator tranI = this.transitions.iterator();
        while (tranI.hasNext()) {
            Transition trans = (Transition)tranI.next();
            output.append(trans.toString());
            output.append("\n");
        }
        return output.toString();
    }

    protected int alphaIndex(Symbol sym) throws IllegalSymbolException {
        if (sym == null) {
            return 999;
        }
        return this.alfaIdx.indexForSymbol(sym);
    }

    class Transition {
        protected Node source;
        protected Node dest;
        protected Symbol sym;

        private Transition(Node source, Node dest, Symbol sym) {
            this.source = source;
            this.dest = dest;
            this.sym = sym;
        }

        Node getSource() {
            return this.source;
        }

        Node getDest() {
            return this.dest;
        }

        Symbol getSymbol() {
            return this.sym;
        }

        void setSource(Node source) throws AutomatonException {
            if (source.parent() != FiniteAutomaton.this) {
                throw new AutomatonException("Attempt to Node from one Model in another.");
            }
            this.source = source;
        }

        void setDest(Node dest) throws AutomatonException {
            if (dest.parent() != FiniteAutomaton.this) {
                throw new AutomatonException("Attempt to Node from one Model in another.");
            }
            this.dest = dest;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Transition)) {
                return false;
            }
            Transition other = (Transition)o;
            if (other.parent() != this.parent()) {
                return false;
            }
            return this.source.equals(other.source) && this.dest.equals(other.dest) && this.sym == other.getSymbol();
        }

        public FiniteAutomaton parent() {
            return FiniteAutomaton.this;
        }

        public int hashCode() {
            try {
                return (this.source.getID() << 20) + (this.dest.getID() << 10) + FiniteAutomaton.this.alphaIndex(this.sym);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Fatal error: Unexpected IllegalSymbolException on computing indexForSymbol.");
            }
        }

        public String toString() {
            StringBuffer output = new StringBuffer();
            try {
                SymbolTokenization toke = FiniteAutomaton.this.alfa.getTokenization("token");
                output.append(this.source.getID());
                output.append("\t");
                output.append(this.dest.getID());
                output.append("\t");
                output.append(this.sym == null ? "EPSILON" : toke.tokenizeSymbol(this.sym));
                return output.toString();
            }
            catch (IllegalSymbolException ise) {
                throw new AssertionError((Object)ise);
            }
            catch (BioException be) {
                throw new AssertionError((Object)be);
            }
        }
    }

    class NodeSet
    extends HashSet {
        NodeSet() {
        }

        void addNode(Node node) throws AutomatonException {
            if (!FiniteAutomaton.this.nodes.contains(node)) {
                throw new AutomatonException("attempt to add foreign Node to this NodeSet.");
            }
            this.add(node);
        }

        void addNodeSet(NodeSet otherSet) throws AutomatonException {
            if (otherSet.parent() != FiniteAutomaton.this) {
                throw new AutomatonException("attempt to add foreign NodeSet to this NodeSet.");
            }
            this.addAll(otherSet);
        }

        public boolean equals(Object o) {
            if (!(o instanceof NodeSet)) {
                return false;
            }
            NodeSet other = (NodeSet)o;
            if (this.parent() != other.parent()) {
                return false;
            }
            return super.equals(o);
        }

        public int hashCode() {
            int sum = 0;
            Iterator setI = this.iterator();
            while (setI.hasNext()) {
                sum += setI.next().hashCode();
            }
            return sum;
        }

        FiniteAutomaton parent() {
            return FiniteAutomaton.this;
        }

        public String toString() {
            StringBuffer output = new StringBuffer();
            output.append("[");
            int count = 0;
            Iterator nodeI = this.iterator();
            while (nodeI.hasNext()) {
                Node node = (Node)nodeI.next();
                if (count++ != 0) {
                    output.append(", ");
                }
                output.append(node.getID());
            }
            output.append("]");
            return output.toString();
        }
    }

    class Node {
        private int nodeID;

        protected Node(boolean terminal) {
            this.nodeID = terminal ? -FiniteAutomaton.this.nodeCount++ : FiniteAutomaton.this.nodeCount++;
        }

        protected Node(int nodeID) {
            this.nodeID = nodeID;
        }

        boolean isTerminal() {
            return this.nodeID < 0;
        }

        int getID() {
            return this.nodeID;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (other.parent() != this.parent()) {
                return false;
            }
            return other.getID() != this.getID();
        }

        public FiniteAutomaton parent() {
            return FiniteAutomaton.this;
        }

        public int hashCode() {
            return this.nodeID;
        }

        public String toString() {
            return "Node: " + this.nodeID;
        }
    }
}

