/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.basic;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class Atimes
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 4170937261358240120L;
    private boolean ignoreNaN = false;
    private long[] size = null;

    public Atimes(boolean ignoreNaN, Matrix m1, Matrix m2) {
        super(m1, m2);
        this.ignoreNaN = ignoreNaN;
        this.size = new long[]{m1.getRowCount(), m2.getColumnCount()};
    }

    public Atimes() {
        super(new Matrix[0]);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        Matrix m1 = this.getSources()[0];
        Matrix m2 = this.getSources()[1];
        long row = coordinates[0];
        long col = coordinates[1];
        double sum = 0.0;
        double count = 0.0;
        if (this.ignoreNaN) {
            long k = m1.getColumnCount();
            while (--k >= 0L) {
                double v1 = m1.getAsDouble(row, k);
                double v2 = m2.getAsDouble(k, col);
                if (MathUtil.isNaNOrInfinite(v1) || MathUtil.isNaNOrInfinite(v2)) continue;
                sum += v1 * v2;
                count += 1.0;
            }
        } else {
            long k = m1.getColumnCount();
            while (--k >= 0L) {
                double v1 = m1.getAsDouble(row, k);
                double v2 = m2.getAsDouble(k, col);
                sum += v1 * v2;
                count += 1.0;
            }
        }
        return sum / count;
    }

    public long[] getSize() {
        return this.size;
    }
}

