/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.basic;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;

public class Log
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 4197072098253310072L;

    public Log(Matrix matrix) {
        super(matrix);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        return Math.log(this.getSource().getAsDouble(coordinates));
    }

    public static Matrix calc(Matrix source) throws MatrixException {
        Matrix ret = Matrix.factory.zeros(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            ret.setAsDouble(Math.log(source.getAsDouble(c)), c);
        }
        return ret;
    }
}

