/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.stringmatrix.stub.AbstractDenseStringMatrix2D;

public class SimpleDenseStringMatrix2D
extends AbstractDenseStringMatrix2D {
    private static final long serialVersionUID = -4292004796378125964L;
    private String[][] values = null;

    public SimpleDenseStringMatrix2D(String string) {
        string = string.replaceAll("[\\[\\]\\(\\)\\{\\}]", "");
        String[] rows = string.split("\\s*[;\\n]\\s*");
        String[] cols = rows[0].split("[,\\s*]");
        this.values = new String[rows.length][cols.length];
        int r = 0;
        while (r < rows.length) {
            cols = rows[r].split("[,\\s*]");
            int c = 0;
            while (c < cols.length) {
                this.values[r][c] = cols[c];
                ++c;
            }
            ++r;
        }
    }

    public SimpleDenseStringMatrix2D(Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setAsString(source.getAsString(c), c);
        }
    }

    public SimpleDenseStringMatrix2D(long ... size) {
        this.values = new String[(int)size[0]][(int)size[1]];
    }

    public SimpleDenseStringMatrix2D(String[] ... values) {
        this.values = values;
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public String getString(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setString(String value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }
}

