/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class SerializationUtil {
    public static void serialize(Serializable obj, OutputStream outputStream) throws IOException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(obj);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Object deserialize(InputStream inputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(inputStream);
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Serializable o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SerializationUtil.serialize(o, bos);
        return bos.toByteArray();
    }

    public static Object deserialize(byte[] data) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Object o = SerializationUtil.deserialize(bis);
        return o;
    }

    public static long sizeOf(Serializable o) throws IOException {
        return SerializationUtil.serialize(o).length;
    }
}

