package org.baderlab.pdzsvmstruct.encoding;

import org.baderlab.pdzsvmstruct.data.manager.DataFileManager;
import org.baderlab.pdzsvmstruct.utils.BindingSiteUtils;
import org.baderlab.pdzsvmstruct.utils.Constants;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.*;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class JoyFeatureEncoding extends FeatureEncoding {

    private String HBOND_MAIN_CHAIN_AMIDE_BF = "\\bf";
    private String HBOND_MAIN_CHAIN_AMIDE_PMB = "\\pmb";
    private String DISULPHIDE_BOND = "\\c";
    private String HBOND_MAIN_CHAIN_CARBONYL = "\\underline";
    private String POS_PHI_TORSION_ANGLE = "\\it";
    private String HBOND_MAIN_CHAIN_OTHER = "\\~";

    private int SOLVENT_ACC_IX = 0;
    private int HBOND_MAIN_CHAIN_AMIDE_IX = 1;
    private int HBOND_MAIN_CHAIN_CARBONYL_IX = 2;
    private int HBOND_MAIN_CHAIN_OTHER_IX =3;
    private int POS_PHI_TORSION_ANGLE_IX = 4;

    private int DISULPHIDE_BOND_IX = 5;
    private int SOLVENT_INACC_IX = 1;

    /*public static String[] featureNames = new String[]{"Solvent Accessibility","Solvent Inaccessibility","HBond Main Chain Amide",
            "HBond Main Chain Carbonyl","HBond Main Chain Other","Disulphide Bond",
            "Phi Torsion Angle"};
    */
    public static String[] featureNames = new String[]{"Solvent Accessibility","HBond Main Chain Amide",
            "HBond Main Chain Carbonyl","HBond Main Chain Other","Phi Torsion Angle"};
    private HashMap domainNameToFileNameMap;
    private String organism= "";
    private String joyDir = "";
    private BindingSiteUtils bindingSite;


    public JoyFeatureEncoding(String organism)
    {
        setEncodingName("JOY");

        this.organism = organism;
        bindingSite = new BindingSiteUtils(organism);

        if (organism.equals(Constants.HUMAN))
            joyDir = DataFileManager.DATA_ROOT_DIR +"/Data/Human/PDZ/Joy/";
        else if (organism.equals(Constants.MOUSE)||
                organism.equals(Constants.MOUSE_ORPHAN))
            joyDir = DataFileManager.DATA_ROOT_DIR +"/Data/Mouse/PDZ/Joy/";
        else if (organism.equals(Constants.FLY))
            joyDir = DataFileManager.DATA_ROOT_DIR +"/Data/Fly/PDZ/Joy/";
        else if (organism.equals(Constants.WORM))
            joyDir = DataFileManager.DATA_ROOT_DIR +"/Data/Worm/PDZ/Joy/";
        initDomainNameToTexFileNameMap(organism);

    }

    private void initDomainNameToTexFileNameMap(String organism)
    {
        domainNameToFileNameMap = new HashMap();
        if (organism.equals(Constants.HUMAN))
        {
            //SIDHU_HUMAN_PDB
            domainNameToFileNameMap.put("CASK-1", "1KWA.tex");
            domainNameToFileNameMap.put("DLG3-2","2FE5.tex");
            //domainNameToFileNameMap.put("DVL2-1", "2REY.tex");
            domainNameToFileNameMap.put("ERBB2IP-1", "1MFL.tex");
            //domainNameToFileNameMap.put("MPDZ-1", "2O2T.tex");
            domainNameToFileNameMap.put("MPDZ-1", "SWISSMODEL-MPDZ-1.tex");

            domainNameToFileNameMap.put("MPDZ-10", "2OPG.tex");
            //domainNameToFileNameMap.put("MPDZ-12", "2IWO.tex");
            domainNameToFileNameMap.put("MPDZ-12", "SWISSMODEL-MPDZ-12.tex");

            //domainNameToFileNameMap.put("MPDZ-13", "2FNE.tex");
            //domainNameToFileNameMap.put("MPDZ-3", "2IWN.tex");
            domainNameToFileNameMap.put("MPDZ-3", "SWISSMODEL-MPDZ-3.tex");

            //domainNameToFileNameMap.put("PDLIM2-1", "2PA1.tex");
            //domainNameToFileNameMap.put("PSCDBP-1", "2Z17.tex");
            domainNameToFileNameMap.put("SCRIB-1", "2W4F.tex");
            domainNameToFileNameMap.put("SLC9A3R2-2", "2HE4.tex");
            domainNameToFileNameMap.put("DLG1-2", "2G2L.tex");
            domainNameToFileNameMap.put("DLG4-3", "1TP3.tex");
            domainNameToFileNameMap.put("PDLIM4-1", "2V1W.tex");
            domainNameToFileNameMap.put("DLG2-3", "2HE2.tex");
            domainNameToFileNameMap.put("INADL-2", "2DLU.tex");
            domainNameToFileNameMap.put("SCRIB-2", "1WHA.tex");

            domainNameToFileNameMap.put("DLG1-3", "SWISSMODEL-DLG1-3.tex");
          domainNameToFileNameMap.put("SHANK3-1", "SWISSMODEL-SHANK3-1.tex");
            domainNameToFileNameMap.put("SNTA1-1", "SWISSMODEL-SNTA1-1.tex");
            domainNameToFileNameMap.put("DLG1-1", "SWISSMODEL-DLG1-1.tex");
            domainNameToFileNameMap.put("MPP6-1", "SWISSMODEL-MPP6-1.tex");
            domainNameToFileNameMap.put("PDZK1-1", "SWISSMODEL-PDZK1-1.tex");
            
          domainNameToFileNameMap.put("LRRC7-1", "SWISSMODEL-LRRC7-1.tex");
            //domainNameToFileNameMap.put("APBA3-1", "2YT7.tex");
            domainNameToFileNameMap.put("APBA3-1", "SWISSMODEL-APBA3-1.tex");
            domainNameToFileNameMap.put("PSCDBP-1", "2Z17.tex");
            domainNameToFileNameMap.put("MPDZ-7", "2IWQ.tex");
            domainNameToFileNameMap.put("MPDZ-2", "SWISSMODEL-MPDZ-2.tex");

            // PROTEOME SCANNING
            domainNameToFileNameMap.put("MPDZ-11","2QG1.tex");
            domainNameToFileNameMap.put("MPDZ-13","2FNE.tex");
            domainNameToFileNameMap.put("MPDZ-4", "SWISSMODEL-MPDZ-4.tex");
            domainNameToFileNameMap.put("MPDZ-5", "SWISSMODEL-MPDZ-5.tex");
            domainNameToFileNameMap.put("MPDZ-6", "SWISSMODEL-MPDZ-6.tex");
            domainNameToFileNameMap.put("MPDZ-8", "SWISSMODEL-MPDZ-8.tex");
            domainNameToFileNameMap.put("MPDZ-9", "SWISSMODEL-MPDZ-9.tex");
            //domainNameToFileNameMap.put("INADL-1", "2DB5.tex");
            //domainNameToFileNameMap.put("INADL-3", "2DMZ.tex");
            domainNameToFileNameMap.put("INADL-5", "2D92.tex");
            domainNameToFileNameMap.put("INADL-1", "SWISSMODEL-INADL-1.tex");
            domainNameToFileNameMap.put("INADL-3", "SWISSMODEL-INADL-3.tex");
            //domainNameToFileNameMap.put("INADL-5", "SWISSMODEL-INADL-5.tex");
            domainNameToFileNameMap.put("INADL-6", "2EHR.tex");
            domainNameToFileNameMap.put("INADL-7", "2DAZ.tex");
            domainNameToFileNameMap.put("INADL-8", "2DM8.tex");
            //domainNameToFileNameMap.put("INADL-7", "SWISSMODEL-INADL-7.tex");
            //domainNameToFileNameMap.put("INADL-8", "SWISSMODEL-INADL-8.tex");
            domainNameToFileNameMap.put("INADL-9", "SWISSMODEL-INADL-9.tex");
            domainNameToFileNameMap.put("INADL-10", "SWISSMODEL-INADL-10.tex");
            domainNameToFileNameMap.put("GRIP2-1", "SWISSMODEL-GRIP2-1.tex");
            domainNameToFileNameMap.put("GRIP2-2", "SWISSMODEL-GRIP2-2.tex");
            domainNameToFileNameMap.put("GRIP2-3", "1V62.tex");
            domainNameToFileNameMap.put("GRIP2-4", "1X5R.tex");
            domainNameToFileNameMap.put("GRIP2-5", "SWISSMODEL-GRIP2-5.tex");
            domainNameToFileNameMap.put("GRIP2-6", "SWISSMODEL-GRIP2-6.tex");
            domainNameToFileNameMap.put("GRIP2-7", "SWISSMODEL-GRIP2-7.tex");
            domainNameToFileNameMap.put("SCRIB-3", "SWISSMODEL-SCRIB-3.tex");
            domainNameToFileNameMap.put("SCRIB-4", "1UJU.tex");
            domainNameToFileNameMap.put("GRIP1-1", "SWISSMODEL-GRIP1-1.tex");
            domainNameToFileNameMap.put("GRIP1-2", "2JIL.tex");
            domainNameToFileNameMap.put("GRIP1-3", "SWISSMODEL-GRIP1-3.tex");
            domainNameToFileNameMap.put("GRIP1-4", "SWISSMODEL-GRIP1-4.tex");
            domainNameToFileNameMap.put("GRIP1-5", "SWISSMODEL-GRIP1-5.tex");
            domainNameToFileNameMap.put("GRIP1-6", "SWISSMODEL-GRIP1-6.tex");
            domainNameToFileNameMap.put("GRIP1-7", "SWISSMODEL-GRIP1-7.tex");
            domainNameToFileNameMap.put("PTPN13-1", "SWISSMODEL-PTPN13-1.tex");
            domainNameToFileNameMap.put("PTPN13-3", "SWISSMODEL-PTPN13-3.tex");
            domainNameToFileNameMap.put("PTPN13-4", "SWISSMODEL-PTPN13-4.tex");
            domainNameToFileNameMap.put("PTPN13-5", "SWISSMODEL-PTPN13-5.tex");

            //domainNameToFileNameMap.put("MAGI1-1", "SWISSMODEL-MAGI1-1.tex"); 
            domainNameToFileNameMap.put("MAGI1-2", "2KPK.tex");
            domainNameToFileNameMap.put("MAGI1-3", "SWISSMODEL-MAGI1-3.tex");
            domainNameToFileNameMap.put("MAGI1-4", "SWISSMODEL-MAGI1-4.tex");
            domainNameToFileNameMap.put("MAGI1-5", "SWISSMODEL-MAGI1-5.tex");
            domainNameToFileNameMap.put("MAGI1-6", "SWISSMODEL-MAGI1-6.tex");
            
            domainNameToFileNameMap.put("MAGI2-1", "SWISSMODEL-MAGI2-1.tex");
            domainNameToFileNameMap.put("MAGI2-2", "1UEQ.tex");
            domainNameToFileNameMap.put("MAGI2-3", "SWISSMODEL-MAGI2-3.tex");
            domainNameToFileNameMap.put("MAGI2-4", "1UEP.tex");
            domainNameToFileNameMap.put("MAGI2-5", "SWISSMODEL-MAGI2-5.tex");
            domainNameToFileNameMap.put("MAGI2-6", "1WFV.tex");

            //domainNameToFileNameMap.put("MAGI3-1", "SWISSMODEL-MAGI3-1.tex");
            domainNameToFileNameMap.put("MAGI3-2", "SWISSMODEL-MAGI3-2.tex");
            domainNameToFileNameMap.put("MAGI3-3", "SWISSMODEL-MAGI3-3.tex");
            domainNameToFileNameMap.put("MAGI3-4", "SWISSMODEL-MAGI3-4.tex");
            domainNameToFileNameMap.put("MAGI3-5", "SWISSMODEL-MAGI3-5.tex");
            domainNameToFileNameMap.put("MAGI3-6", "SWISSMODEL-MAGI3-6.tex");

            //domainNameToFileNameMap.put("PDZD2-1", "SWISSMODEL-PDZD2-1.tex");
            domainNameToFileNameMap.put("PDZD2-2", "SWISSMODEL-PDZD2-2.tex");
            domainNameToFileNameMap.put("PDZD2-3", "SWISSMODEL-PDZD2-3.tex");
            domainNameToFileNameMap.put("PDZD2-4", "SWISSMODEL-PDZD2-4.tex");
            domainNameToFileNameMap.put("PDZD2-5", "SWISSMODEL-PDZD2-5.tex");
            //domainNameToFileNameMap.put("PDZD2-6", "SWISSMODEL-PDZD2-6.tex");
            
            domainNameToFileNameMap.put("DLG4-1", "SWISSMODEL-DLG4-1.tex");
            domainNameToFileNameMap.put("DLG4-2", "SWISSMODEL-DLG4-2.tex");
            domainNameToFileNameMap.put("DLG2-1", "SWISSMODEL-DLG2-1.tex");
            //domainNameToFileNameMap.put("DLG2-2", "2BYG.tex");
            domainNameToFileNameMap.put("DLG2-2", "SWISSMODEL-DLG2-2.tex");
            //domainNameToFileNameMap.put("LNX2-1", "SWISSMODEL-LNX2-1");
            //domainNameToFileNameMap.put("LNX2-2", "2VWR-LNX2-2");
            //domainNameToFileNameMap.put("LNX2-3", "SWISSMODEL-LNX2-3");
            //domainNameToFileNameMap.put("LNX2-4", "SWISSMODEL-LNX2-4");

            domainNameToFileNameMap.put("DLG3-1", "2I1N.tex");
            domainNameToFileNameMap.put("DLG3-3", "1UM7.tex");
             //domainNameToFileNameMap.put("LNX2-1", "SWISSMODEL-LNX2-1");
            //domainNameToFileNameMap.put("LNX2-2", "2VWR-LNX2-2");
            //domainNameToFileNameMap.put("LNX2-3", "SWISSMODEL-LNX2-3");
            //domainNameToFileNameMap.put("LNX2-4", "SWISSMODEL-LNX2-4");
            domainNameToFileNameMap.put("DLG3-1", "2I1N.tex");
            domainNameToFileNameMap.put("DLG3-3", "1UM7.tex");
            //domainNameToFileNameMap.put("LNX1-1", "SWISSMODEL-LNX1-1");
            //domainNameToFileNameMap.put("LNX1-2", "SWISSMODEL-LNX1-2");
            //domainNameToFileNameMap.put("LNX1-3", "SWISSMODEL-LNX1-3");
            //domainNameToFileNameMap.put("LNX1-4", "SWISSMODEL-LNX1-4");
            domainNameToFileNameMap.put("PDZK1-2", "2EEI.tex");
            domainNameToFileNameMap.put("PDZK1-3", "SWISSMODEL-PDZK1-3.tex");
            //domainNameToFileNameMap.put("PDZK1-4", "2VSP-PDZK1-4");
            domainNameToFileNameMap.put("TJP1-1", "2H2C.tex");
            domainNameToFileNameMap.put("TJP1-2", "2RCZ.tex");
            domainNameToFileNameMap.put("TJP1-3", "SWISSMODEL-TJP1-3.tex");
            domainNameToFileNameMap.put("PDZD3-1", "SWISSMODEL-PDZD3-1.tex");
            domainNameToFileNameMap.put("PDZD3-2", "SWISSMODEL-PDZD3-2.tex");
            //domainNameToFileNameMap.put("PDZD3-3", "2V90.tex");
            domainNameToFileNameMap.put("PDZD3-3", "SWISSMODEL-PDZD3-3.tex");
            //domainNameToFileNameMap.put("PDZD3-4", "SWISSMODEL-PDZD3-4");
            domainNameToFileNameMap.put("IL16-1", "SWISSMODEL-IL16-1.tex");
            //domainNameToFileNameMap.put("IL16-2", "SWISSMODEL-IL16-2");
            //domainNameToFileNameMap.put("IL16-3", "1X6D-IL16-3");
            ///domainNameToFileNameMap.put("IL16-4", "1I16-IL16-4");
            domainNameToFileNameMap.put("TJP2-1", "2CSJ.tex");
            domainNameToFileNameMap.put("TJP2-2", "3E17.tex");
            domainNameToFileNameMap.put("TJP2-3", "SWISSMODEL-TJP2-3.tex");
            domainNameToFileNameMap.put("WHRN-1", "1UEZ.tex");
            domainNameToFileNameMap.put("WHRN-2", "1UF1.tex");
            //domainNameToFileNameMap.put("WHRN-2", "SWISSMODEL-WHRN-2.tex");
            //domainNameToFileNameMap.put("WHRN-3", "1UFX-WHRN-3");
            domainNameToFileNameMap.put("TJP3-1", "SWISSMODEL-TJP3-1.tex");
            domainNameToFileNameMap.put("TJP3-2", "SWISSMODEL-TJP3-2.tex");
            domainNameToFileNameMap.put("FRMPD2-1", "SWISSMODEL-FRMPD2-1.tex");
            domainNameToFileNameMap.put("FRMPD2-2", "SWISSMODEL-FRMPD2-2.tex");
            domainNameToFileNameMap.put("FRMPD2-3", "SWISSMODEL-FRMPD2-3.tex");
            ///domainNameToFileNameMap.put("DLG5-1", "SWISSMODEL-DLG5-1");
            //domainNameToFileNameMap.put("DLG5-2", "SWISSMODEL-DLG5-2");
            domainNameToFileNameMap.put("DLG5-3", "1UIT.tex");
            domainNameToFileNameMap.put("DLG5-4", "SWISSMODEL-DLG5-4.tex");
            domainNameToFileNameMap.put("SLC9A3R1-1", "1G9O.tex");
            //domainNameToFileNameMap.put("SLC9A3R1-2", "2KJD.tex");
            domainNameToFileNameMap.put("SLC9A3R1-2", "SWISSMODEL-SLC9A3R1-2.tex");
            domainNameToFileNameMap.put("DVL1-1", "SWISSMODEL-DVL1-1.tex");
            //domainNameToFileNameMap.put("SYNJ2BP-1", "2JIN-SYNJ2BP-1");
            domainNameToFileNameMap.put("DVL1L1-1", "SWISSMODEL-DVL1L1-1.tex");
            domainNameToFileNameMap.put("LIN7B-1", "2DKR.tex");
            //domainNameToFileNameMap.put("LIN7B-1", "SWISSMODEL-LIN7B-1.tex");
            domainNameToFileNameMap.put("LIN7C-1", "SWISSMODEL-LIN7C-1.tex");
            domainNameToFileNameMap.put("LIN7A-1", "SWISSMODEL-LIN7A-1.tex");
            domainNameToFileNameMap.put("DVL3-1", "SWISSMODEL-DVL3-1.tex");
            domainNameToFileNameMap.put("PTPN4-1", "2CS5.tex");
            domainNameToFileNameMap.put("SNTB2-1", "2VRF.tex");
            domainNameToFileNameMap.put("DVL2-1", "2REY.tex");
            domainNameToFileNameMap.put("MPP1-1", "2EV8.tex");
            //domainNameToFileNameMap.put("TAX1BP3-1", "3GJ9-TAX1BP3-1");
            domainNameToFileNameMap.put("PDLIM1-1", "2PKT.tex");
            domainNameToFileNameMap.put("PTPN3-1", "SWISSMODEL-PTPN3-1.tex");
            domainNameToFileNameMap.put("PDZD11-1", "SWISSMODEL-PDZD11-1.tex");
            domainNameToFileNameMap.put("PDZD4-1", "SWISSMODEL-PDZD4-1.tex");
            domainNameToFileNameMap.put("GOPC-1", "2DC2.tex");
            domainNameToFileNameMap.put("FRMPD2P1-1", "SWISSMODEL-FRMPD2P1-1.tex");
            domainNameToFileNameMap.put("LIMK2-1", "SWISSMODEL-LIMK2-1.tex");
            domainNameToFileNameMap.put("SNTG2-1", "SWISSMODEL-SNTG2-1.tex");
            domainNameToFileNameMap.put("SNTB1-1", "SWISSMODEL-SNTB1-1.tex");
            domainNameToFileNameMap.put("NOS1-1", "1QAV.tex");
            domainNameToFileNameMap.put("SNTG1-1", "SWISSMODEL-SNTG1-1.tex");
            //domainNameToFileNameMap.put("MLLT4-1", "1T2M.tex");
            domainNameToFileNameMap.put("MLLT4-1", "SWISSMODEL-MLLT4-1.tex");

            domainNameToFileNameMap.put("LIMK1-1", "SWISSMODEL-LIMK1-1.tex");
            domainNameToFileNameMap.put("PDLIM3-1", "SWISSMODEL-PDLIM3-1.tex");
            domainNameToFileNameMap.put("SDCBP2-1", "SWISSMODEL-SDCBP2-1.tex");
            domainNameToFileNameMap.put("SDCBP2-2", "SWISSMODEL-SDCBP2-2.tex");
            domainNameToFileNameMap.put("LDB3-1", "1RGW.tex");
            domainNameToFileNameMap.put("PDLIM2-1", "2PA1.tex");
            domainNameToFileNameMap.put("MPP7-1", "3O46.tex");
            //domainNameToFileNameMap.put("ARHGEF11-1", "2DLS.tex");
            domainNameToFileNameMap.put("ARHGEF11-1", "SWISSMODEL-ARHGEF11-1.tex");
            domainNameToFileNameMap.put("PDLIM5-1", "2UZC.tex");
            domainNameToFileNameMap.put("RAPGEF6-1", "SWISSMODEL-RAPGEF6-1.tex");
            //domainNameToFileNameMap.put("CYTIP-1", "2Z17-CYTIP-1");
            //domainNameToFileNameMap.put("PPP1R9A-1", "1WF8.tex");
            domainNameToFileNameMap.put("PPP1R9A-1", "SWISSMODEL-PPP1R9A-1.tex");
            domainNameToFileNameMap.put("RGS12-1", "2KV8.tex");
            domainNameToFileNameMap.put("PPP1R9B-1", "3EGG.tex");
            domainNameToFileNameMap.put("RHPN1-1", "SWISSMODEL-RHPN1-1.tex");
            domainNameToFileNameMap.put("GRASP-1", "2PNT.tex");
            domainNameToFileNameMap.put("ARHGEF12-1", "2OS6.tex");
            domainNameToFileNameMap.put("PDLIM7-1", "2Q3G.tex");
            domainNameToFileNameMap.put("MPP3-1", "SWISSMODEL-MPP3-1.tex");
            domainNameToFileNameMap.put("MPP5-1", "1VA8.tex");
            domainNameToFileNameMap.put("PARD6B-1", "1NF3.tex");
            domainNameToFileNameMap.put("SYNPO2L-1", "SWISSMODEL-SYNPO2L-1.tex");
            domainNameToFileNameMap.put("MPP4-1", "SWISSMODEL-MPP4-1.tex");
            domainNameToFileNameMap.put("RADIL-1", "1UM1.tex");
            domainNameToFileNameMap.put("USH1C-1", "SWISSMODEL-USH1C-1.tex");
            domainNameToFileNameMap.put("USH1C-2", "SWISSMODEL-USH1C-2.tex");
            domainNameToFileNameMap.put("USH1C-3", "SWISSMODEL-USH1C-3.tex");
            domainNameToFileNameMap.put("PDZK1P1-1", "SWISSMODEL-PDZK1P1-1.tex");
            domainNameToFileNameMap.put("PDZK1P1-2", "SWISSMODEL-PDZK1P1-2.tex");
            //domainNameToFileNameMap.put("PDZK1P1-3", "2VSP-PDZK1P1-3");
            domainNameToFileNameMap.put("PARD3-1", "SWISSMODEL-PARD3-1.tex");
            //domainNameToFileNameMap.put("PARD3-2", "2KOM-PARD3-2");
            domainNameToFileNameMap.put("PARD3-3", "SWISSMODEL-PARD3-3.tex");
            domainNameToFileNameMap.put("PARD3B-1", "SWISSMODEL-PARD3B-1.tex");
            domainNameToFileNameMap.put("PARD3B-2", "SWISSMODEL-PARD3B-2.tex");
            domainNameToFileNameMap.put("PARD3B-3", "SWISSMODEL-PARD3B-3.tex");
            domainNameToFileNameMap.put("PDZD7-1", "2EEH.tex");
            //domainNameToFileNameMap.put("PDZD7-2", "SWISSMODEL-PDZD7-2");
            domainNameToFileNameMap.put("PDZRN4-1", "SWISSMODEL-PDZRN4-1.tex");
            domainNameToFileNameMap.put("PDZRN4-2", "SWISSMODEL-PDZRN4-2.tex");
            //domainNameToFileNameMap.put("SLC9A3R2-1", "2OCS-SLC9A3R2-1");
            domainNameToFileNameMap.put("APBA2-1", "SWISSMODEL-APBA2-1.tex");
            domainNameToFileNameMap.put("APBA2-2", "SWISSMODEL-APBA2-2.tex");
            //domainNameToFileNameMap.put("APBA3-1", "2YT7.tex");
            domainNameToFileNameMap.put("APBA3-2", "2YT8.tex");
            domainNameToFileNameMap.put("PDZRN3-1", "1UHP.tex");
            //domainNameToFileNameMap.put("PDZRN3-2", "1WH1-PDZRN3-2");
            //domainNameToFileNameMap.put("APBA1-1", "1U37-APBA1-1");
            //domainNameToFileNameMap.put("APBA1-2", "1U39-APBA1-2");
            domainNameToFileNameMap.put("PARD6G-1", "SWISSMODEL-PARD6G-1.tex");
            domainNameToFileNameMap.put("GIPC2-1", "3GGE.tex");
            domainNameToFileNameMap.put("PARD6A-1", "SWISSMODEL-PARD6A-1.tex");
            domainNameToFileNameMap.put("RIMS1-1", "2CSS.tex");
            domainNameToFileNameMap.put("CNKSR3-1", "SWISSMODEL-CNKSR3-1.tex");
            domainNameToFileNameMap.put("PICK1-1", "2GZV.tex");
            //domainNameToFileNameMap.put("STXBP4-1", "SWISSMODEL-STXBP4-1");
            domainNameToFileNameMap.put("FRMPD4-1", "SWISSMODEL-FRMPD4-1.tex");
            domainNameToFileNameMap.put("SHROOM2-1", "SWISSMODEL-SHROOM2-1.tex");
            domainNameToFileNameMap.put("SYNPO2-1", "SWISSMODEL-SYNPO2-1.tex");
            //domainNameToFileNameMap.put("FRMPD3-1", "SWISSMODEL-FRMPD3-1");
            domainNameToFileNameMap.put("MAST1-1", "3PS4.tex");
            domainNameToFileNameMap.put("SIPA1-1", "SWISSMODEL-SIPA1-1.tex");
            //domainNameToFileNameMap.put("SHANK1-1", "SWISSMODEL-SHANK1-1");
            domainNameToFileNameMap.put("CNKSR2-1", "SWISSMODEL-CNKSR2-1.tex");
            domainNameToFileNameMap.put("SHROOM3-1", "SWISSMODEL-SHROOM3-1.tex");
            //domainNameToFileNameMap.put("MPP2-1", "2E7K.tex");
            domainNameToFileNameMap.put("MPP2-1", "SWISSMODEL-MPP2-1.tex");
            domainNameToFileNameMap.put("SHANK2-1", "SWISSMODEL-SHANK2-1.tex");
            domainNameToFileNameMap.put("MYO18A-1", "SWISSMODEL-MYO18A-1.tex");
            //domainNameToFileNameMap.put("FRMPD1-1", "2EDV.tex");
            domainNameToFileNameMap.put("FRMPD1-1", "SWISSMODEL-FRMPD1-1.tex");            
            //domainNameToFileNameMap.put("PDZD8-1", "SWISSMODEL-PDZD8-1");
            domainNameToFileNameMap.put("TIAM1-1", "2D8I.tex");
            domainNameToFileNameMap.put("GIPC1-1", "SWISSMODEL-GIPC1-1.tex");
            domainNameToFileNameMap.put("GIPC3-1", "SWISSMODEL-GIPC3-1.tex");
            //domainNameToFileNameMap.put("RGS3-1", "2F5Y.tex");
            domainNameToFileNameMap.put("RGS3-1", "SWISSMODEL-RGS3-1.tex");            
            //domainNameToFileNameMap.put("RIMS2-1", "1WFG-RIMS2-1");
            domainNameToFileNameMap.put("SHROOM4-1", "2EDP.tex");
            domainNameToFileNameMap.put("SIPA1L2-1", "SWISSMODEL-SIPA1L2-1.tex");
            domainNameToFileNameMap.put("SIPA1L1-1", "SWISSMODEL-SIPA1L1-1.tex");
            domainNameToFileNameMap.put("SIPA1L3-1", "SWISSMODEL-SIPA1L3-1.tex");
            domainNameToFileNameMap.put("RHPN2-1", "2VSV.tex");

            domainNameToFileNameMap.put("RIMS1-1", "SWISSMODEL-RIMS1-1.tex");
            //domainNameToFileNameMap.put("RIMS2-1", "SWISSMODEL-RIMS2-1.tex");
            //domainNameToFileNameMap.put("PDZRN3-2", "SWISSMODEL-PDZRN3-2.tex");
            domainNameToFileNameMap.put("APBA1-1", "SWISSMODEL-APBA1-1.tex");
            domainNameToFileNameMap.put("APBA1-2", "SWISSMODEL-APBA1-2.tex");
            //domainNameToFileNameMap.put("PARD3-2", "SWISSMODEL-PARD3-2.tex");
            //domainNameToFileNameMap.put("CYTIP-1", "SWISSMODEL-CYTIP-1.tex");
            //domainNameToFileNameMap.put("TAX1BP3-1", "SWISSMODEL-TAX1BP3-1.tex");
            domainNameToFileNameMap.put("SYNJ2BP-1", "SWISSMODEL-SYNJ2BP-1.tex");
            //domainNameToFileNameMap.put("SLC9A3R2-1", "SWISSMODEL-SLC9A3R2-1.tex");
            //domainNameToFileNameMap.put("IL16-4", "SWISSMODEL-IL16-4.tex");
            domainNameToFileNameMap.put("GRD2I-1", "SWISSMODEL-GRD2I-1.tex");            
            domainNameToFileNameMap.put("GRD2I-2", "SWISSMODEL-GRD2I-2.tex");
            domainNameToFileNameMap.put("GORS1-1", "SWISSMODEL-GORS1-1.tex");
            domainNameToFileNameMap.put("TJP3-3", "SWISSMODEL-TJP3-3.tex");
            domainNameToFileNameMap.put("SDCBP-1", "1YBO.tex");            
            domainNameToFileNameMap.put("SDCBP-2", "SWISSMODEL-SDCBP-2.tex");
            //domainNameToFileNameMap.put("CAR11-1", "SWISSMODEL-CAR11-1");
            domainNameToFileNameMap.put("CAR14-1", "SWISSMODEL-CAR14-1.tex");
            domainNameToFileNameMap.put("HTRA2-1", "SWISSMODEL-HTRA2-1.tex");
            domainNameToFileNameMap.put("MAST2-1", "SWISSMODEL-MAST2-1.tex");
            domainNameToFileNameMap.put("MAST3-1", "SWISSMODEL-MAST3-1.tex");
            //domainNameToFileNameMap.put("RPGF2-1", "SWISSMODEL-RPGF2-1");
            domainNameToFileNameMap.put("CNKR1-1", "SWISSMODEL-CNKR1-1.tex");
            domainNameToFileNameMap.put("GRIP2-4", "SWISSMODEL-GRIP2-4.tex");
            domainNameToFileNameMap.put("IL16-3", "SWISSMODEL-IL16-3.tex");
            domainNameToFileNameMap.put("PTPN13-2", "SWISSMODEL-PTPN13-2.tex");
            domainNameToFileNameMap.put("WHRN-3", "SWISSMODEL-WHRN-3.tex");
            //domainNameToFileNameMap.put("SLC9A3R2-1", "SWISSMODEL-SLC9A3R2-1");
            domainNameToFileNameMap.put("PDZK1-4", "SWISSMODEL-PDZK1-4.tex");
            domainNameToFileNameMap.put("ARHGEF12-1", "SWISSMODEL-ARHGEF12-1.tex");
            /*domainNameToFileNameMap.put("R49A-1", "SWISSMODEL-ERBINMUT-R49A.tex");
            domainNameToFileNameMap.put("R49C-1", "SWISSMODEL-ERBINMUT-R49C.tex");
            domainNameToFileNameMap.put("R49F-1", "SWISSMODEL-ERBINMUT-R49F.tex");
            domainNameToFileNameMap.put("R49W-1", "SWISSMODEL-ERBINMUT-R49W.tex");
            domainNameToFileNameMap.put("R49Y-1", "SWISSMODEL-ERBINMUT-R49Y.tex");

            domainNameToFileNameMap.put("E-27-1", "SWISSMODEL-ERBINMUT10-E27-C8.tex");
            domainNameToFileNameMap.put("E-12-1", "SWISSMODEL-ERBINMUT10-E12-B2.tex");
            domainNameToFileNameMap.put("E-43-1", "SWISSMODEL-ERBINMUT10-E43-E11.tex");
            domainNameToFileNameMap.put("E-2-1", "SWISSMODEL-ERBINMUT10-E2-A2.tex");
            domainNameToFileNameMap.put("E-20-1", "SWISSMODEL-ERBINMUT10-E20-B12.tex");
            domainNameToFileNameMap.put("E-14-1", "SWISSMODEL-ERBINMUT10-E14-B4.tex");
            domainNameToFileNameMap.put("E-30-1", "SWISSMODEL-ERBINMUT10-E30-C12.tex");
            domainNameToFileNameMap.put("E-31-1", "SWISSMODEL-ERBINMUT10-E31-D2.tex");
            domainNameToFileNameMap.put("E-32-1", "SWISSMODEL-ERBINMUT10-E32-D3.tex");
            domainNameToFileNameMap.put("E-33-1", "SWISSMODEL-ERBINMUT10-E33-D4.tex");
            domainNameToFileNameMap.put("E-44-1", "SWISSMODEL-ERBINMUT10-E44-F1.tex");
            domainNameToFileNameMap.put("E-57-1", "SWISSMODEL-ERBINMUT10-E57-G8.tex");
            domainNameToFileNameMap.put("E-58-1", "SWISSMODEL-ERBINMUT10-E58-G9.tex");

            domainNameToFileNameMap.put("E-8-1", "SWISSMODEL-ERBINMUT10-E8-A10.tex");
            domainNameToFileNameMap.put("E-9-1", "SWISSMODEL-ERBINMUT10-E9-A11.tex");
            domainNameToFileNameMap.put("E-10-1", "SWISSMODEL-ERBINMUT10-E10-A12.tex");
            domainNameToFileNameMap.put("E-4-1", "SWISSMODEL-ERBINMUT10-E4-A5.tex");
            domainNameToFileNameMap.put("E-7-1", "SWISSMODEL-ERBINMUT10-E7-A9.tex");
            domainNameToFileNameMap.put("E-13-1", "SWISSMODEL-ERBINMUT10-E13-B3.tex");
            domainNameToFileNameMap.put("E-16-1", "SWISSMODEL-ERBINMUT10-E16-B6.tex");
            domainNameToFileNameMap.put("E-29-1", "SWISSMODEL-ERBINMUT10-E29-C11.tex");
            domainNameToFileNameMap.put("E-24-1", "SWISSMODEL-ERBINMUT10-E24-C4.tex");
            domainNameToFileNameMap.put("E-28-1", "SWISSMODEL-ERBINMUT10-E28-C9.tex");
            domainNameToFileNameMap.put("E-38-1", "SWISSMODEL-ERBINMUT10-E38-E4.tex");
            domainNameToFileNameMap.put("E-39-1", "SWISSMODEL-ERBINMUT10-E39-E6.tex");
            domainNameToFileNameMap.put("E-49-1", "SWISSMODEL-ERBINMUT10-E49-F10.tex");
            domainNameToFileNameMap.put("E-50-1", "SWISSMODEL-ERBINMUT10-E50-F11.tex");
            domainNameToFileNameMap.put("E-51-1", "SWISSMODEL-ERBINMUT10-E51-F12.tex");
            domainNameToFileNameMap.put("E-61-1", "SWISSMODEL-ERBINMUT10-E61-G12.tex");
            domainNameToFileNameMap.put("E-54-1", "SWISSMODEL-ERBINMUT10-E54-G4.tex");
            domainNameToFileNameMap.put("E-56-1", "SWISSMODEL-ERBINMUT10-E56-G6.tex");

            domainNameToFileNameMap.put("E-5-1", "SWISSMODEL-ERBINMUT10-E5-A6.tex");
            domainNameToFileNameMap.put("E-6-1", "SWISSMODEL-ERBINMUT10-E6-A7.tex");
            domainNameToFileNameMap.put("E-19-1", "SWISSMODEL-ERBINMUT10-E19-B10.tex");
            domainNameToFileNameMap.put("E-11-1", "SWISSMODEL-ERBINMUT10-E11-B1.tex");
            domainNameToFileNameMap.put("E-17-1", "SWISSMODEL-ERBINMUT10-E17-B7.tex");
            domainNameToFileNameMap.put("E-18-1", "SWISSMODEL-ERBINMUT10-E18-B9.tex");
            domainNameToFileNameMap.put("E-22-1", "SWISSMODEL-ERBINMUT10-E22-C2.tex");
            domainNameToFileNameMap.put("E-23-1", "SWISSMODEL-ERBINMUT10-E23-C3.tex");
            domainNameToFileNameMap.put("E-36-1", "SWISSMODEL-ERBINMUT10-E36-D11.tex");
            domainNameToFileNameMap.put("E-42-1", "SWISSMODEL-ERBINMUT10-E42-E10.tex");
            domainNameToFileNameMap.put("E-37-1", "SWISSMODEL-ERBINMUT10-E37-E3.tex");
            domainNameToFileNameMap.put("E-41-1", "SWISSMODEL-ERBINMUT10-E41-E8.tex");
            domainNameToFileNameMap.put("E-46-1", "SWISSMODEL-ERBINMUT10-E46-F6.tex");
            domainNameToFileNameMap.put("E-47-1", "SWISSMODEL-ERBINMUT10-E47-F7.tex");
            domainNameToFileNameMap.put("E-48-1", "SWISSMODEL-ERBINMUT10-E48-F9.tex");
            domainNameToFileNameMap.put("E-59-1", "SWISSMODEL-ERBINMUT10-E59-G10.tex");
            domainNameToFileNameMap.put("E-52-1", "SWISSMODEL-ERBINMUT10-E52-G2.tex");
            domainNameToFileNameMap.put("E-53-1", "SWISSMODEL-ERBINMUT10-E53-G3.tex");
            domainNameToFileNameMap.put("E-55-1", "SWISSMODEL-ERBINMUT10-E55-G5.tex");

            domainNameToFileNameMap.put("E-15-1", "SWISSMODEL-ERBINMUT10-E15-B5.tex");
            domainNameToFileNameMap.put("E-26-1", "SWISSMODEL-ERBINMUT10-E26-C7.tex");
            domainNameToFileNameMap.put("E-34-1", "SWISSMODEL-ERBINMUT10-E34-D7.tex");
            domainNameToFileNameMap.put("E-35-1", "SWISSMODEL-ERBINMUT10-E35-D9.tex");
            domainNameToFileNameMap.put("E-40-1", "SWISSMODEL-ERBINMUT10-E40-E7.tex");
            domainNameToFileNameMap.put("E-45-1", "SWISSMODEL-ERBINMUT10-E45-F5.tex");
            domainNameToFileNameMap.put("E-60-1", "SWISSMODEL-ERBINMUT10-E60-G11.tex");

            domainNameToFileNameMap.put("E-1-1", "SWISSMODEL-ERBINMUT10-E1-A1.tex");
            domainNameToFileNameMap.put("E-3-1", "SWISSMODEL-ERBINMUT10-E3-A4.tex");
            domainNameToFileNameMap.put("E-21-1", "SWISSMODEL-ERBINMUT10-E21-C1.tex");
            domainNameToFileNameMap.put("E-25-1", "SWISSMODEL-ERBINMUT10-E25-C6.tex");

            domainNameToFileNameMap.put("F25I-1","SWISSMODEL-ERBINMUT-F25I.tex");
            domainNameToFileNameMap.put("F25L-1","SWISSMODEL-ERBINMUT-F25L.tex");
            domainNameToFileNameMap.put("F25V-1","SWISSMODEL-ERBINMUT-F25V.tex");
            domainNameToFileNameMap.put("H79A-1","SWISSMODEL-ERBINMUT-H79A.tex");
            domainNameToFileNameMap.put("H79C-1","SWISSMODEL-ERBINMUT-H79C.tex");
            domainNameToFileNameMap.put("H79D-1","SWISSMODEL-ERBINMUT-H79D.tex");
            domainNameToFileNameMap.put("H79E-1","SWISSMODEL-ERBINMUT-H79E.tex");
            domainNameToFileNameMap.put("H79F-1","SWISSMODEL-ERBINMUT-H79F.tex");
            domainNameToFileNameMap.put("H79I-1","SWISSMODEL-ERBINMUT-H79I.tex");
            domainNameToFileNameMap.put("H79K-1","SWISSMODEL-ERBINMUT-H79K.tex");
            domainNameToFileNameMap.put("H79L-1","SWISSMODEL-ERBINMUT-H79L.tex");
            domainNameToFileNameMap.put("H79M-1","SWISSMODEL-ERBINMUT-H79M.tex");
            domainNameToFileNameMap.put("H79N-1","SWISSMODEL-ERBINMUT-H79N.tex");
            domainNameToFileNameMap.put("H79P-1","SWISSMODEL-ERBINMUT-H79P.tex");
            domainNameToFileNameMap.put("H79Q-1","SWISSMODEL-ERBINMUT-H79Q.tex");
            domainNameToFileNameMap.put("H79R-1","SWISSMODEL-ERBINMUT-H79R.tex");
            domainNameToFileNameMap.put("H79S-1","SWISSMODEL-ERBINMUT-H79S.tex");
            domainNameToFileNameMap.put("H79T-1","SWISSMODEL-ERBINMUT-H79T.tex");
            domainNameToFileNameMap.put("H79V-1","SWISSMODEL-ERBINMUT-H79V.tex");
            domainNameToFileNameMap.put("H79W-1","SWISSMODEL-ERBINMUT-H79W.tex");
            domainNameToFileNameMap.put("H79Y-1","SWISSMODEL-ERBINMUT-H79Y.tex");
            domainNameToFileNameMap.put("I27L-1","SWISSMODEL-ERBINMUT-I27L.tex");
            domainNameToFileNameMap.put("I27V-1","SWISSMODEL-ERBINMUT-I27V.tex");
            domainNameToFileNameMap.put("L23F-1","SWISSMODEL-ERBINMUT-L23F.tex");
            domainNameToFileNameMap.put("L23I-1","SWISSMODEL-ERBINMUT-L23I.tex");
            domainNameToFileNameMap.put("L23V-1","SWISSMODEL-ERBINMUT-L23V.tex");
            domainNameToFileNameMap.put("Q51A-1","SWISSMODEL-ERBINMUT-Q51A.tex");
            domainNameToFileNameMap.put("Q51D-1","SWISSMODEL-ERBINMUT-Q51D.tex");
            domainNameToFileNameMap.put("Q51E-1","SWISSMODEL-ERBINMUT-Q51E.tex");
            domainNameToFileNameMap.put("Q51G-1","SWISSMODEL-ERBINMUT-Q51G.tex");
            domainNameToFileNameMap.put("Q51H-1","SWISSMODEL-ERBINMUT-Q51H.tex");
            domainNameToFileNameMap.put("Q51I-1","SWISSMODEL-ERBINMUT-Q51I.tex");
            domainNameToFileNameMap.put("Q51K-1","SWISSMODEL-ERBINMUT-Q51K.tex");
            domainNameToFileNameMap.put("Q51L-1","SWISSMODEL-ERBINMUT-Q51L.tex");
            domainNameToFileNameMap.put("Q51M-1","SWISSMODEL-ERBINMUT-Q51M.tex");
            domainNameToFileNameMap.put("Q51N-1","SWISSMODEL-ERBINMUT-Q51N.tex");
            domainNameToFileNameMap.put("Q51P-1","SWISSMODEL-ERBINMUT-Q51P.tex");
            domainNameToFileNameMap.put("Q51R-1","SWISSMODEL-ERBINMUT-Q51R.tex");
            domainNameToFileNameMap.put("Q51S-1","SWISSMODEL-ERBINMUT-Q51S.tex");
            domainNameToFileNameMap.put("Q51T-1","SWISSMODEL-ERBINMUT-Q51T.tex");
            domainNameToFileNameMap.put("Q51V-1","SWISSMODEL-ERBINMUT-Q51V.tex");
            domainNameToFileNameMap.put("R49A-1","SWISSMODEL-ERBINMUT-R49A.tex");
            domainNameToFileNameMap.put("R49C-1","SWISSMODEL-ERBINMUT-R49C.tex");
            domainNameToFileNameMap.put("R49D-1","SWISSMODEL-ERBINMUT-R49D.tex");
            domainNameToFileNameMap.put("R49E-1","SWISSMODEL-ERBINMUT-R49E.tex");
            domainNameToFileNameMap.put("R49F-1","SWISSMODEL-ERBINMUT-R49F.tex");
            domainNameToFileNameMap.put("R49G-1","SWISSMODEL-ERBINMUT-R49G.tex");
            domainNameToFileNameMap.put("R49H-1","SWISSMODEL-ERBINMUT-R49H.tex");
            domainNameToFileNameMap.put("R49I-1","SWISSMODEL-ERBINMUT-R49I.tex");
            domainNameToFileNameMap.put("R49K-1","SWISSMODEL-ERBINMUT-R49K.tex");
            domainNameToFileNameMap.put("R49L-1","SWISSMODEL-ERBINMUT-R49L.tex");
            domainNameToFileNameMap.put("R49M-1","SWISSMODEL-ERBINMUT-R49M.tex");
            domainNameToFileNameMap.put("R49N-1","SWISSMODEL-ERBINMUT-R49N.tex");
            domainNameToFileNameMap.put("R49Q-1","SWISSMODEL-ERBINMUT-R49Q.tex");
            domainNameToFileNameMap.put("R49S-1","SWISSMODEL-ERBINMUT-R49S.tex");
            domainNameToFileNameMap.put("R49T-1","SWISSMODEL-ERBINMUT-R49T.tex");
            domainNameToFileNameMap.put("R49V-1","SWISSMODEL-ERBINMUT-R49V.tex");
            domainNameToFileNameMap.put("R49W-1","SWISSMODEL-ERBINMUT-R49W.tex");
            domainNameToFileNameMap.put("R49Y-1","SWISSMODEL-ERBINMUT-R49Y.tex");
            domainNameToFileNameMap.put("S26I-1","SWISSMODEL-ERBINMUT-S26I.tex");
            domainNameToFileNameMap.put("S26K-1","SWISSMODEL-ERBINMUT-S26K.tex");
            domainNameToFileNameMap.put("S26M-1","SWISSMODEL-ERBINMUT-S26M.tex");
            domainNameToFileNameMap.put("S26N-1","SWISSMODEL-ERBINMUT-S26N.tex");
            domainNameToFileNameMap.put("S26R-1","SWISSMODEL-ERBINMUT-S26R.tex");
            domainNameToFileNameMap.put("S26T-1","SWISSMODEL-ERBINMUT-S26T.tex");
            domainNameToFileNameMap.put("S28A-1","SWISSMODEL-ERBINMUT-S28A.tex");
            domainNameToFileNameMap.put("S28D-1","SWISSMODEL-ERBINMUT-S28D.tex");
            domainNameToFileNameMap.put("S28E-1","SWISSMODEL-ERBINMUT-S28E.tex");
            domainNameToFileNameMap.put("S28G-1","SWISSMODEL-ERBINMUT-S28G.tex");
            domainNameToFileNameMap.put("S28I-1","SWISSMODEL-ERBINMUT-S28I.tex");
            domainNameToFileNameMap.put("S28K-1","SWISSMODEL-ERBINMUT-S28K.tex");
            domainNameToFileNameMap.put("S28M-1","SWISSMODEL-ERBINMUT-S28M.tex");
            domainNameToFileNameMap.put("S28N-1","SWISSMODEL-ERBINMUT-S28N.tex");
            domainNameToFileNameMap.put("S28R-1","SWISSMODEL-ERBINMUT-S28R.tex");
            domainNameToFileNameMap.put("S28T-1","SWISSMODEL-ERBINMUT-S28T.tex");
            domainNameToFileNameMap.put("S28V-1","SWISSMODEL-ERBINMUT-S28V.tex");
            domainNameToFileNameMap.put("T48A-1","SWISSMODEL-ERBINMUT-T48A.tex");
            domainNameToFileNameMap.put("T48D-1","SWISSMODEL-ERBINMUT-T48D.tex");
            domainNameToFileNameMap.put("T48E-1","SWISSMODEL-ERBINMUT-T48E.tex");
            domainNameToFileNameMap.put("T48G-1","SWISSMODEL-ERBINMUT-T48G.tex");
            domainNameToFileNameMap.put("T48K-1","SWISSMODEL-ERBINMUT-T48K.tex");
            domainNameToFileNameMap.put("T48N-1","SWISSMODEL-ERBINMUT-T48N.tex");
            domainNameToFileNameMap.put("T48R-1","SWISSMODEL-ERBINMUT-T48R.tex");
            domainNameToFileNameMap.put("T48S-1","SWISSMODEL-ERBINMUT-T48S.tex");
            domainNameToFileNameMap.put("V83A-1","SWISSMODEL-ERBINMUT-V83A.tex");
            domainNameToFileNameMap.put("V83E-1","SWISSMODEL-ERBINMUT-V83E.tex");
            domainNameToFileNameMap.put("V83I-1","SWISSMODEL-ERBINMUT-V83I.tex");
            domainNameToFileNameMap.put("V83K-1","SWISSMODEL-ERBINMUT-V83K.tex");
            domainNameToFileNameMap.put("V83L-1","SWISSMODEL-ERBINMUT-V83L.tex");
            domainNameToFileNameMap.put("V83Q-1","SWISSMODEL-ERBINMUT-V83Q.tex");
            domainNameToFileNameMap.put("V83T-1","SWISSMODEL-ERBINMUT-V83T.tex");

            */

        }
        else if (organism.equals(Constants.MOUSE)||
               organism.equals(Constants.MOUSE_ORPHAN))
        {

            //domainNameToFileNameMap.put("GRIP2-5","SWISSMODEL-GRIP2-5.tex");
            //domainNameToFileNameMap.put("GM1582-2","SWISSMODEL-GM1582-2.tex");
            domainNameToFileNameMap.put("DVL1-1","1MC7.tex");
            domainNameToFileNameMap.put("PTP-BL-2","1VJ6.tex");
            domainNameToFileNameMap.put("PDZ-RGS3-1","1WHD.tex");
            domainNameToFileNameMap.put("A1-SYNTROPHIN-1","1Z86.tex");
            domainNameToFileNameMap.put("PDZK1-1","2EDZ.tex");
            domainNameToFileNameMap.put("B1-SYNTROPHIN-1","SWISSMODEL-B1-SYNTROPHIN-1.tex");
            domainNameToFileNameMap.put("CHAPSYN-110-2","SWISSMODEL-CHAPSYN-110-2.tex");
            domainNameToFileNameMap.put("CHAPSYN-110-3","SWISSMODEL-CHAPSYN-110-3.tex");
            domainNameToFileNameMap.put("CIPP-10","SWISSMODEL-CIPP-10.tex");
            domainNameToFileNameMap.put("CIPP-3","SWISSMODEL-CIPP-3.tex");
            domainNameToFileNameMap.put("CIPP-5","SWISSMODEL-CIPP-5.tex");
            domainNameToFileNameMap.put("CIPP-8","SWISSMODEL-CIPP-8.tex");
            domainNameToFileNameMap.put("CIPP-9","SWISSMODEL-CIPP-9.tex");
            domainNameToFileNameMap.put("DVL3-1","SWISSMODEL-DVL3-1.tex");
            domainNameToFileNameMap.put("ERBIN-1","SWISSMODEL-ERBIN-1.tex");
            domainNameToFileNameMap.put("GRIP1-6","SWISSMODEL-GRIP1-6.tex");
            domainNameToFileNameMap.put("HARMONIN-2","SWISSMODEL-HARMONIN-2.tex");
            domainNameToFileNameMap.put("LARG-1","SWISSMODEL-LARG-1.tex");
            domainNameToFileNameMap.put("LIN-7C-1","SWISSMODEL-LIN-7C-1.tex");
            //domainNameToFileNameMap.put("LNX1-2","SWISSMODEL-LNX1-2.tex");
            domainNameToFileNameMap.put("LRRC7-1","SWISSMODEL-LRRC7-1.tex");
            domainNameToFileNameMap.put("MAGI-1-6","SWISSMODEL-MAGI-1-6.tex");
            domainNameToFileNameMap.put("MAGI-2-2","SWISSMODEL-MAGI-2-2.tex");
            domainNameToFileNameMap.put("MAGI-2-5","SWISSMODEL-MAGI-2-5.tex");
            domainNameToFileNameMap.put("MAGI-2-6","SWISSMODEL-MAGI-2-6.tex");
            domainNameToFileNameMap.put("MAGI-3-1","SWISSMODEL-MAGI-3-1.tex");
            domainNameToFileNameMap.put("MAGI-3-2","SWISSMODEL-MAGI-3-2.tex");
            domainNameToFileNameMap.put("MAGI-3-5","SWISSMODEL-MAGI-3-5.tex");
            domainNameToFileNameMap.put("MALS2-1","SWISSMODEL-MALS2-1.tex");
            domainNameToFileNameMap.put("MPP7-1","SWISSMODEL-MPP7-1.tex");
            domainNameToFileNameMap.put("MUPP1-1","SWISSMODEL-MUPP1-1.tex");
            domainNameToFileNameMap.put("MUPP1-10","SWISSMODEL-MUPP1-10.tex");
            domainNameToFileNameMap.put("MUPP1-11","SWISSMODEL-MUPP1-11.tex");
            domainNameToFileNameMap.put("MUPP1-12","SWISSMODEL-MUPP1-12.tex");
            domainNameToFileNameMap.put("MUPP1-13","SWISSMODEL-MUPP1-13.tex");
            domainNameToFileNameMap.put("MUPP1-5","SWISSMODEL-MUPP1-5.tex");
            domainNameToFileNameMap.put("NHERF-1-1","SWISSMODEL-NHERF-1-1.tex");
            domainNameToFileNameMap.put("NHERF-2-2","SWISSMODEL-NHERF-2-2.tex");
            domainNameToFileNameMap.put("NNOS-1","SWISSMODEL-NNOS-1.tex");
            domainNameToFileNameMap.put("OMP25-1","SWISSMODEL-OMP25-1.tex");
            domainNameToFileNameMap.put("PAR6B-1","SWISSMODEL-PAR6B-1.tex");
            domainNameToFileNameMap.put("PDZK1-3","SWISSMODEL-PDZK1-3.tex");
            domainNameToFileNameMap.put("PDZK11-1","SWISSMODEL-PDZK11-1.tex");
            domainNameToFileNameMap.put("PSD95-1","SWISSMODEL-PSD95-1.tex");
            domainNameToFileNameMap.put("PSD95-2","SWISSMODEL-PSD95-2.tex");
            domainNameToFileNameMap.put("PSD95-3","SWISSMODEL-PSD95-3.tex");
            domainNameToFileNameMap.put("SAP102-2","SWISSMODEL-SAP102-2.tex");
            domainNameToFileNameMap.put("SAP102-3","SWISSMODEL-SAP102-3.tex");
            domainNameToFileNameMap.put("SAP97-1","SWISSMODEL-SAP97-1.tex");
            domainNameToFileNameMap.put("SAP97-2","SWISSMODEL-SAP97-2.tex");
            domainNameToFileNameMap.put("SAP97-3","SWISSMODEL-SAP97-3.tex");
            domainNameToFileNameMap.put("SCRB1-1","SWISSMODEL-SCRB1-1.tex");
            domainNameToFileNameMap.put("SCRB1-2","SWISSMODEL-SCRB1-2.tex");
          domainNameToFileNameMap.put("SCRB1-3","SWISSMODEL-SCRB1-3.tex");
            domainNameToFileNameMap.put("SEMCAP3-1","SWISSMODEL-SEMCAP3-1.tex");
            domainNameToFileNameMap.put("SHANK1-1","SWISSMODEL-SHANK1-1.tex");
            domainNameToFileNameMap.put("SHANK3-1","SWISSMODEL-SHANK3-1.tex");
          domainNameToFileNameMap.put("SHROOM-1","SWISSMODEL-SHROOM-1.tex");
            domainNameToFileNameMap.put("SLIM-1","SWISSMODEL-SLIM-1.tex");
            //domainNameToFileNameMap.put("TIP-1-1","SWISSMODEL-TIP-1-1.tex");
            domainNameToFileNameMap.put("ZO-1-1","SWISSMODEL-ZO-1-1.tex");
            domainNameToFileNameMap.put("ZO-2-1","SWISSMODEL-ZO-2-1.tex");
          domainNameToFileNameMap.put("ZO-3-1","SWISSMODEL-ZO-3-1.tex");

        //}
        //else if (type.equals(Constants.CHEN_MOUSE_ORPHAN_PDB))
        //{
            //CHEN_MOUSE_ORPHAN_PDB
            domainNameToFileNameMap.put("GOPC1-1", "SWISSMODEL-GOPC1-1.tex");
            domainNameToFileNameMap.put("MAGI-2-3", "SWISSMODEL-MAGI-2-3.tex");
            domainNameToFileNameMap.put("MAGI-2-4", "SWISSMODEL-MAGI-2-4.tex");
            domainNameToFileNameMap.put("MUPP1-2", "SWISSMODEL-MUPP1-2.tex");
            domainNameToFileNameMap.put("NHERF1-2", "SWISSMODEL-NHERF-1-2.tex");
            domainNameToFileNameMap.put("PDZK1-4", "SWISSMODEL-PDZK1-4.tex");
            domainNameToFileNameMap.put("SCRB-1-4", "SWISSMODEL-SCRB1-4.tex");
            domainNameToFileNameMap.put("IL-16-3", "SWISSMODEL-IL-16-3.tex");
            domainNameToFileNameMap.put("GRIP-1-4", "SWISSMODEL-GRIP1-4.tex");
            domainNameToFileNameMap.put("GRIP-1-5", "SWISSMODEL-GRIP1-5.tex");
            domainNameToFileNameMap.put("PAR-6G-1", "SWISSMODEL-PAR6G-1.tex");
            domainNameToFileNameMap.put("CIPP-7", "SWISSMODEL-CIPP-7.tex");
            domainNameToFileNameMap.put("MUPP1-6", "SWISSMODEL-MUPP1-6.tex");
            domainNameToFileNameMap.put("DELPHILIN-1", "SWISSMODEL-DELPHILIN-1.tex");
            domainNameToFileNameMap.put("PAR-3B-3", "SWISSMODEL-PAR-3B-3.tex");
            domainNameToFileNameMap.put("RGS-12-1", "SWISSMODEL-RGS-12-1.tex");
            domainNameToFileNameMap.put("MAGI-1-1", "SWISSMODEL-MAGI-1-1.tex");
            domainNameToFileNameMap.put("A330043P19-1", "SWISSMODEL-A330043P19-1.tex");
            domainNameToFileNameMap.put("PDZK-7-1", "SWISSMODEL-PDZK-7-1.tex");
            domainNameToFileNameMap.put("DLG-5-2", "SWISSMODEL-DLG-5-2.tex");

            // TAP PSD95
            domainNameToFileNameMap.put("CHAPSYN-110-1", "SWISSMODEL-CHAPSYN-110-1.tex");
            domainNameToFileNameMap.put("SAP102-1", "SWISSMODEL-SAP102-1.tex");
            domainNameToFileNameMap.put("SHANK2-1", "SWISSMODEL-SHANK2-1.tex");
            domainNameToFileNameMap.put("MAGI-3-4", "SWISSMODEL-MAGI-3-4.tex");
            domainNameToFileNameMap.put("MAGI-3-5_", "SWISSMODEL-MAGI-3-5_.tex");
            domainNameToFileNameMap.put("FRPD4-1", "SWISSMODEL-FRPD4-1.tex");
            domainNameToFileNameMap.put("CNKR2-1", "SWISSMODEL-CNKR2-1.tex");
        }
        else if (organism.equals(Constants.FLY))
        {
            // CHEN FLY PDB
            domainNameToFileNameMap.put("DLG-1-1", "SWISSMODEL-DLG-1-1.tex");
            domainNameToFileNameMap.put("DSH-1", "SWISSMODEL-DSH-1.tex");
            domainNameToFileNameMap.put("MAGI-4", "SWISSMODEL-MAGI-4.tex");
            domainNameToFileNameMap.put("PATJ-2", "SWISSMODEL-PATJ-2.tex");
            domainNameToFileNameMap.put("PAR6-1", "1RY4.tex");
            domainNameToFileNameMap.put("LAP4-2", "SWISSMODEL-LAP4-2.tex");
            domainNameToFileNameMap.put("LAP4-3", "SWISSMODEL-LAP4-3.tex");

        }
        else if (organism.equals(Constants.WORM))
        {
            // CHEN WORM PDB
            domainNameToFileNameMap.put("DLG1-1", "SWISSMODEL-DLG1-1.tex");
            domainNameToFileNameMap.put("DLG1-3", "SWISSMODEL-DLG1-3.tex");
            domainNameToFileNameMap.put("DSH-1", "SWISSMODEL-DSH-1.tex");
            domainNameToFileNameMap.put("LIN7-1", "SWISSMODEL-LIN7-1.tex");
            domainNameToFileNameMap.put("STN2-1", "SWISSMODEL-STN2-1.tex");
            domainNameToFileNameMap.put("MPZ1-6", "SWISSMODEL-MPZ1-6.tex");
            domainNameToFileNameMap.put("NAB1-1", "SWISSMODEL-NAB1-1.tex");


            // SIDHU WORM PDB
            domainNameToFileNameMap.put("F25H2.2-1", "SWISSMODEL-F25H2.2-1.tex");
            //domainNameToFileNameMap.put("T10A3.1a-1", "SWISSMODEL-T10A3.1a-1.tex");
            domainNameToFileNameMap.put("C43E11.6a-1", "SWISSMODEL-C43E11.6a-1.tex");
            //domainNameToFileNameMap.put("C09H6.2a-2", "SWISSMODEL-C09H6.2a-2.tex");
            domainNameToFileNameMap.put("W03F11.6a-1", "SWISSMODEL-W03F11.6a-1.tex");
            domainNameToFileNameMap.put("C10C6.1-1", "SWISSMODEL-C10C6.1-1.tex");
            domainNameToFileNameMap.put("H09G03.2a-1", "SWISSMODEL-H09G03.2a-1.tex");
            //domainNameToFileNameMap.put("T21G5.4-1", "SWISSMODEL-T21G5.4-1");
            domainNameToFileNameMap.put("W03F11.6a-1", "SWISSMODEL-W03F11.6a-1.tex");
            domainNameToFileNameMap.put("K01A6.2-4", "SWISSMODEL-K01A6.2-4.tex");
            //domainNameToFileNameMap.put("T10A3.1a-1", "SWISSMODEL-T10A3.1a-1");
            domainNameToFileNameMap.put("Y38C1AB.8-2", "SWISSMODEL-Y38C1AB.8-2.tex");




        }
    }
    public Features encodeFeatures(String domainName)
    {
        featureValues = new ArrayList();
        //System.out.println("Encoding: " + domainName);
        List indList = bindingSite.getIndicatorList(domainName);
        List resList = bindingSite.getResidueList(domainName);
        //String bsSeq = bindingSite.getBindingSiteSequence(domainName);
        //System.out.println(domainName + ":" + bsSeq);
        String fileName = (String)domainNameToFileNameMap.get(domainName);
        String joyFileName = joyDir+fileName ;
        try
        {
            BufferedReader br = new BufferedReader(new FileReader(new File(joyFileName)));
            String line = "";
            int ix = 0;
            while((line=br.readLine())!=null)
            {
                if (line.startsWith("\\rule[-1.2mm]{0mm}{4.4mm}\\") ||line.startsWith("x\\rule[-1.2mm]{0mm}{4.4mm}\\"))
                //if (line.startsWith("x\\rule[-1.2mm]{0mm}{4.4mm}"))
                {
                    String format = line.substring(36,line.length());
                    if (format.equals(" &"))
                    {
                        // advance ix until we see an actual character

                        for (int i=ix;i<resList.size();i++)
                        {
                            String ress = (String)resList.get(i);
                            if (ress.equals("-"))
                                ix = ix +1;
                            else
                                break;
                        }
                        continue;
                    }
                    if (ix == indList.size())
                        break;
                    String ind = (String)indList.get(ix);


                    if (ind.equals("x"))
                    {
                        //System.out.println(ind + "\t" + format);
                        
                        String newFormat = format.replaceAll("[{}\\&]"," ");
                        String[] splitTokens = newFormat.split("\\s+");
                        List valuesList = new ArrayList();
                        for (int j = 0; j < 5;j++)
                            valuesList.add(0.0);
                        int index;

                        for (int i=0;i< splitTokens.length-1;i++)
                        {
                            String token = splitTokens[i];
                            //System.out.print(splitTokens[i]+" ");
                            // index 1
                            if (token.equals(HBOND_MAIN_CHAIN_AMIDE_BF) ||
                                    token.equals(HBOND_MAIN_CHAIN_AMIDE_PMB))
                            {
                                index = HBOND_MAIN_CHAIN_AMIDE_IX;
                            }
                            // index 2
                            else if (token.equals(HBOND_MAIN_CHAIN_CARBONYL))
                            {
                                index = HBOND_MAIN_CHAIN_CARBONYL_IX;
                            }
                            // index 3
                            else if (token.equals(HBOND_MAIN_CHAIN_OTHER))
                            {
                                index = HBOND_MAIN_CHAIN_OTHER_IX;
                            }
                            /*else if (token.equals(DISULPHIDE_BOND))
                            {
                                index = DISULPHIDE_BOND_IX;
                            }
                            */
                            else if(token.equals(POS_PHI_TORSION_ANGLE))
                            {
                                index = POS_PHI_TORSION_ANGLE_IX;
                            }
                            else
                                continue;
                            valuesList.set(index,1.0);
                        }

                        String residue = splitTokens[splitTokens.length-1];
                        if (residue.equals(residue.toLowerCase()))
                        {
                                valuesList.set(SOLVENT_ACC_IX, 1.0);
                        }
                        //else
                        //{
                        //        valuesList.set(SOLVENT_INACC_IX, 1.0);
                        //}

                        
                        featureValues.addAll(valuesList);
                    }
                    ix = ix+1;

                }
            }
            br.close();


        }
        catch (Exception e)
        {
            //System.out.println("Exception: " + e);
            //e.printStackTrace();
        }
        Features f = new Features();
        f.addFeatureValues(featureValues);
        return f;
    }
    public List encodeFeature(String domainName)
    {
        return new ArrayList();
    }
    public static void main(String[] args)
    {
        String organism = args[1];

        JoyFeatureEncoding joy = new JoyFeatureEncoding(organism);
        //JoyFeatureEncoding joy = new JoyFeatureEncoding(Constants.MOUSE);
        //JoyFeatureEncoding joy = new JoyFeatureEncoding(Constants.FLY);
        //JoyFeatureEncoding joy = new JoyFeatureEncoding(Constants.WORM);
        //JoyFeatureEncoding joy = new JoyFeatureEncoding(Constants.MOUSE_ORPHAN);

        /*DataLoader dl = new DataLoader();
        //dl.loadMousePDBTest(Constants.CHEN_MOUSE_ORPHAN_PDB);
        dl.loadMouseTest(Constants.MOUSE_ORPHAN);

        List posTrainProfileList = dl.getPosTestProfileList();
        List negTrainProfileList = dl.getNegTestProfileList();
        List seenList = new ArrayList();
        for (int i=0;i < posTrainProfileList.size();i++)
        {
            ProteinProfile profile = (ProteinProfile)posTrainProfileList.get(i);
            seenList.add(profile.getName());
            String domainName = profile.getName();//args[0];
            System.out.println(domainName);

            Features ft = joy.encodeFeatures(domainName);
            System.out.println(domainName +"\t" + ft.numFeatures());
            System.out.println(ft.getFeatureValues());
        }
        for (int i=0;i < negTrainProfileList.size();i++)
        {
            ProteinProfile profile = (ProteinProfile)negTrainProfileList.get(i);
            String domainName = profile.getName();//args[0];
            if (seenList.contains(domainName))
                continue;
            System.out.println(domainName);

            Features ft = joy.encodeFeatures(domainName);
            System.out.println(domainName +"\t" + ft.numFeatures());
            System.out.println(ft.getFeatureValues());
        }
        */
        List domainNameList = new ArrayList();
        domainNameList.add("GRD2I-1");
        //domainNameList.add("MAGI1-1");
        domainNameList.add("MAGI2-3");
        domainNameList.add("MAGI3-3");
        //domainNameList.add("MAGI3-1");
        domainNameList.add("PDZD2-4");
        domainNameList.add("SDCBP-1");

        for(int i=0; i < domainNameList.size();i++)
        {
            String domainName = (String)domainNameList.get(i);
        Features ft = joy.encodeFeatures(domainName);
        System.out.println(domainName +"\t" + ft.numFeatures());
        System.out.println(ft.getFeatureValues());
        }

    }
}
