package org.baderlab.pdzsvmstruct.data.manager;

import org.baderlab.pdzsvmstruct.utils.Constants;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Manager for paths to various data files
 */
public class DataFileManager
{
    public static String DATA_ROOT_DIR = "/Users/shirleyhui/Data/SVMProjectStructure";
    public static String OUTPUT_ROOT_DIR = "/Users/shirleyhui/Desktop/Results";
    public static String NNK_CODON_BIAS_FILENAME = DATA_ROOT_DIR +"/Data/PhageCodonBias/phageLibraryNNKTheoreticalCodonBias.txt";

    public DataFileManager()
    {

    }

    public String getDataFile(String organism, String method, String theClass)
    {
        return getDataFile(organism, method, theClass, -1);
    }


    public String getDataFile(String organism, String method, String theClass, int seqSim)
    {
        String fileName = "";
        if (method.equals(Constants.PDZBASE))
        {
            if (organism.equals(Constants.HUMAN)|| organism.equals(Constants.HUMAN_STRING))
                fileName= DATA_ROOT_DIR + "/Data/PDZBase/PDZ/Human/ProjectFiles/projectFile-pdzbase-human.txt";
            else if(organism.equals(Constants.MOUSE) || organism.equals(Constants.MOUSE_STRING))
                fileName= DATA_ROOT_DIR + "/Data/PDZBase/PDZ/Mouse/ProjectFiles/projectFile-pdzbase-mouse.txt";

        }

        if (method.equals(Constants.PHAGE_DISPLAY))
        {
            if (organism.equals(Constants.HUMAN)|| organism.equals(Constants.HUMAN_STRING))
                fileName= DATA_ROOT_DIR + "/Data/Human/PDZ/ProjectFiles/projectFileHuman-orig.txt";
            else if (organism.equals(Constants.SIDHU_HUMAN_G_PDB) )
                fileName= DATA_ROOT_DIR + "/Data/Human/PDZ/ProjectFiles/projectFileHuman-sidhu-genomic-PDB.txt";
            
        }
        
        
        if (method.equals(Constants.PROTEIN_MICROARRAY))
        {
            if (organism.equals(Constants.CHEN_MOUSE_ORPHAN_PDB))
            {
                if (theClass == Constants.CLASS_YES)
                    fileName = DATA_ROOT_DIR +  "/Data/Mouse/PDZ/ProjectFiles/projectFile-pos-mouse-orphan-PDB.txt";
                else
                    fileName = DATA_ROOT_DIR +  "/Data/Mouse/PDZ/ProjectFiles/projectFile-neg-mouse-orphan-PDB.txt";

            }
            else if (organism.equals(Constants.CHEN_MOUSE_PDB))
            {
                if (theClass == Constants.CLASS_YES)
                    fileName = DATA_ROOT_DIR +  "/Data/Mouse/PDZ/ProjectFiles/projectFile-pos-mouse-PDB.txt";
                else
                    fileName = DATA_ROOT_DIR +  "/Data/Mouse/PDZ/ProjectFiles/projectFile-neg-mouse-PDB.txt";

            }
            else if (organism.equals(Constants.CHEN_FLY_PDB))
            {
                if (theClass == Constants.CLASS_YES)
                    fileName = DATA_ROOT_DIR +  "/Data/Fly/PDZ/ProjectFiles/projectFile-pos-chen-fly-PDB.txt";
                else
                    fileName = DATA_ROOT_DIR +  "/Data/Fly/PDZ/ProjectFiles/projectFile-neg-chen-fly-PDB.txt";

            }
            else if (organism.equals(Constants.CHEN_WORM_PDB))
            {
                if (theClass == Constants.CLASS_YES)
                    fileName = DATA_ROOT_DIR +  "/Data/Worm/PDZ/ProjectFiles/projectFile-pos-chen-worm-PDB.txt";
                else
                    fileName = DATA_ROOT_DIR +  "/Data/Worm/PDZ/ProjectFiles/projectFile-neg-chen-worm-PDB.txt";

            }
        }

        
        return fileName;
    }

}
