package org.baderlab.pdzsvmstruct.encoding;

import java.util.List;
import java.util.ArrayList;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Binary Sequence feature encoding represents a residue as a vector of zeros with a
 * one only in the position representing the residue and concatenating all vectors
 * representing the residues in a sequence together.
 */
public class BinarySequenceFeatureEncoding extends FeatureEncoding
{
    private static final String alphabet = "ACDEFGHIKLMNPQRSTVWYX";

    public BinarySequenceFeatureEncoding()
    {
        setEncodingName("BINARY_SEQUENCE");

    }

    protected List encodeFeature(String residue)
    {
        List encodedFeatures = new ArrayList();
        int value = alphabet.indexOf(residue);
        // only mark first 20 AA, gaps and X's don't count
        for (int i = 0; i < 20;i++)
        {
            encodedFeatures.add(0.0);
        }
        if (value <0)
            System.out.println("Invalid character: " + value + "," + residue);
        if (value <= 19 )
        {
            encodedFeatures.set(value,1.0);

        }
        return encodedFeatures;
    }

    public static void main(String[] args)
    {
        String seq = "KETLV";

        BinarySequenceFeatureEncoding s = new BinarySequenceFeatureEncoding();
        Features features = s.encodeFeatures(seq);
        List feat = features.getFeatureValues();
        double[] featureDoubleArray = features.getFeatureValuesAsDoubleArray();
        System.out.println(feat);
    }

}
