package org.baderlab.pdzsvmstruct.encoding;

import org.baderlab.pdzsvmstruct.data.manager.DataFileManager;
import org.baderlab.pdzsvmstruct.utils.BindingSiteUtils;
import org.baderlab.pdzsvmstruct.utils.Constants;

import java.util.*;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class HydrophobicitySurfaceFeatureEncoding extends FeatureEncoding {

    private HashMap domainNameToFileNameMap;
    private HashMap residueNumToNameMap;
    private BindingSiteUtils bindingSite;
    private String vascoDir;
    private String organism = "";

    public HydrophobicitySurfaceFeatureEncoding(String organism)
    {
        setEncodingName("HYDROPHOBICITY SURFACE");
        this.organism= organism;
        bindingSite = new BindingSiteUtils(organism);
        if (organism.equals(Constants.HUMAN))
            vascoDir = DataFileManager.DATA_ROOT_DIR + "/Data/Human/PDZ/VASCo/";
        else if (organism.equals(Constants.MOUSE) ||
                organism.equals(Constants.MOUSE_ORPHAN))
            vascoDir = DataFileManager.DATA_ROOT_DIR + "/Data/Mouse/PDZ/VASCo/";
        else if (organism.equals(Constants.FLY))
            vascoDir = DataFileManager.DATA_ROOT_DIR +"/Data/Fly/PDZ/VASCo/";
        else if (organism.equals(Constants.WORM))
            vascoDir = DataFileManager.DATA_ROOT_DIR +"/Data/Worm/PDZ/VASCo/";
        initDomainNameToVascoFileNameMap(organism);

    }
    public void initDomainNameToVascoFileNameMap(String organism)
    {
        domainNameToFileNameMap = new HashMap();
        if (organism.equals(Constants.HUMAN))
        {
            domainNameToFileNameMap.put("CASK-1", "1KWA-CASK-1");
            domainNameToFileNameMap.put("DLG3-2","2FE5-DLG3-2");
            //domainNameToFileNameMap.put("DVL2-1", "2REY-DVL2-1");
            domainNameToFileNameMap.put("ERBB2IP-1", "1MFL-ERBB2IP-1");
            //domainNameToFileNameMap.put("MPDZ-1", "2O2T-MPDZ-1");
            domainNameToFileNameMap.put("MPDZ-1", "SWISSMODEL-MPDZ-1");

            domainNameToFileNameMap.put("MPDZ-10", "2OPG-MPDZ-10");
            //domainNameToFileNameMap.put("MPDZ-12", "2IWO-MPDZ-12");
            domainNameToFileNameMap.put("MPDZ-12", "SWISSMODEL-MPDZ-12");

            //domainNameToFileNameMap.put("MPDZ-13", "2FNE-MPDZ-13");
            //domainNameToFileNameMap.put("MPDZ-3", "2IWN-MPDZ-3");
            domainNameToFileNameMap.put("MPDZ-3", "SWISSMODEL-MPDZ-3");

            //domainNameToFileNameMap.put("PDLIM2-1", "2PA1-PDLIM2-1");
            //domainNameToFileNameMap.put("PSCDBP-1", "2Z17-PSCDBP-1");
            domainNameToFileNameMap.put("SCRIB-1", "2W4F-SCRIB-1");
            domainNameToFileNameMap.put("SLC9A3R2-2", "2HE4-SLC9A3R2-2");
            domainNameToFileNameMap.put("DLG1-2", "2G2L-DLG1-2");
            domainNameToFileNameMap.put("DLG4-3", "1TP3-DLG4-3");
            domainNameToFileNameMap.put("PDLIM4-1", "2V1W-PDLIM4-1");
            domainNameToFileNameMap.put("DLG2-3", "2HE2-DLG2-3");
            domainNameToFileNameMap.put("INADL-2", "2DLU-INADL-2");
            domainNameToFileNameMap.put("SCRIB-2", "1WHA-SCRIB-2");

            domainNameToFileNameMap.put("DLG1-1", "SWISSMODEL-DLG1-1");
            domainNameToFileNameMap.put("PDZK1-1", "SWISSMODEL-PDZK1-1");
          domainNameToFileNameMap.put("SHANK3-1", "SWISSMODEL-SHANK3-1");
            domainNameToFileNameMap.put("SNTA1-1", "SWISSMODEL-SNTA1-1");
            domainNameToFileNameMap.put("DLG1-3", "SWISSMODEL-DLG1-3");
          domainNameToFileNameMap.put("LRRC7-1", "SWISSMODEL-LRRC7-1");
            domainNameToFileNameMap.put("MPP6-1", "SWISSMODEL-MPP6-1");
            //domainNameToFileNameMap.put("APBA3-1", "2YT7-APBA3-1");

            domainNameToFileNameMap.put("APBA3-1", "SWISSMODEL-APBA3-1");
            domainNameToFileNameMap.put("PSCDBP-1", "2Z17-PSCDBP-1");
            domainNameToFileNameMap.put("MPDZ-7", "2IWQ-MPDZ-7");

            domainNameToFileNameMap.put("MPDZ-2", "SWISSMODEL-MPDZ-2");

            // PROTEOME SCANNING
            domainNameToFileNameMap.put("MPDZ-11","2QG1-MPDZ-11");
            domainNameToFileNameMap.put("MPDZ-13","2FNE-MPDZ-13");
            domainNameToFileNameMap.put("MPDZ-4", "SWISSMODEL-MPDZ-4");
            domainNameToFileNameMap.put("MPDZ-5", "SWISSMODEL-MPDZ-5");
            domainNameToFileNameMap.put("MPDZ-6", "SWISSMODEL-MPDZ-6");
            domainNameToFileNameMap.put("MPDZ-8", "SWISSMODEL-MPDZ-8");
            domainNameToFileNameMap.put("MPDZ-9", "SWISSMODEL-MPDZ-9");
            //domainNameToFileNameMap.put("INADL-1", "2DB5-INADL-1");
            //domainNameToFileNameMap.put("INADL-3", "2DMZ-INADL-3");
            domainNameToFileNameMap.put("INADL-5", "2D92-INADL-5");
            domainNameToFileNameMap.put("INADL-1", "SWISSMODEL-INADL-1");
            domainNameToFileNameMap.put("INADL-3", "SWISSMODEL-INADL-3");
            //domainNameToFileNameMap.put("INADL-5", "SWISSMODEL-INADL-5");
            domainNameToFileNameMap.put("INADL-6", "2EHR-INADL-6");
            //domainNameToFileNameMap.put("INADL-7", "SWISSMODEL-INADL-7");
            //domainNameToFileNameMap.put("INADL-8", "SWISSMODEL-INADL-8");
            domainNameToFileNameMap.put("INADL-7", "2DAZ-INADL-7");
            domainNameToFileNameMap.put("INADL-8", "2DM8-INADL-8");
            domainNameToFileNameMap.put("INADL-9", "SWISSMODEL-INADL-9");
            domainNameToFileNameMap.put("INADL-10", "SWISSMODEL-INADL-10");
            domainNameToFileNameMap.put("GRIP2-1", "SWISSMODEL-GRIP2-1");
            domainNameToFileNameMap.put("GRIP2-2", "SWISSMODEL-GRIP2-2");
            domainNameToFileNameMap.put("GRIP2-3", "1V62-GRIP2-3");
            domainNameToFileNameMap.put("GRIP2-5", "SWISSMODEL-GRIP2-5");
            domainNameToFileNameMap.put("GRIP2-6", "SWISSMODEL-GRIP2-6");
            domainNameToFileNameMap.put("GRIP2-7", "SWISSMODEL-GRIP2-7");
            domainNameToFileNameMap.put("SCRIB-3", "SWISSMODEL-SCRIB-3");
            domainNameToFileNameMap.put("SCRIB-4", "1UJU-SCRIB-4");
            domainNameToFileNameMap.put("GRIP1-1", "SWISSMODEL-GRIP1-1");
            domainNameToFileNameMap.put("GRIP1-2", "2JIL-GRIP1-2");
            domainNameToFileNameMap.put("GRIP1-3", "SWISSMODEL-GRIP1-3");
            domainNameToFileNameMap.put("GRIP1-4", "SWISSMODEL-GRIP1-4");
            domainNameToFileNameMap.put("GRIP1-5", "SWISSMODEL-GRIP1-5");
            domainNameToFileNameMap.put("GRIP1-6", "SWISSMODEL-GRIP1-6");
            domainNameToFileNameMap.put("GRIP1-7", "SWISSMODEL-GRIP1-7");
            domainNameToFileNameMap.put("PTPN13-1", "SWISSMODEL-PTPN13-1");
            domainNameToFileNameMap.put("PTPN13-3", "SWISSMODEL-PTPN13-3");
            domainNameToFileNameMap.put("PTPN13-4", "SWISSMODEL-PTPN13-4");
            domainNameToFileNameMap.put("PTPN13-5", "SWISSMODEL-PTPN13-5");

            //domainNameToFileNameMap.put("MAGI1-1", "SWISSMODEL-MAGI1-1");
            domainNameToFileNameMap.put("MAGI1-2", "2KPK-MAGI1-2");
            domainNameToFileNameMap.put("MAGI1-3", "SWISSMODEL-MAGI1-3");
            domainNameToFileNameMap.put("MAGI1-4", "SWISSMODEL-MAGI1-4");
            domainNameToFileNameMap.put("MAGI1-5", "SWISSMODEL-MAGI1-5");            
            domainNameToFileNameMap.put("MAGI1-6", "SWISSMODEL-MAGI1-6");

            domainNameToFileNameMap.put("MAGI2-1", "SWISSMODEL-MAGI2-1");
            domainNameToFileNameMap.put("MAGI2-2", "1UEQ-MAGI2-2");
            domainNameToFileNameMap.put("MAGI2-3", "SWISSMODEL-MAGI2-3"); // *
            domainNameToFileNameMap.put("MAGI2-4", "1UEP-MAGI2-4");
            domainNameToFileNameMap.put("MAGI2-5", "SWISSMODEL-MAGI2-5");
            domainNameToFileNameMap.put("MAGI2-6", "1WFV-MAGI2-6");

            //domainNameToFileNameMap.put("MAGI3-1", "SWISSMODEL-MAGI3-1");
            domainNameToFileNameMap.put("MAGI3-2", "SWISSMODEL-MAGI3-2");
            domainNameToFileNameMap.put("MAGI3-3", "SWISSMODEL-MAGI3-3"); // *
            domainNameToFileNameMap.put("MAGI3-4", "SWISSMODEL-MAGI3-4");
            domainNameToFileNameMap.put("MAGI3-5", "SWISSMODEL-MAGI3-5");
            domainNameToFileNameMap.put("MAGI3-6", "SWISSMODEL-MAGI3-6");

            //domainNameToFileNameMap.put("PDZD2-1", "SWISSMODEL-PDZD2-1");
            domainNameToFileNameMap.put("PDZD2-2", "SWISSMODEL-PDZD2-2");
            domainNameToFileNameMap.put("PDZD2-3", "SWISSMODEL-PDZD2-3");
            domainNameToFileNameMap.put("PDZD2-4", "SWISSMODEL-PDZD2-4");
            domainNameToFileNameMap.put("PDZD2-5", "SWISSMODEL-PDZD2-5");
            //domainNameToFileNameMap.put("PDZD2-6", "SWISSMODEL-PDZD2-6");

            domainNameToFileNameMap.put("DLG4-1", "SWISSMODEL-DLG4-1");
            domainNameToFileNameMap.put("DLG4-2", "SWISSMODEL-DLG4-2");
            domainNameToFileNameMap.put("DLG2-1", "SWISSMODEL-DLG2-1");
            //domainNameToFileNameMap.put("DLG2-2", "2BYG-DLG2-2");
            domainNameToFileNameMap.put("DLG2-2", "SWISSMODEL-DLG2-2");
            //domainNameToFileNameMap.put("LNX2-1", "SWISSMODEL-LNX2-1");
            //domainNameToFileNameMap.put("LNX2-2", "2VWR-LNX2-2");
            //domainNameToFileNameMap.put("LNX2-3", "SWISSMODEL-LNX2-3");
            //domainNameToFileNameMap.put("LNX2-4", "SWISSMODEL-LNX2-4");

            domainNameToFileNameMap.put("DLG3-1", "2I1N-DLG3-1");
            domainNameToFileNameMap.put("DLG3-3", "1UM7-DLG3-3");
            //domainNameToFileNameMap.put("LNX1-1", "SWISSMODEL-LNX1-1");
            //domainNameToFileNameMap.put("LNX1-2", "SWISSMODEL-LNX1-2");
            //domainNameToFileNameMap.put("LNX1-3", "SWISSMODEL-LNX1-3");
            //domainNameToFileNameMap.put("LNX1-4", "SWISSMODEL-LNX1-4");
            domainNameToFileNameMap.put("PDZK1-2", "2EEI-PDZK1-2");
            domainNameToFileNameMap.put("PDZK1-3", "SWISSMODEL-PDZK1-3");
            //domainNameToFileNameMap.put("PDZK1-4", "2VSP-PDZK1-4");
            domainNameToFileNameMap.put("TJP1-1", "2H2C-TJP1-1");
            domainNameToFileNameMap.put("TJP1-2", "2RCZ-TJP1-2");
            domainNameToFileNameMap.put("TJP1-3", "SWISSMODEL-TJP1-3");
            domainNameToFileNameMap.put("PDZD3-1", "SWISSMODEL-PDZD3-1");
            //domainNameToFileNameMap.put("PDZD3-2", "SWISSMODEL-PDZD3-2");
            //domainNameToFileNameMap.put("PDZD3-3", "2V90-PDZD3-3");
            domainNameToFileNameMap.put("PDZD3-3", "SWISSMODEL-PDZD3-3");
            //domainNameToFileNameMap.put("PDZD3-4", "SWISSMODEL-PDZD3-4");
            domainNameToFileNameMap.put("IL16-1", "SWISSMODEL-IL16-1");
            //domainNameToFileNameMap.put("IL16-2", "SWISSMODEL-IL16-2");
            //domainNameToFileNameMap.put("IL16-3", "1X6D-IL16-3");
            ///domainNameToFileNameMap.put("IL16-4", "1I16-IL16-4");
            domainNameToFileNameMap.put("TJP2-1", "2CSJ-TJP2-1");
            domainNameToFileNameMap.put("TJP2-2", "3E17-TJP2-2");
            domainNameToFileNameMap.put("TJP2-3", "SWISSMODEL-TJP2-3");
            domainNameToFileNameMap.put("WHRN-1", "1UEZ-WHRN-1");
            domainNameToFileNameMap.put("WHRN-2", "1UF1-WHRN-2");
            //domainNameToFileNameMap.put("WHRN-2", "SWISSMODEL-WHRN-2");

            //domainNameToFileNameMap.put("WHRN-3", "1UFX-WHRN-3");
            domainNameToFileNameMap.put("TJP3-1", "SWISSMODEL-TJP3-1");
            domainNameToFileNameMap.put("TJP3-2", "SWISSMODEL-TJP3-2");
            domainNameToFileNameMap.put("FRMPD2-1", "SWISSMODEL-FRMPD2-1");
            domainNameToFileNameMap.put("FRMPD2-2", "SWISSMODEL-FRMPD2-2");
            domainNameToFileNameMap.put("FRMPD2-3", "SWISSMODEL-FRMPD2-3");
            ///domainNameToFileNameMap.put("DLG5-1", "SWISSMODEL-DLG5-1");
            //domainNameToFileNameMap.put("DLG5-2", "SWISSMODEL-DLG5-2");
            domainNameToFileNameMap.put("DLG5-3", "1UIT-DLG5-3");
            domainNameToFileNameMap.put("DLG5-4", "SWISSMODEL-DLG5-4");
            domainNameToFileNameMap.put("SLC9A3R1-1", "1G9O-SLC9A3R1-1");
            //domainNameToFileNameMap.put("SLC9A3R1-2", "2KJD-SLC9A3R1-2");
            domainNameToFileNameMap.put("SLC9A3R1-2", "SWISSMODEL-SLC9A3R1-2");
            domainNameToFileNameMap.put("DVL1-1", "SWISSMODEL-DVL1-1");
            //domainNameToFileNameMap.put("SYNJ2BP-1", "2JIN-SYNJ2BP-1");
            domainNameToFileNameMap.put("DVL1L1-1", "SWISSMODEL-DVL1L1-1");
            domainNameToFileNameMap.put("LIN7B-1", "2DKR-LIN7B-1");
            //domainNameToFileNameMap.put("LIN7B-1", "SWISSMODEL-LIN7B-1");
            domainNameToFileNameMap.put("LIN7C-1", "SWISSMODEL-LIN7C-1");
            domainNameToFileNameMap.put("LIN7A-1", "SWISSMODEL-LIN7A-1");
            domainNameToFileNameMap.put("DVL3-1", "SWISSMODEL-DVL3-1");
            domainNameToFileNameMap.put("PTPN4-1", "2CS5-PTPN4-1");
            domainNameToFileNameMap.put("SNTB2-1", "2VRF-SNTB2-1");
            domainNameToFileNameMap.put("DVL2-1", "2REY-DVL2-1");
            domainNameToFileNameMap.put("MPP1-1", "2EV8-MPP1-1");
            //domainNameToFileNameMap.put("TAX1BP3-1", "3GJ9-TAX1BP3-1");
            domainNameToFileNameMap.put("PDLIM1-1", "2PKT-PDLIM1-1");
            domainNameToFileNameMap.put("PTPN3-1", "SWISSMODEL-PTPN3-1");
            domainNameToFileNameMap.put("PDZD11-1", "SWISSMODEL-PDZD11-1");
            domainNameToFileNameMap.put("PDZD4-1", "SWISSMODEL-PDZD4-1");
            domainNameToFileNameMap.put("GOPC-1", "2DC2-GOPC-1");
            domainNameToFileNameMap.put("FRMPD2P1-1", "SWISSMODEL-FRMPD2P1-1");
            domainNameToFileNameMap.put("LIMK2-1", "SWISSMODEL-LIMK2-1");
            domainNameToFileNameMap.put("SNTG2-1", "SWISSMODEL-SNTG2-1");
            domainNameToFileNameMap.put("SNTB1-1", "SWISSMODEL-SNTB1-1");
            domainNameToFileNameMap.put("NOS1-1", "1QAV-NOS1-1");
            domainNameToFileNameMap.put("SNTG1-1", "SWISSMODEL-SNTG1-1");
            //domainNameToFileNameMap.put("MLLT4-1", "1T2M-MLLT4-1");
            domainNameToFileNameMap.put("MLLT4-1", "SWISSMODEL-MLLT4-1");

            domainNameToFileNameMap.put("LIMK1-1", "SWISSMODEL-LIMK1-1");
            domainNameToFileNameMap.put("PDLIM3-1", "SWISSMODEL-PDLIM3-1");
            domainNameToFileNameMap.put("SDCBP2-1", "SWISSMODEL-SDCBP2-1");
            domainNameToFileNameMap.put("SDCBP2-2", "SWISSMODEL-SDCBP2-2");
            domainNameToFileNameMap.put("LDB3-1", "1RGW-LDB3-1");
            domainNameToFileNameMap.put("PDLIM2-1", "2PA1-PDLIM2-1");
            domainNameToFileNameMap.put("MPP7-1", "3O46-MPP7-1");
            //domainNameToFileNameMap.put("ARHGEF11-1", "2DLS-ARHGEF11-1");
            domainNameToFileNameMap.put("ARHGEF11-1", "SWISSMODEL-ARHGEF11-1");
            domainNameToFileNameMap.put("PDLIM5-1", "2UZC-PDLIM5-1");
            domainNameToFileNameMap.put("RAPGEF6-1", "SWISSMODEL-RAPGEF6-1");
            //domainNameToFileNameMap.put("CYTIP-1", "2Z17-CYTIP-1");
            //domainNameToFileNameMap.put("PPP1R9A-1", "1WF8-PPP1R9A-1");
            domainNameToFileNameMap.put("PPP1R9A-1", "SWISSMODEL-PPP1R9A-1");            
            domainNameToFileNameMap.put("RGS12-1", "2KV8-RGS12-1");
            domainNameToFileNameMap.put("PPP1R9B-1", "3EGG-PPP1R9B-1");
            domainNameToFileNameMap.put("RHPN1-1", "SWISSMODEL-RHPN1-1");
            domainNameToFileNameMap.put("GRASP-1", "2PNT-GRASP-1");
            domainNameToFileNameMap.put("ARHGEF12-1", "2OS6-ARHGEF12-1");
            domainNameToFileNameMap.put("PDLIM7-1", "2Q3G-PDLIM7-1");
            domainNameToFileNameMap.put("MPP3-1", "SWISSMODEL-MPP3-1");
            domainNameToFileNameMap.put("MPP5-1", "1VA8-MPP5-1");
            domainNameToFileNameMap.put("PARD6B-1", "1NF3-PARD6B-1");
            domainNameToFileNameMap.put("SYNPO2L-1", "SWISSMODEL-SYNPO2L-1");
            domainNameToFileNameMap.put("MPP4-1", "SWISSMODEL-MPP4-1");
            domainNameToFileNameMap.put("RADIL-1", "1UM1-RADIL-1");
            domainNameToFileNameMap.put("USH1C-1", "SWISSMODEL-USH1C-1");
            domainNameToFileNameMap.put("USH1C-2", "SWISSMODEL-USH1C-2");
            domainNameToFileNameMap.put("USH1C-3", "SWISSMODEL-USH1C-3");
            domainNameToFileNameMap.put("PDZK1P1-1", "SWISSMODEL-PDZK1P1-1");
            domainNameToFileNameMap.put("PDZK1P1-2", "SWISSMODEL-PDZK1P1-2");
            //domainNameToFileNameMap.put("PDZK1P1-3", "2VSP-PDZK1P1-3");
            domainNameToFileNameMap.put("PARD3-1", "SWISSMODEL-PARD3-1");
            //domainNameToFileNameMap.put("PARD3-2", "2KOM-PARD3-2");
            domainNameToFileNameMap.put("PARD3-3", "SWISSMODEL-PARD3-3");
            domainNameToFileNameMap.put("PARD3B-1", "SWISSMODEL-PARD3B-1");
            domainNameToFileNameMap.put("PARD3B-2", "SWISSMODEL-PARD3B-2");
            domainNameToFileNameMap.put("PARD3B-3", "SWISSMODEL-PARD3B-3");
            domainNameToFileNameMap.put("PDZD7-1", "2EEH-PDZD7-1");
            //domainNameToFileNameMap.put("PDZD7-2", "SWISSMODEL-PDZD7-2");
            domainNameToFileNameMap.put("PDZRN4-1", "SWISSMODEL-PDZRN4-1");
            domainNameToFileNameMap.put("PDZRN4-2", "SWISSMODEL-PDZRN4-2");
            //domainNameToFileNameMap.put("SLC9A3R2-1", "2OCS-SLC9A3R2-1");
            domainNameToFileNameMap.put("APBA2-1", "SWISSMODEL-APBA2-1");
            domainNameToFileNameMap.put("APBA2-2", "SWISSMODEL-APBA2-2");
            //domainNameToFileNameMap.put("APBA3-1", "2YT7-APBA3-1");
            domainNameToFileNameMap.put("APBA3-2", "2YT8-APBA3-2");
            domainNameToFileNameMap.put("PDZRN3-1", "1UHP-PDZRN3-1");

            domainNameToFileNameMap.put("PARD6G-1", "SWISSMODEL-PARD6G-1");
            domainNameToFileNameMap.put("GIPC2-1", "3GGE-GIPC2-1");
            domainNameToFileNameMap.put("PARD6A-1", "SWISSMODEL-PARD6A-1");
            domainNameToFileNameMap.put("RIMS1-1", "2CSS-RIMS1-1");
            domainNameToFileNameMap.put("CNKSR3-1", "SWISSMODEL-CNKSR3-1");
            domainNameToFileNameMap.put("PICK1-1", "2GZV-PICK1-1");
            //domainNameToFileNameMap.put("STXBP4-1", "SWISSMODEL-STXBP4-1");
            domainNameToFileNameMap.put("FRMPD4-1", "SWISSMODEL-FRMPD4-1");
            domainNameToFileNameMap.put("SHROOM2-1", "SWISSMODEL-SHROOM2-1");
            domainNameToFileNameMap.put("SYNPO2-1", "SWISSMODEL-SYNPO2-1");
            //domainNameToFileNameMap.put("FRMPD3-1", "SWISSMODEL-FRMPD3-1");
            domainNameToFileNameMap.put("MAST1-1", "3PS4-MAST1-1");
            domainNameToFileNameMap.put("SIPA1-1", "SWISSMODEL-SIPA1-1");
            //domainNameToFileNameMap.put("SHANK1-1", "SWISSMODEL-SHANK1-1");
            domainNameToFileNameMap.put("CNKSR2-1", "SWISSMODEL-CNKSR2-1");
            domainNameToFileNameMap.put("SHROOM3-1", "SWISSMODEL-SHROOM3-1");
            //domainNameToFileNameMap.put("MPP2-1", "2E7K-MPP2-1");
            domainNameToFileNameMap.put("MPP2-1", "SWISSMODEL-MPP2-1");
            domainNameToFileNameMap.put("SHANK2-1", "SWISSMODEL-SHANK2-1");
            domainNameToFileNameMap.put("MYO18A-1", "SWISSMODEL-MYO18A-1");
            //domainNameToFileNameMap.put("FRMPD1-1", "2EDV-FRMPD1-1");
            domainNameToFileNameMap.put("FRMPD1-1", "SWISSMODEL-FRMPD1-1");
            //domainNameToFileNameMap.put("PDZD8-1", "SWISSMODEL-PDZD8-1");
            domainNameToFileNameMap.put("TIAM1-1", "2D8I-TIAM1-1");
            domainNameToFileNameMap.put("GIPC1-1", "SWISSMODEL-GIPC1-1");
            domainNameToFileNameMap.put("GIPC3-1", "SWISSMODEL-GIPC3-1");
            //domainNameToFileNameMap.put("RGS3-1", "2F5Y-RGS3-1");
            domainNameToFileNameMap.put("RGS3-1", "SWISSMODEL-RGS3-1");
            //domainNameToFileNameMap.put("RIMS2-1", "1WFG-RIMS2-1");
            domainNameToFileNameMap.put("SHROOM4-1", "2EDP-SHROOM4-1");
            domainNameToFileNameMap.put("SIPA1L2-1", "SWISSMODEL-SIPA1L2-1");
            domainNameToFileNameMap.put("SIPA1L1-1", "SWISSMODEL-SIPA1L1-1");
            domainNameToFileNameMap.put("SIPA1L3-1", "SWISSMODEL-SIPA1L3-1");
            domainNameToFileNameMap.put("RHPN2-1", "2VSV-RHPN2-1");

            domainNameToFileNameMap.put("RIMS1-1", "SWISSMODEL-RIMS1-1");
            //domainNameToFileNameMap.put("RIMS2-1", "SWISSMODEL-RIMS2-1");
            //domainNameToFileNameMap.put("PDZRN3-2", "SWISSMODEL-PDZRN3-2");
            domainNameToFileNameMap.put("APBA1-1", "SWISSMODEL-APBA1-1");
            domainNameToFileNameMap.put("APBA1-2", "SWISSMODEL-APBA1-2");
            //domainNameToFileNameMap.put("PARD3-2", "SWISSMODEL-PARD3-2");
            //domainNameToFileNameMap.put("CYTIP-1", "SWISSMODEL-CYTIP-1");
            //domainNameToFileNameMap.put("TAX1BP3-1", "SWISSMODEL-TAX1BP3-1");
            domainNameToFileNameMap.put("SYNJ2BP-1", "SWISSMODEL-SYNJ2BP-1");
            //domainNameToFileNameMap.put("SLC9A3R2-1", "SWISSMODEL-SLC9A3R2-1");
            //domainNameToFileNameMap.put("IL16-4", "SWISSMODEL-IL16-4");
            domainNameToFileNameMap.put("GRD2I-1", "SWISSMODEL-GRD2I-1");            
            domainNameToFileNameMap.put("GRD2I-2", "SWISSMODEL-GRD2I-2");
            domainNameToFileNameMap.put("GORS1-1", "SWISSMODEL-GORS1-1");
            domainNameToFileNameMap.put("TJP3-3", "SWISSMODEL-TJP3-3");
            domainNameToFileNameMap.put("SDCBP-1", "1YBO-SDCBP-1");
            domainNameToFileNameMap.put("SDCBP-2", "SWISSMODEL-SDCBP-2");
            //domainNameToFileNameMap.put("CAR11-1", "SWISSMODEL-CAR11-1");
            domainNameToFileNameMap.put("CAR14-1", "SWISSMODEL-CAR14-1");
            domainNameToFileNameMap.put("HTRA2-1", "SWISSMODEL-HTRA2-1");
            domainNameToFileNameMap.put("MAST2-1", "SWISSMODEL-MAST2-1");
            domainNameToFileNameMap.put("MAST3-1", "SWISSMODEL-MAST3-1");
            //domainNameToFileNameMap.put("RPGF2-1", "SWISSMODEL-RPGF2-1");
            domainNameToFileNameMap.put("CNKR1-1", "SWISSMODEL-CNKR1-1");
            domainNameToFileNameMap.put("GRIP2-4", "SWISSMODEL-GRIP2-4");
            domainNameToFileNameMap.put("IL16-3", "SWISSMODEL-IL16-3");
            domainNameToFileNameMap.put("PTPN13-2", "SWISSMODEL-PTPN13-2");
            domainNameToFileNameMap.put("WHRN-3", "SWISSMODEL-WHRN-3");
            //domainNameToFileNameMap.put("SLC9A3R2-1", "SWISSMODEL-SLC9A3R2-1");
            domainNameToFileNameMap.put("PDZK1-4", "SWISSMODEL-PDZK1-4");
            domainNameToFileNameMap.put("ARHGEF12-1", "SWISSMODEL-ARHGEF12-1");

            /*domainNameToFileNameMap.put("R49A-1", "SWISSMODEL-ERBINMUT-R49A");
            domainNameToFileNameMap.put("R49C-1", "SWISSMODEL-ERBINMUT-R49C");
            domainNameToFileNameMap.put("R49F-1", "SWISSMODEL-ERBINMUT-R49F");
            domainNameToFileNameMap.put("R49W-1", "SWISSMODEL-ERBINMUT-R49W");
            domainNameToFileNameMap.put("R49Y-1", "SWISSMODEL-ERBINMUT-R49Y");

            domainNameToFileNameMap.put("E-27-1", "SWISSMODEL-ERBINMUT10-E27-C8");
            domainNameToFileNameMap.put("E-12-1", "SWISSMODEL-ERBINMUT10-E12-B2");
            domainNameToFileNameMap.put("E-43-1", "SWISSMODEL-ERBINMUT10-E43-E11");
            domainNameToFileNameMap.put("E-2-1", "SWISSMODEL-ERBINMUT10-E2-A2");
            domainNameToFileNameMap.put("E-20-1", "SWISSMODEL-ERBINMUT10-E20-B12");
            domainNameToFileNameMap.put("E-14-1", "SWISSMODEL-ERBINMUT10-E14-B4");
            domainNameToFileNameMap.put("E-30-1", "SWISSMODEL-ERBINMUT10-E30-C12");
            domainNameToFileNameMap.put("E-31-1", "SWISSMODEL-ERBINMUT10-E31-D2");
            domainNameToFileNameMap.put("E-32-1", "SWISSMODEL-ERBINMUT10-E32-D3");
            domainNameToFileNameMap.put("E-33-1", "SWISSMODEL-ERBINMUT10-E33-D4");
            domainNameToFileNameMap.put("E-44-1", "SWISSMODEL-ERBINMUT10-E44-F1");
            domainNameToFileNameMap.put("E-57-1", "SWISSMODEL-ERBINMUT10-E57-G8");
            domainNameToFileNameMap.put("E-58-1", "SWISSMODEL-ERBINMUT10-E58-G9");
        
            domainNameToFileNameMap.put("E-8-1", "SWISSMODEL-ERBINMUT10-E8-A10");
            domainNameToFileNameMap.put("E-9-1", "SWISSMODEL-ERBINMUT10-E9-A11");
            domainNameToFileNameMap.put("E-10-1", "SWISSMODEL-ERBINMUT10-E10-A12");
            domainNameToFileNameMap.put("E-4-1", "SWISSMODEL-ERBINMUT10-E4-A5");
            domainNameToFileNameMap.put("E-7-1", "SWISSMODEL-ERBINMUT10-E7-A9");
            domainNameToFileNameMap.put("E-13-1", "SWISSMODEL-ERBINMUT10-E13-B3");
            domainNameToFileNameMap.put("E-16-1", "SWISSMODEL-ERBINMUT10-E16-B6");
            domainNameToFileNameMap.put("E-29-1", "SWISSMODEL-ERBINMUT10-E29-C11");
            domainNameToFileNameMap.put("E-24-1", "SWISSMODEL-ERBINMUT10-E24-C4");
            domainNameToFileNameMap.put("E-28-1", "SWISSMODEL-ERBINMUT10-E28-C9");
            domainNameToFileNameMap.put("E-38-1", "SWISSMODEL-ERBINMUT10-E38-E4");
            domainNameToFileNameMap.put("E-39-1", "SWISSMODEL-ERBINMUT10-E39-E6");
            domainNameToFileNameMap.put("E-49-1", "SWISSMODEL-ERBINMUT10-E49-F10");
            domainNameToFileNameMap.put("E-50-1", "SWISSMODEL-ERBINMUT10-E50-F11");
            domainNameToFileNameMap.put("E-51-1", "SWISSMODEL-ERBINMUT10-E51-F12");
            domainNameToFileNameMap.put("E-61-1", "SWISSMODEL-ERBINMUT10-E61-G12");
            domainNameToFileNameMap.put("E-54-1", "SWISSMODEL-ERBINMUT10-E54-G4");
            domainNameToFileNameMap.put("E-56-1", "SWISSMODEL-ERBINMUT10-E56-G6");
            
            domainNameToFileNameMap.put("E-5-1", "SWISSMODEL-ERBINMUT10-E5-A6");
            domainNameToFileNameMap.put("E-6-1", "SWISSMODEL-ERBINMUT10-E6-A7");
            domainNameToFileNameMap.put("E-19-1", "SWISSMODEL-ERBINMUT10-E19-B10");
            domainNameToFileNameMap.put("E-11-1", "SWISSMODEL-ERBINMUT10-E11-B1");
            domainNameToFileNameMap.put("E-17-1", "SWISSMODEL-ERBINMUT10-E17-B7");
            domainNameToFileNameMap.put("E-18-1", "SWISSMODEL-ERBINMUT10-E18-B9");
            domainNameToFileNameMap.put("E-22-1", "SWISSMODEL-ERBINMUT10-E22-C2");
            domainNameToFileNameMap.put("E-23-1", "SWISSMODEL-ERBINMUT10-E23-C3");
            domainNameToFileNameMap.put("E-36-1", "SWISSMODEL-ERBINMUT10-E36-D11");
            domainNameToFileNameMap.put("E-42-1", "SWISSMODEL-ERBINMUT10-E42-E10");
            domainNameToFileNameMap.put("E-37-1", "SWISSMODEL-ERBINMUT10-E37-E3");
            domainNameToFileNameMap.put("E-41-1", "SWISSMODEL-ERBINMUT10-E41-E8");
            domainNameToFileNameMap.put("E-46-1", "SWISSMODEL-ERBINMUT10-E46-F6");
            domainNameToFileNameMap.put("E-47-1", "SWISSMODEL-ERBINMUT10-E47-F7");
            domainNameToFileNameMap.put("E-48-1", "SWISSMODEL-ERBINMUT10-E48-F9");
            domainNameToFileNameMap.put("E-59-1", "SWISSMODEL-ERBINMUT10-E59-G10");
            domainNameToFileNameMap.put("E-52-1", "SWISSMODEL-ERBINMUT10-E52-G2");
            domainNameToFileNameMap.put("E-53-1", "SWISSMODEL-ERBINMUT10-E53-G3");
            domainNameToFileNameMap.put("E-55-1", "SWISSMODEL-ERBINMUT10-E55-G5");

            domainNameToFileNameMap.put("E-15-1", "SWISSMODEL-ERBINMUT10-E15-B5");
            domainNameToFileNameMap.put("E-26-1", "SWISSMODEL-ERBINMUT10-E26-C7");
            domainNameToFileNameMap.put("E-34-1", "SWISSMODEL-ERBINMUT10-E34-D7");
            domainNameToFileNameMap.put("E-35-1", "SWISSMODEL-ERBINMUT10-E35-D9");
            domainNameToFileNameMap.put("E-40-1", "SWISSMODEL-ERBINMUT10-E40-E7");
            domainNameToFileNameMap.put("E-45-1", "SWISSMODEL-ERBINMUT10-E45-F5");
            domainNameToFileNameMap.put("E-60-1", "SWISSMODEL-ERBINMUT10-E60-G11");

            domainNameToFileNameMap.put("E-1-1", "SWISSMODEL-ERBINMUT10-E1-A1");
            domainNameToFileNameMap.put("E-3-1", "SWISSMODEL-ERBINMUT10-E3-A4");
            domainNameToFileNameMap.put("E-21-1", "SWISSMODEL-ERBINMUT10-E21-C1");
            domainNameToFileNameMap.put("E-25-1", "SWISSMODEL-ERBINMUT10-E25-C6");
          
            domainNameToFileNameMap.put("F25I-1","SWISSMODEL-ERBINMUT-F25I");
            domainNameToFileNameMap.put("F25L-1","SWISSMODEL-ERBINMUT-F25L");
            domainNameToFileNameMap.put("F25V-1","SWISSMODEL-ERBINMUT-F25V");
            domainNameToFileNameMap.put("H79A-1","SWISSMODEL-ERBINMUT-H79A");
            domainNameToFileNameMap.put("H79C-1","SWISSMODEL-ERBINMUT-H79C");
            domainNameToFileNameMap.put("H79D-1","SWISSMODEL-ERBINMUT-H79D");
            domainNameToFileNameMap.put("H79E-1","SWISSMODEL-ERBINMUT-H79E");
            domainNameToFileNameMap.put("H79F-1","SWISSMODEL-ERBINMUT-H79F");
            domainNameToFileNameMap.put("H79I-1","SWISSMODEL-ERBINMUT-H79I");
            domainNameToFileNameMap.put("H79K-1","SWISSMODEL-ERBINMUT-H79K");
            domainNameToFileNameMap.put("H79L-1","SWISSMODEL-ERBINMUT-H79L");
            domainNameToFileNameMap.put("H79M-1","SWISSMODEL-ERBINMUT-H79M");
            domainNameToFileNameMap.put("H79N-1","SWISSMODEL-ERBINMUT-H79N");
            domainNameToFileNameMap.put("H79P-1","SWISSMODEL-ERBINMUT-H79P");
            domainNameToFileNameMap.put("H79Q-1","SWISSMODEL-ERBINMUT-H79Q");
            domainNameToFileNameMap.put("H79R-1","SWISSMODEL-ERBINMUT-H79R");
            domainNameToFileNameMap.put("H79S-1","SWISSMODEL-ERBINMUT-H79S");
            domainNameToFileNameMap.put("H79T-1","SWISSMODEL-ERBINMUT-H79T");
            domainNameToFileNameMap.put("H79V-1","SWISSMODEL-ERBINMUT-H79V");
            domainNameToFileNameMap.put("H79W-1","SWISSMODEL-ERBINMUT-H79W");
            domainNameToFileNameMap.put("H79Y-1","SWISSMODEL-ERBINMUT-H79Y");
            domainNameToFileNameMap.put("I27L-1","SWISSMODEL-ERBINMUT-I27L");
            domainNameToFileNameMap.put("I27V-1","SWISSMODEL-ERBINMUT-I27V");
            domainNameToFileNameMap.put("L23F-1","SWISSMODEL-ERBINMUT-L23F");
            domainNameToFileNameMap.put("L23I-1","SWISSMODEL-ERBINMUT-L23I");
            domainNameToFileNameMap.put("L23V-1","SWISSMODEL-ERBINMUT-L23V");
            domainNameToFileNameMap.put("Q51A-1","SWISSMODEL-ERBINMUT-Q51A");
            domainNameToFileNameMap.put("Q51D-1","SWISSMODEL-ERBINMUT-Q51D");
            domainNameToFileNameMap.put("Q51E-1","SWISSMODEL-ERBINMUT-Q51E");
            domainNameToFileNameMap.put("Q51G-1","SWISSMODEL-ERBINMUT-Q51G");
            domainNameToFileNameMap.put("Q51H-1","SWISSMODEL-ERBINMUT-Q51H");
            domainNameToFileNameMap.put("Q51I-1","SWISSMODEL-ERBINMUT-Q51I");
            domainNameToFileNameMap.put("Q51K-1","SWISSMODEL-ERBINMUT-Q51K");
            domainNameToFileNameMap.put("Q51L-1","SWISSMODEL-ERBINMUT-Q51L");
            domainNameToFileNameMap.put("Q51M-1","SWISSMODEL-ERBINMUT-Q51M");
            domainNameToFileNameMap.put("Q51N-1","SWISSMODEL-ERBINMUT-Q51N");
            domainNameToFileNameMap.put("Q51P-1","SWISSMODEL-ERBINMUT-Q51P");
            domainNameToFileNameMap.put("Q51R-1","SWISSMODEL-ERBINMUT-Q51R");
            domainNameToFileNameMap.put("Q51S-1","SWISSMODEL-ERBINMUT-Q51S");
            domainNameToFileNameMap.put("Q51T-1","SWISSMODEL-ERBINMUT-Q51T");
            domainNameToFileNameMap.put("Q51V-1","SWISSMODEL-ERBINMUT-Q51V");
            domainNameToFileNameMap.put("R49A-1","SWISSMODEL-ERBINMUT-R49A");
            domainNameToFileNameMap.put("R49C-1","SWISSMODEL-ERBINMUT-R49C");
            domainNameToFileNameMap.put("R49D-1","SWISSMODEL-ERBINMUT-R49D");
            domainNameToFileNameMap.put("R49E-1","SWISSMODEL-ERBINMUT-R49E");
            domainNameToFileNameMap.put("R49F-1","SWISSMODEL-ERBINMUT-R49F");
            domainNameToFileNameMap.put("R49G-1","SWISSMODEL-ERBINMUT-R49G");
            domainNameToFileNameMap.put("R49H-1","SWISSMODEL-ERBINMUT-R49H");
            domainNameToFileNameMap.put("R49I-1","SWISSMODEL-ERBINMUT-R49I");
            domainNameToFileNameMap.put("R49K-1","SWISSMODEL-ERBINMUT-R49K");
            domainNameToFileNameMap.put("R49L-1","SWISSMODEL-ERBINMUT-R49L");
            domainNameToFileNameMap.put("R49M-1","SWISSMODEL-ERBINMUT-R49M");
            domainNameToFileNameMap.put("R49N-1","SWISSMODEL-ERBINMUT-R49N");
            domainNameToFileNameMap.put("R49Q-1","SWISSMODEL-ERBINMUT-R49Q");
            domainNameToFileNameMap.put("R49S-1","SWISSMODEL-ERBINMUT-R49S");
            domainNameToFileNameMap.put("R49T-1","SWISSMODEL-ERBINMUT-R49T");
            domainNameToFileNameMap.put("R49V-1","SWISSMODEL-ERBINMUT-R49V");
            domainNameToFileNameMap.put("R49W-1","SWISSMODEL-ERBINMUT-R49W");
            domainNameToFileNameMap.put("R49Y-1","SWISSMODEL-ERBINMUT-R49Y");
            domainNameToFileNameMap.put("S26I-1","SWISSMODEL-ERBINMUT-S26I");
            domainNameToFileNameMap.put("S26K-1","SWISSMODEL-ERBINMUT-S26K");
            domainNameToFileNameMap.put("S26M-1","SWISSMODEL-ERBINMUT-S26M");
            domainNameToFileNameMap.put("S26N-1","SWISSMODEL-ERBINMUT-S26N");
            domainNameToFileNameMap.put("S26R-1","SWISSMODEL-ERBINMUT-S26R");
            domainNameToFileNameMap.put("S26T-1","SWISSMODEL-ERBINMUT-S26T");
            domainNameToFileNameMap.put("S28A-1","SWISSMODEL-ERBINMUT-S28A");
            domainNameToFileNameMap.put("S28D-1","SWISSMODEL-ERBINMUT-S28D");
            domainNameToFileNameMap.put("S28E-1","SWISSMODEL-ERBINMUT-S28E");
            domainNameToFileNameMap.put("S28G-1","SWISSMODEL-ERBINMUT-S28G");
            domainNameToFileNameMap.put("S28I-1","SWISSMODEL-ERBINMUT-S28I");
            domainNameToFileNameMap.put("S28K-1","SWISSMODEL-ERBINMUT-S28K");
            domainNameToFileNameMap.put("S28M-1","SWISSMODEL-ERBINMUT-S28M");
            domainNameToFileNameMap.put("S28N-1","SWISSMODEL-ERBINMUT-S28N");
            domainNameToFileNameMap.put("S28R-1","SWISSMODEL-ERBINMUT-S28R");
            domainNameToFileNameMap.put("S28T-1","SWISSMODEL-ERBINMUT-S28T");
            domainNameToFileNameMap.put("S28V-1","SWISSMODEL-ERBINMUT-S28V");
            domainNameToFileNameMap.put("T48A-1","SWISSMODEL-ERBINMUT-T48A");
            domainNameToFileNameMap.put("T48D-1","SWISSMODEL-ERBINMUT-T48D");
            domainNameToFileNameMap.put("T48E-1","SWISSMODEL-ERBINMUT-T48E");
            domainNameToFileNameMap.put("T48G-1","SWISSMODEL-ERBINMUT-T48G");
            domainNameToFileNameMap.put("T48K-1","SWISSMODEL-ERBINMUT-T48K");
            domainNameToFileNameMap.put("T48N-1","SWISSMODEL-ERBINMUT-T48N");
            domainNameToFileNameMap.put("T48R-1","SWISSMODEL-ERBINMUT-T48R");
            domainNameToFileNameMap.put("T48S-1","SWISSMODEL-ERBINMUT-T48S");
            domainNameToFileNameMap.put("V83A-1","SWISSMODEL-ERBINMUT-V83A");
            domainNameToFileNameMap.put("V83E-1","SWISSMODEL-ERBINMUT-V83E");
            domainNameToFileNameMap.put("V83I-1","SWISSMODEL-ERBINMUT-V83I");
            domainNameToFileNameMap.put("V83K-1","SWISSMODEL-ERBINMUT-V83K");
            domainNameToFileNameMap.put("V83L-1","SWISSMODEL-ERBINMUT-V83L");
            domainNameToFileNameMap.put("V83Q-1","SWISSMODEL-ERBINMUT-V83Q");
            domainNameToFileNameMap.put("V83T-1","SWISSMODEL-ERBINMUT-V83T");

            domainNameToFileNameMap.put("MLLT4-1","1T2M-MLLT4-1");
            */
        }
        else if (organism.equals(Constants.MOUSE)||
               organism.equals(Constants.MOUSE_ORPHAN))
        {
            //domainNameToFileNameMap.put("GRIP2-5","SWISSMODEL-GRIP2-5");
            //domainNameToFileNameMap.put("GM1582-2","SWISSMODEL-GM1582-2");
            domainNameToFileNameMap.put("DVL1-1","1MC7-DVL1-1");
            domainNameToFileNameMap.put("PTP-BL-2","1VJ6-PTP-BL-2");
            domainNameToFileNameMap.put("PDZ-RGS3-1","1WHD-PDZ-RGS3-1");
            domainNameToFileNameMap.put("A1-SYNTROPHIN-1","1Z86-A1-SYNTROPHIN-1");
            domainNameToFileNameMap.put("PDZK1-1","2EDZ-PDZK1-1");
            domainNameToFileNameMap.put("B1-SYNTROPHIN-1","SWISSMODEL-B1-SYNTROPHIN-1");
            domainNameToFileNameMap.put("CHAPSYN-110-2","SWISSMODEL-CHAPSYN-110-2");
            domainNameToFileNameMap.put("CHAPSYN-110-3","SWISSMODEL-CHAPSYN-110-3");
            domainNameToFileNameMap.put("CIPP-10","SWISSMODEL-CIPP-10");
            domainNameToFileNameMap.put("CIPP-3","SWISSMODEL-CIPP-3");
            domainNameToFileNameMap.put("CIPP-5","SWISSMODEL-CIPP-5");
            domainNameToFileNameMap.put("CIPP-8","SWISSMODEL-CIPP-8");
            domainNameToFileNameMap.put("CIPP-9","SWISSMODEL-CIPP-9");
            domainNameToFileNameMap.put("DVL3-1","SWISSMODEL-DVL3-1");
            domainNameToFileNameMap.put("ERBIN-1","SWISSMODEL-ERBIN-1");
            domainNameToFileNameMap.put("GRIP1-6","SWISSMODEL-GRIP1-6");
            domainNameToFileNameMap.put("HARMONIN-2","SWISSMODEL-HARMONIN-2");
            domainNameToFileNameMap.put("LARG-1","SWISSMODEL-LARG-1");
            domainNameToFileNameMap.put("LIN-7C-1","SWISSMODEL-LIN-7C-1");
            ///domainNameToFileNameMap.put("LNX1-2","SWISSMODEL-LNX1-2");
            domainNameToFileNameMap.put("LRRC7-1","SWISSMODEL-LRRC7-1");
            domainNameToFileNameMap.put("MAGI-1-6","SWISSMODEL-MAGI-1-6");
            domainNameToFileNameMap.put("MAGI-2-2","SWISSMODEL-MAGI-2-2");
            domainNameToFileNameMap.put("MAGI-2-5","SWISSMODEL-MAGI-2-5");
            domainNameToFileNameMap.put("MAGI-2-6","SWISSMODEL-MAGI-2-6");
            domainNameToFileNameMap.put("MAGI-3-1","SWISSMODEL-MAGI-3-1");
            domainNameToFileNameMap.put("MAGI-3-2","SWISSMODEL-MAGI-3-2");
            domainNameToFileNameMap.put("MAGI-3-5","SWISSMODEL-MAGI-3-5");
            domainNameToFileNameMap.put("MALS2-1","SWISSMODEL-MALS2-1");
            domainNameToFileNameMap.put("MPP7-1","SWISSMODEL-MPP7-1");
            domainNameToFileNameMap.put("MUPP1-1","SWISSMODEL-MUPP1-1");
            domainNameToFileNameMap.put("MUPP1-10","SWISSMODEL-MUPP1-10");
            domainNameToFileNameMap.put("MUPP1-11","SWISSMODEL-MUPP1-11");
            domainNameToFileNameMap.put("MUPP1-12","SWISSMODEL-MUPP1-12");
            domainNameToFileNameMap.put("MUPP1-13","SWISSMODEL-MUPP1-13");
            domainNameToFileNameMap.put("MUPP1-5","SWISSMODEL-MUPP1-5");
            domainNameToFileNameMap.put("NHERF-1-1","SWISSMODEL-NHERF-1-1");
            domainNameToFileNameMap.put("NHERF-2-2","SWISSMODEL-NHERF-2-2");
            domainNameToFileNameMap.put("NNOS-1","SWISSMODEL-NNOS-1");
            domainNameToFileNameMap.put("OMP25-1","SWISSMODEL-OMP25-1");
            domainNameToFileNameMap.put("PAR6B-1","SWISSMODEL-PAR6B-1");
            domainNameToFileNameMap.put("PDZK1-3","SWISSMODEL-PDZK1-3");
            domainNameToFileNameMap.put("PDZK11-1","SWISSMODEL-PDZK11-1");
            domainNameToFileNameMap.put("PSD95-1","SWISSMODEL-PSD95-1");
            domainNameToFileNameMap.put("PSD95-2","SWISSMODEL-PSD95-2");
            domainNameToFileNameMap.put("PSD95-3","SWISSMODEL-PSD95-3");
            domainNameToFileNameMap.put("SAP102-2","SWISSMODEL-SAP102-2");
            domainNameToFileNameMap.put("SAP102-3","SWISSMODEL-SAP102-3");
            domainNameToFileNameMap.put("SAP97-1","SWISSMODEL-SAP97-1");
            domainNameToFileNameMap.put("SAP97-2","SWISSMODEL-SAP97-2");
            domainNameToFileNameMap.put("SAP97-3","SWISSMODEL-SAP97-3");
            domainNameToFileNameMap.put("SCRB1-1","SWISSMODEL-SCRB1-1");
            domainNameToFileNameMap.put("SCRB1-2","SWISSMODEL-SCRB1-2");
          domainNameToFileNameMap.put("SCRB1-3","SWISSMODEL-SCRB1-3");
            domainNameToFileNameMap.put("SEMCAP3-1","SWISSMODEL-SEMCAP3-1");
            domainNameToFileNameMap.put("SHANK1-1","SWISSMODEL-SHANK1-1");
            domainNameToFileNameMap.put("SHANK3-1","SWISSMODEL-SHANK3-1");
          domainNameToFileNameMap.put("SHROOM-1","SWISSMODEL-SHROOM-1");
            domainNameToFileNameMap.put("SLIM-1","SWISSMODEL-SLIM-1");
            //domainNameToFileNameMap.put("TIP-1-1","SWISSMODEL-TIP-1-1");
            domainNameToFileNameMap.put("ZO-1-1","SWISSMODEL-ZO-1-1");
            domainNameToFileNameMap.put("ZO-2-1","SWISSMODEL-ZO-2-1");
          domainNameToFileNameMap.put("ZO-3-1","SWISSMODEL-ZO-3-1");

            domainNameToFileNameMap.put("GOPC1-1", "SWISSMODEL-GOPC1-1");
            domainNameToFileNameMap.put("MAGI-2-3", "SWISSMODEL-MAGI-2-3");
            domainNameToFileNameMap.put("MAGI-2-4", "SWISSMODEL-MAGI-2-4");
            domainNameToFileNameMap.put("MUPP1-2", "SWISSMODEL-MUPP1-2");
            domainNameToFileNameMap.put("NHERF1-2", "SWISSMODEL-NHERF-1-2");
            domainNameToFileNameMap.put("PDZK1-4", "SWISSMODEL-PDZK1-4");
            domainNameToFileNameMap.put("SCRB-1-4", "SWISSMODEL-SCRB1-4");
            domainNameToFileNameMap.put("IL-16-3", "SWISSMODEL-IL-16-3");
            domainNameToFileNameMap.put("GRIP-1-4", "SWISSMODEL-GRIP1-4");
            domainNameToFileNameMap.put("GRIP-1-5", "SWISSMODEL-GRIP1-5");
            domainNameToFileNameMap.put("PAR-6G-1", "SWISSMODEL-PAR6G-1");
            domainNameToFileNameMap.put("CIPP-7", "SWISSMODEL-CIPP-7");
            domainNameToFileNameMap.put("MUPP1-6", "SWISSMODEL-MUPP1-6");
            domainNameToFileNameMap.put("DELPHILIN-1", "SWISSMODEL-DELPHILIN-1");
            domainNameToFileNameMap.put("PAR-3B-3", "SWISSMODEL-PAR-3B-3");
            domainNameToFileNameMap.put("RGS-12-1", "SWISSMODEL-RGS-12-1");
            domainNameToFileNameMap.put("MAGI-1-1", "SWISSMODEL-MAGI-1-1");
            domainNameToFileNameMap.put("A330043P19-1", "SWISSMODEL-A330043P19-1");
            domainNameToFileNameMap.put("PDZK-7-1", "SWISSMODEL-PDZK-7-1");
            domainNameToFileNameMap.put("DLG-5-2", "SWISSMODEL-DLG-5-2");

            // TAP PSD95
            domainNameToFileNameMap.put("CHAPSYN-110-1", "SWISSMODEL-CHAPSYN-110-1");
            domainNameToFileNameMap.put("SAP102-1", "SWISSMODEL-SAP102-1");
            domainNameToFileNameMap.put("SHANK2-1", "SWISSMODEL-SHANK2-1");
            domainNameToFileNameMap.put("MAGI-3-4", "SWISSMODEL-MAGI-3-4");
            domainNameToFileNameMap.put("MAGI-3-5_", "SWISSMODEL-MAGI-3-5_");
            domainNameToFileNameMap.put("FRPD4-1", "SWISSMODEL-FRPD4-1");
            domainNameToFileNameMap.put("CNKR2-1", "SWISSMODEL-CNKR2-1");
        }
        else if (organism.equals(Constants.FLY))
        {
            // CHEN FLY PDB
            domainNameToFileNameMap.put("DLG-1-1", "SWISSMODEL-DLG-1-1");
            domainNameToFileNameMap.put("DSH-1", "SWISSMODEL-DSH-1");
            domainNameToFileNameMap.put("MAGI-4", "SWISSMODEL-MAGI-4");
            domainNameToFileNameMap.put("PATJ-2", "SWISSMODEL-PATJ-2");
            domainNameToFileNameMap.put("PAR6-1", "1RY4-PAR6-1");
            domainNameToFileNameMap.put("LAP4-2", "SWISSMODEL-LAP4-2");
            domainNameToFileNameMap.put("LAP4-3", "SWISSMODEL-LAP4-3");


        }
        else if (organism.equals(Constants.WORM))
        {
            // CHEN WORM PDB
            domainNameToFileNameMap.put("DLG1-1", "SWISSMODEL-DLG1-1");
            domainNameToFileNameMap.put("DLG1-3", "SWISSMODEL-DLG1-3");
            domainNameToFileNameMap.put("DSH-1", "SWISSMODEL-DSH-1");
            domainNameToFileNameMap.put("LIN7-1", "SWISSMODEL-LIN7-1");
            domainNameToFileNameMap.put("STN2-1", "SWISSMODEL-STN2-1");
            domainNameToFileNameMap.put("MPZ1-6", "SWISSMODEL-MPZ1-6");
            domainNameToFileNameMap.put("NAB1-1", "SWISSMODEL-NAB1-1");

            // SIDHU WORM PDB
            domainNameToFileNameMap.put("F25H2.2-1", "SWISSMODEL-F25H2.2-1");
            //domainNameToFileNameMap.put("T10A3.1a-1", "SWISSMODEL-T10A3.1a-1");
            domainNameToFileNameMap.put("C43E11.6a-1", "SWISSMODEL-C43E11.6a-1");
            //domainNameToFileNameMap.put("C09H6.2a-2", "SWISSMODEL-C09H6.2a-2");
            domainNameToFileNameMap.put("W03F11.6a-1", "SWISSMODEL-W03F11.6a-1");
            domainNameToFileNameMap.put("C10C6.1-1", "SWISSMODEL-C10C6.1-1");
            domainNameToFileNameMap.put("H09G03.2a-1", "SWISSMODEL-H09G03.2a-1");
            //domainNameToFileNameMap.put("T21G5.4-1", "SWISSMODEL-T21G5.4-1");
            domainNameToFileNameMap.put("W03F11.6a-1", "SWISSMODEL-W03F11.6a-1");
            domainNameToFileNameMap.put("K01A6.2-4", "SWISSMODEL-K01A6.2-4");
            //domainNameToFileNameMap.put("T10A3.1a-1", "SWISSMODEL-T10A3.1a-1");
            domainNameToFileNameMap.put("Y38C1AB.8-2", "SWISSMODEL-Y38C1AB.8-2");

        }
    }

    public Features encodeFeatures(String domainName)
    {

        String dirName = (String)domainNameToFileNameMap.get(domainName);
        //String filename = DataFileManager.DATA_ROOT_DIR + "/Data/Human/PDZ/VASCo/1KWA-CASK-1/msms_out/1KWA+CASK+1.pdb-0.vert";
        //String filename = DataFileManager.DATA_ROOT_DIR + "/Data/Human/PDZ/VASCo/1MFL-ERBB2IP-1/msms_out/1MFL+ERBB2IP+1.pdb-0.vert";
        String file = dirName.replace('-','+');
        String frcFileName = vascoDir+dirName+"/msms_out/"+file+".pdb-0.vert";
        Features f = new Features();
        featureValues = new ArrayList();

        try
        {
            String line = "";
            BufferedReader br = new BufferedReader(new FileReader(new File(frcFileName)));
            HashMap gridToResidueInfoMap = new HashMap();
            HashMap residueNumToInfoMap = new HashMap();
            while((line=br.readLine())!=null)
            {
                line = line.trim();
                String[] split = line.split("\\s+");
                String token = split[split.length-1];
                String[] tokenSplit = token.split("_");
                //String key = tokenSplit[3]+"_" + tokenSplit[4];
                String atom = tokenSplit[tokenSplit.length-1];
                double x = Double.parseDouble(split[0]);
                //System.out.println(split[0] + "," + split[1] + "," + split[2]);
                double y = Double.parseDouble(split[1]);
                double z = Double.parseDouble(split[2]);
                ResidueInfo r = new ResidueInfo();
                r.atom = tokenSplit[5];
                r.residueNum = Integer.parseInt(tokenSplit[4].trim());
                r.residue = tokenSplit[3];
                if (split[2].equals("-0.000"))
                    split[2] = "0.000";
                if (split[1].equals("-0.000"))
                    split[1] = "0.000";
                if (split[0].equals("-0.000"))
                    split[0] = "0.000";
                String key = split[0]+"0,"+split[1]+"0,"+split[2] + "0";


                gridToResidueInfoMap.put(key, r);


            }
            br.close();

            String filename_HYD = vascoDir+dirName+"/hyd_out/"+dirName+".pdb-0_hyd.csv";

            List residueList = bindingSite.getResidueNumList(domainName);
            residueNumToNameMap = bindingSite.getResidueNumToNameMap(domainName);

            //System.out.println(residueList);
            //System.out.println("===" + domainName);
            br = new BufferedReader(new FileReader(new File(filename_HYD)));
            line = "";
            List hydPotList = new ArrayList();
            while((line=br.readLine())!=null)
            {
                String[] split = line.split(";");
                double hydPot = Double.parseDouble(split[1]);
                hydPotList.add(hydPot);
            }
            String filename_DELPHI = vascoDir+dirName+"/delphi_out/"+file+".pdb-0.frc";
            br = new BufferedReader(new FileReader(new File(filename_DELPHI)));
            line = "";

            boolean startReading = false;
            int ix = 0;
            while((line=br.readLine())!=null)
            {
                line=line.trim();
                if (line.startsWith("total"))
                    continue;
                if (startReading)
                {
                    String[] split = line.split("\\s+");
                    if (split[2].equals("-0.0000"))
                        split[2] = "0.0000";
                    if (split[1].equals("-0.0000"))
                        split[1] = "0.0000";
                    if (split[0].equals("-0.0000"))
                        split[0] = "0.0000";
                    String gridKey = split[0]+","+split[1]+","+split[2];

                    double x =Double.parseDouble(split[0]);
                    double y =Double.parseDouble(split[1]);
                    double z =Double.parseDouble(split[2]);

                    //double elecPot = Double.parseDouble(split[4]);
                    double hydPot = (Double)hydPotList.get(ix);
                    ix = ix+1;
                    ResidueInfo r = (ResidueInfo) gridToResidueInfoMap.get(gridKey);
                    if (r==null)
                        System.out.println(gridKey);
                    int residueKey =  r.residueNum;

                    //System.out.println(residueKey+"*");

                    if (residueList.contains(residueKey))
                    {
                        //System.out.println(residueKey + ": " + r.atom +":" + line);
                        r.hydPot = hydPot;
                        r.x = x;
                        r.y = y;
                        r.z = z;
                        List rInfoList = (List)residueNumToInfoMap.get(residueKey);
                        if (rInfoList == null)
                            rInfoList = new ArrayList();
                        rInfoList.add(r);
                        residueNumToInfoMap.put(residueKey, rInfoList);

                    }

                }
                if (line.startsWith("ATOM"))
                {
                    startReading = true;
                }
            }
            br.close();

            Set keys = residueNumToNameMap.keySet();
            List keyList=new ArrayList(keys);

            Collections.sort(keyList);
            for (int i=0; i< keyList.size();i++)
            {
                int key = (Integer)keyList.get(i);
                List rInfoList = (List)residueNumToInfoMap.get(key);
                Collections.sort(rInfoList);
                List sampledRInfoList = new ArrayList();

                int total = rInfoList.size();

                int ix1 = 1;
                /*int ix17  = total;
                int ix9 = (ix1+ix17)/2;
                int ix13= (ix9+ix17)/2;
                int ix11 = (ix9+ix13)/2;
                int ix10 = (ix9+ix11)/2;
                int ix12 = (ix11+ix13)/2;
                int ix15 = (ix13+ix17)/2;
                int ix14 = (ix13 + ix15)/2;
                int ix16 = (ix15+ix17)/2;
                */
                int ix9 = total;
                // 5 values
                /*int ix3 = (ix1+ix9)/2;
                int ix2 = (ix1+ix3)/2;
                int ix4 = (ix3+ix9)/2;
                */
                int ix5 = (ix1+ix9)/2;
                int ix3 = (ix1+ix5)/2;
                int ix7 = (ix5+ix9)/2;
                int ix2 = (ix1+ix3)/2;
                int ix4 = (ix3+ix5)/2;
                int ix6 = (ix5+ix7)/2;
                int ix8 = (ix7+ix9)/2;

                List ixList = new ArrayList();
                ixList.add(ix1);
                ixList.add(ix2);
                ixList.add(ix3);
                ixList.add(ix4);
                ixList.add(ix5);
                ixList.add(ix6);
                ixList.add(ix7);
                ixList.add(ix8);
                ixList.add(ix9);
                /*ixList.add(ix10);
                ixList.add(ix11);
                ixList.add(ix12);
                ixList.add(ix13);
                ixList.add(ix14);
                ixList.add(ix15);
                ixList.add(ix16);
                ixList.add(ix17);
                */
                //System.out.println(ixList);

                for (int j = 0; j < ixList.size();j++)
                {
                    ResidueInfo r = (ResidueInfo)rInfoList.get((Integer)ixList.get(j)-1);
                    //System.out.println((j+1)+ ": " + r.residue + " " + r.residueNum + " " + r.atom + "(" +r.x + "," + r.y + "," + r.z +"): " + r.hydPot);
                    sampledRInfoList.add(r);
                    featureValues.add(r.hydPot);
                }

                /*System.out.println(sampledRInfoList.size());
                if (sampledRInfoList.size()!=9)
                    System.out.println("***");
                */
            }
            f.addFeatureValues(featureValues);

        }
        catch(Exception e)
        {
            //System.out.println("Exception: " + e);
            //e.printStackTrace();
        }
        return f;
    }

    public List encodeFeature(String domainName)
    {
        return new ArrayList();
    }
    public static void main (String[] args)
    {
        String organism = args[1];
        HydrophobicitySurfaceFeatureEncoding hyd = new HydrophobicitySurfaceFeatureEncoding(organism);
        //HydrophobicitySurfaceFeatureEncoding hyd = new HydrophobicitySurfaceFeatureEncoding(Constants.MOUSE);
        //HydrophobicitySurfaceFeatureEncoding hyd = new HydrophobicitySurfaceFeatureEncoding(Constants.FLY);
        //HydrophobicitySurfaceFeatureEncoding hyd = new HydrophobicitySurfaceFeatureEncoding(Constants.WORM);
        //HydrophobicitySurfaceFeatureEncoding hyd = new HydrophobicitySurfaceFeatureEncoding(Constants.MOUSE_ORPHAN);

        /*DataLoader dl = new DataLoader();
        //dl.loadMousePDBTest(Constants.CHEN_MOUSE_ORPHAN_PDB);
        dl.loadMouseTest(Constants.MOUSE_ORPHAN);

        List posTrainProfileList = dl.getPosTestProfileList();
        List negTrainProfileList = dl.getNegTestProfileList();
        List seenList = new ArrayList();
        for (int i=0;i < posTrainProfileList.size();i++)
        {
            ProteinProfile profile = (ProteinProfile)posTrainProfileList.get(i);
            seenList.add(profile.getName());
            String domainName = profile.getName();//args[0];
            System.out.println(domainName);

            Features ft = hyd.encodeFeatures(domainName);
            System.out.println(domainName +"\t" + ft.numFeatures());
            System.out.println(ft.getFeatureValues());
        }
        for (int i=0;i < negTrainProfileList.size();i++)
        {
            ProteinProfile profile = (ProteinProfile)negTrainProfileList.get(i);
            String domainName = profile.getName();//args[0];
            if (seenList.contains(domainName))
                continue;
            System.out.println(domainName);

            Features ft = hyd.encodeFeatures(domainName);
            System.out.println(domainName +"\t" + ft.numFeatures());
            System.out.println(ft.getFeatureValues());
        }
        */
        List domainNameList = new ArrayList();
        /*domainNameList.add("GRD2I-1");
        domainNameList.add("MAGI2-3");
        domainNameList.add("MAGI3-3");
        domainNameList.add("PDZD2-4");
        domainNameList.add("SDCB1-1");
        */
        domainNameList.add("SDCBP-1");
        
        for(int i=0; i < domainNameList.size();i++)
        {
            String domainName = (String)domainNameList.get(i);
        Features ft = hyd.encodeFeatures(domainName);
        System.out.println(domainName +"\t" + ft.numFeatures());
        System.out.println(ft.getFeatureValues());
        }
    }

    private class ResidueInfo implements Comparable
    {
        String atom = "";
        double x = 0;
        double y = 0;
        double z = 0;
        String residue = "";
        int residueNum = 0;
        double hydPot = 0.0;

        public void print()
        {
            System.out.println(residueNum +":" + residue + ": " + atom + "= " +hydPot);

        }
        public int compareTo(Object compareTo)
        {
            ResidueInfo r2 = (ResidueInfo) compareTo;
            int i = Double.compare(this.x,r2.x);
            if (i != 0) return i;

            i = Double.compare(this.y,r2.y);
            if (i != 0) return i;

            i = Double.compare(this.z,r2.z);
            return i;
        }
    }
}