package org.baderlab.pdzsvmstruct.encoding;

import org.baderlab.pdzsvmstruct.utils.BindingSiteUtils;

import java.util.List;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class Sidhu10FeatureEncoding extends FeatureEncoding
{
    public final static int numContacts = 29;
    public int[][] contactPositions = new int[numContacts][2];
    private BindingSiteUtils bs;

    public Sidhu10FeatureEncoding()
    {
        setEncodingName("SIDHU10");
        loadContactPositions();
    }

    protected List encodeFeature(String value)
    {
        // Does nothing
        return null;
    }
    public String getFeatures(String domainName, String organism)
    {       
        bs = new BindingSiteUtils(organism);
        String domain10Seq = bs.getBindingSiteSequence(domainName);
        return domain10Seq;
    }

    private void loadContactPositions()
    {
        // Sidhu contact map is all of chen's contact map minus pairs involving
        // positions 0,2,7,11,13,15 of original map
        // 9 of chen's positions removed
        contactPositions[0] = new int[]{0,4};
        contactPositions[1] = new int[]{1,2};
        contactPositions[2] = new int[]{1,3};
        contactPositions[3] = new int[]{1,4};
        contactPositions[4] = new int[]{2,1};
        contactPositions[5] = new int[]{2,2};
        contactPositions[6] = new int[]{2,3};
        contactPositions[7] = new int[]{2,4};
        contactPositions[8] = new int[]{3,0};
        contactPositions[9] = new int[]{3,1};
        contactPositions[10] = new int[]{3,2};
        contactPositions[11] = new int[]{3,3};
        contactPositions[12] = new int[]{3,4};
        contactPositions[13] = new int[]{4,0};
        contactPositions[14] = new int[]{4,1};
        contactPositions[15] = new int[]{4,2};
        contactPositions[16] = new int[]{5,1};
        contactPositions[17] = new int[]{6,1};
        contactPositions[18] = new int[]{6,3};
        contactPositions[19] = new int[]{7,2};
        contactPositions[20] = new int[]{7,3};
        contactPositions[21] = new int[]{7,4};
        contactPositions[22] = new int[]{8,0};
        contactPositions[23] = new int[]{8,1};
        contactPositions[24] = new int[]{8,2};
        contactPositions[25] = new int[]{9,0};
        contactPositions[26] = new int[]{9,2};
        contactPositions[27] = new int[]{9,3};
        contactPositions[28] = new int[]{9,4};

    }


}
