package org.baderlab.pdzsvmstruct.utils;

import org.baderlab.pdzsvmstruct.data.manager.DataFileManager;

import java.util.*;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;

import libsvm.svm_parameter;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class BindingSiteUtils
{
    private String definitionFile ="";
    private HashMap domainNameToResidueNumListMap = new HashMap();
    private HashMap domainNameToIndicatorListMap = new HashMap();
    private HashMap domainNameToResidueNumToNameMapMap = new HashMap();
    private HashMap domainNameToResidueListMap = new HashMap();
    private HashMap domainNameToFullSeqMap = new HashMap();

    private int EXCLUDE_POS =-1;
    public BindingSiteUtils(String organism)
    {
        this(organism, svm_parameter.SIDHU_CONTACTMAP);
    }
    public BindingSiteUtils(String organism, int encoding, int excludePos)
    {
        this(organism, encoding);
        EXCLUDE_POS = excludePos;
    }
    public BindingSiteUtils(String organism, int encoding)
    {
        if (organism.equals(Constants.MOUSE) ||
                organism.equals(Constants.MOUSE_ORPHAN))
        {
            definitionFile = DataFileManager.DATA_ROOT_DIR +"/Data/Mouse/PDZ/BindingSite/Tonikian10BindingSiteDefinition.txt";
        }
        else if (organism.equals(Constants.FLY))
        {
            definitionFile = DataFileManager.DATA_ROOT_DIR +"/Data/Fly/PDZ/BindingSite/Tonikian10BindingSiteDefinition.txt";
            
        }
        else if (organism.equals(Constants.WORM))
        {
            definitionFile = DataFileManager.DATA_ROOT_DIR +"/Data/Worm/PDZ/BindingSite/Tonikian10BindingSiteDefinition.txt";
        }
        else if (organism.equals(Constants.HUMAN))
        {
            definitionFile = DataFileManager.DATA_ROOT_DIR +"/Data/Human/PDZ/BindingSite/Tonikian10BindingSiteDefinition.txt";
        }
        try
        {
            BufferedReader br = new BufferedReader(new FileReader(new File(definitionFile))) ;
            String line="";

            String prevDomainName = "";
            while((line=br.readLine())!=null)
            {
                HashMap residueNumToNameMap = new HashMap();
                List indicatorList = new ArrayList();
                List resList = new ArrayList();

                List resNumList = new ArrayList();
                if (line.startsWith ("#"))
                    continue;
                String[] splitLine = line.split("\\s+");
                String domainName = splitLine[0];
                if(splitLine.length<2)
                    System.out.println("Problem: " + prevDomainName);
                int startIx = Integer.parseInt(splitLine[1]);
                String seq = br.readLine();
                String indString = br.readLine();
                //System.out.println(indString);
                String seq3 = "";
                int pos = 0;

                for (int i=0; i < indString.length();i++)
                {

                    char indChar = indString.charAt(i);
                    char res = seq.charAt(i);
                    if (indChar == 'x')
                    {
                        if (pos != EXCLUDE_POS)
                        {
                            seq3 = seq3 +res;
                            int ix = startIx+i;
                            String threeLetterRes = PDZSVMUtils.convertSingleAATo3Letter(res);
                            resNumList.add(ix);
                            residueNumToNameMap.put(ix, threeLetterRes);
                            indicatorList.add(String.valueOf(indChar));
                            resList.add(String.valueOf(res));

                        }
                        else
                        {
                            indicatorList.add("-");
                            resList.add(String.valueOf(res));                            

                        }
                        pos =pos+1;
                    }
                    else
                    {
                        indicatorList.add(String.valueOf(indChar));
                        resList.add(String.valueOf(res));
                        
                    }
                }
                domainNameToIndicatorListMap.put(domainName, indicatorList);
                domainNameToResidueListMap.put(domainName, resList);
                domainNameToFullSeqMap.put(domainName, seq);
                domainNameToResidueNumListMap.put(domainName, resNumList);
                domainNameToResidueNumToNameMapMap.put(domainName, residueNumToNameMap);
                prevDomainName = domainName;
            }
            br.close();

        }
        catch(Exception e)
        {
            System.out.println("Definition file is " + definitionFile);
            System.out.println("Exception: "+e);
            e.printStackTrace();
        }
    }
    public List getDomainNamesList()
    {
        Set keys = domainNameToResidueListMap.keySet();
        List domainNames = new ArrayList(keys);
        return domainNames;
    }
    public List getIndicatorList(String domainName)
    {
        return (List)domainNameToIndicatorListMap.get(domainName);
    }
    public List getResidueList(String domainName)
    {
        return (List)domainNameToResidueListMap.get(domainName);
    }
    public List getResidueNumList(String domainName)
    {
        return (List)domainNameToResidueNumListMap.get(domainName);
    }
    public String getDomainSequence(String domainName)
    {
        return (String)domainNameToFullSeqMap.get(domainName);
    }
    public HashMap getResidueNumToNameMap(String domainName)
    {
        return (HashMap)domainNameToResidueNumToNameMapMap.get(domainName);
    }
    public String getBindingSiteSequence(String domainName)
    {
        List indList = (List)domainNameToIndicatorListMap.get(domainName);
        List residueList = (List)domainNameToResidueListMap.get(domainName);
        String seq = "";
        if (residueList != null)
        {
            for (int i=0; i< residueList.size();i++)
            {
                String ind = (String) indList.get(i);
                if (ind.equals("x"))
                {
                    String res = (String) residueList.get(i);
                    seq = seq +res;
                }
            }
        }
        return seq;
    }


    public static void main(String[] args)
    {
        BindingSiteUtils bs = new BindingSiteUtils(Constants.HUMAN);;
        List domainNamesList = new ArrayList();
        domainNamesList.add("MPDZ-5");
        domainNamesList.add("INADL-5");
        domainNamesList.add("INADL-8");
        domainNamesList.add("GRIP2-6");
        domainNamesList.add("GRIP1-6");
        domainNamesList.add("GRIP1-7");
        domainNamesList.add("MAGI1-5");
        domainNamesList.add("MAGI3-4");
        domainNamesList.add("PDZK1-3");
        domainNamesList.add("WHRN-2");
        domainNamesList.add("SLC9A3R1-2");
        domainNamesList.add("DVL1-1");
        domainNamesList.add("DVL1L1-1");
        domainNamesList.add("RAPGEF6-1");
        domainNamesList.add("PDZK1P1-2");
        domainNamesList.add("PDZRN4-2");
        domainNamesList.add("APBA3-1");
        
        for (int i=0; i < domainNamesList.size();i++)
        {
            String domainName = (String)domainNamesList.get(i);
            String domainSeq = bs.getBindingSiteSequence(domainName);
            System.out.println(domainName +"\t"+domainSeq);
        }

    }


}
