package org.baderlab.pdzsvmstruct.encoding;

import org.baderlab.pdzsvmstruct.data.DataLoader;
import org.baderlab.pdzsvmstruct.data.Data;
import org.baderlab.pdzsvmstruct.utils.Constants;

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class DomainFeatureEncoding extends FeatureEncoding
{
    protected HashMap organismToJoyFeatureEncoderMap = new HashMap();
    protected HashMap organismToSurfvFeatureEncoderMap = new HashMap();
    protected HashMap organismTo3DZernikeFeatureEncoderMap = new HashMap();
    protected HashMap organismToElecFeatureEncoderMap = new HashMap();
    protected HashMap organismToHydFeatureEncoderMap = new HashMap();
    protected HashMap domainOrganismToFeaturesMap = new HashMap();
    protected HashMap organismToBsqFeatureEncoderMap = new HashMap();
    public static int JOY = 0;
    public static int SURFV = 1;
    public static int ELEC = 2;
    public static int HYD = 3;
    public static int ZER = 4;

    public int EXCLUDE_FEATURE =-1;
    public static String[] FEATURE_NAMES = new String[]{"Joy","Surfv","Elec","Hyd", "Zer"};

    public DomainFeatureEncoding(List organismList)
    {
       this(organismList, -1);

    }
    public DomainFeatureEncoding(List organismList, int excludeFeature)
    {
        setEncodingName("DOMAIN");
        EXCLUDE_FEATURE = excludeFeature;
        if (excludeFeature >=0)
            System.out.println("\tExcluding feature: " + FEATURE_NAMES[EXCLUDE_FEATURE]);

        for (int i=0;i < organismList.size();i++)
        {

            String organism = (String) organismList.get(i);

            JoyFeatureEncoding joy = new JoyFeatureEncoding(organism);
            SurfvFeatureEncoding surfv = new SurfvFeatureEncoding(organism);
            ElectrostaticSurfaceFeatureEncoding elec = new ElectrostaticSurfaceFeatureEncoding(organism);
            HydrophobicitySurfaceFeatureEncoding hyd = new HydrophobicitySurfaceFeatureEncoding(organism);
            ZernikeFeatureEncoding zer = new ZernikeFeatureEncoding(organism);

            organismToJoyFeatureEncoderMap.put(organism,joy);
            organismToSurfvFeatureEncoderMap.put(organism,surfv);
            organismTo3DZernikeFeatureEncoderMap.put(organism,zer);
            organismToElecFeatureEncoderMap.put(organism,elec);
            organismToHydFeatureEncoderMap.put(organism,hyd);
        }
    }

    public List encodeFeature(String site)
    {
        return new ArrayList();
    }
    public Features encodeFeatures(String domainName, String organism)
    {

        featureValues = new ArrayList();

        JoyFeatureEncoding joy = (JoyFeatureEncoding)organismToJoyFeatureEncoderMap.get(organism);
        SurfvFeatureEncoding surfv = (SurfvFeatureEncoding)organismToSurfvFeatureEncoderMap.get(organism);
        ZernikeFeatureEncoding zer = (ZernikeFeatureEncoding)organismTo3DZernikeFeatureEncoderMap.get(organism);
        ElectrostaticSurfaceFeatureEncoding elec = (ElectrostaticSurfaceFeatureEncoding)organismToElecFeatureEncoderMap.get(organism);
        HydrophobicitySurfaceFeatureEncoding hyd = (HydrophobicitySurfaceFeatureEncoding)organismToHydFeatureEncoderMap.get(organism);

        if (EXCLUDE_FEATURE ==-1)
        {
            Features joyFeatures =  joy.encodeFeatures(domainName);
            List joyFeaturesList = joyFeatures.getFeatureValues();
            featureValues.addAll(joyFeaturesList);
            Features surfvFeatures = surfv.encodeFeatures(domainName);
            List surfvFeaturesList = surfvFeatures.getFeatureValues();
            featureValues.addAll(surfvFeaturesList);
            Features elecFeatures = elec.encodeFeatures(domainName);
            List elecFeaturesList = elecFeatures.getFeatureValues();
            featureValues.addAll(elecFeaturesList);
            Features hydFeatures = hyd.encodeFeatures(domainName);
            List hydFeaturesList = hydFeatures.getFeatureValues();
            featureValues.addAll(hydFeaturesList);
            Features zerFeatures = zer.encodeFeatures(domainName);
            List zerFeaturesList = zerFeatures.getFeatureValues();
            featureValues.addAll(zerFeaturesList);

        }
        else
        {
            if (EXCLUDE_FEATURE!=JOY )
            {
                Features joyFeatures =  joy.encodeFeatures(domainName);
                List joyFeaturesList = joyFeatures.getFeatureValues();
                featureValues.addAll(joyFeaturesList);
            }

            if (EXCLUDE_FEATURE!=SURFV )
            {
                Features surfvFeatures = surfv.encodeFeatures(domainName);
                List surfvFeaturesList = surfvFeatures.getFeatureValues();
                featureValues.addAll(surfvFeaturesList);
            }
            if (EXCLUDE_FEATURE!=ELEC)
            {
                Features elecFeatures = elec.encodeFeatures(domainName);
                List elecFeaturesList = elecFeatures.getFeatureValues();
                featureValues.addAll(elecFeaturesList);
            }
            if (EXCLUDE_FEATURE!=HYD)
            {
                Features hydFeatures = hyd.encodeFeatures(domainName);
                List hydFeaturesList = hydFeatures.getFeatureValues();
                featureValues.addAll(hydFeaturesList);
            }
            if (EXCLUDE_FEATURE!=ZER)
            {
                Features zerFeatures = zer.encodeFeatures(domainName);
                List zerFeaturesList = zerFeatures.getFeatureValues();
                featureValues.addAll(zerFeaturesList);
            }
        }

        Features f = new Features();
        f.addFeatureValues(featureValues);
        return f;
    }
    public static void main(String[] args)
    {
        DataLoader dl = new DataLoader();
        dl.loadMousePDBTrain();
        dl.loadSidhuHumanPDBTrain(Constants.SIDHU_HUMAN_G_PDB, Constants.PHAGE_DISPLAY);
        List posTrainProfileList = dl.getPosTrainProfileList();
        List negTrainProfileList = dl.getNegTrainProfileList();
        String organism= Constants.HUMAN;
        List organismList = new ArrayList();
        organismList.add(Constants.HUMAN);
        organismList.add(Constants.MOUSE);

        List organismList2 = new ArrayList();
        organismList2.add(organism);

        DomainFeatureEncoding dEnc = new DomainFeatureEncoding(organismList, DomainFeatureEncoding.ZER);
        PeptideFeatureEncoding pEnc = new PeptideFeatureEncoding();
        Data trainData = new Data();
        trainData.addRawData(posTrainProfileList,Constants.CLASS_YES);
        trainData.addRawData(negTrainProfileList, Constants.CLASS_NO);
        trainData.encodeBindingSiteStructureData(dEnc, pEnc);

    }

}
