package org.baderlab.pdzsvmstruct.encoding;

import org.baderlab.pdzsvmstruct.data.manager.DataFileManager;
import org.baderlab.pdzsvmstruct.utils.Constants;

import java.util.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class ZernikeFeatureEncoding extends FeatureEncoding
{
    private HashMap domainNameToFileNameMap;
    private String organism= "";
    private String zerDir = "";

    public ZernikeFeatureEncoding(String organism)
    {
        setEncodingName("3DZernike");
        this.organism = organism;
        if (organism.equals(Constants.HUMAN))
            zerDir = DataFileManager.DATA_ROOT_DIR +"/Data/Human/PDZ/Zernike/";
        else if (organism.equals(Constants.MOUSE)||
                organism.equals(Constants.MOUSE_ORPHAN))
            zerDir = DataFileManager.DATA_ROOT_DIR +"/Data/Mouse/PDZ/Zernike/";
        else if (organism.equals(Constants.FLY))
            zerDir = DataFileManager.DATA_ROOT_DIR +"/Data/Fly/PDZ/Zernike/";
        else if (organism.equals(Constants.WORM))
            zerDir = DataFileManager.DATA_ROOT_DIR +"/Data/Worm/PDZ/Zernike/";
        initDomainNameToZerFileNameMap(organism);

    }
    public void initDomainNameToZerFileNameMap(String organism)
    {
        domainNameToFileNameMap = new HashMap();
        if (organism.equals(Constants.HUMAN))
        {
            domainNameToFileNameMap.put("CASK-1", "1KWA.zer");
            domainNameToFileNameMap.put("DLG1-1","SWISSMODEL-DLG1-1.zer");
            domainNameToFileNameMap.put("DLG1-2", "2G2L.zer");
            domainNameToFileNameMap.put("DLG1-3", "SWISSMODEL-DLG1-3.zer");
            domainNameToFileNameMap.put("DLG2-3", "2HE2.zer");
            domainNameToFileNameMap.put("DLG3-2","2FE5.zer");
            domainNameToFileNameMap.put("DLG4-3", "1TP3.zer");
            domainNameToFileNameMap.put("DVL2-1", "2REY.zer");
            domainNameToFileNameMap.put("ERBB2IP-1", "1MFL.zer");
            domainNameToFileNameMap.put("INADL-2", "2DLU.zer");
            domainNameToFileNameMap.put("LRRC7-1", "SWISSMODEL-LRRC7-1.zer");
            domainNameToFileNameMap.put("MAGI1-5", "SWISSMODEL-MAGI1-5.zer");
            domainNameToFileNameMap.put("MAGI3-5", "SWISSMODEL-MAGI3-5.zer");
            domainNameToFileNameMap.put("MPDZ-1", "SWISSMODEL-MPDZ-1.zer");
            domainNameToFileNameMap.put("MPDZ-3", "SWISSMODEL-MPDZ-3.zer");
            domainNameToFileNameMap.put("MPDZ-10", "2OPG.zer");
            domainNameToFileNameMap.put("MPDZ-12", "SWISSMODEL-MPDZ-12.zer");
            domainNameToFileNameMap.put("MPP6-1", "SWISSMODEL-MPP6-1.zer");
            domainNameToFileNameMap.put("PDLIM4-1", "2V1W.zer");
            domainNameToFileNameMap.put("PDZK1-1", "SWISSMODEL-PDZK1-1.zer");
            domainNameToFileNameMap.put("PSCDBP-1", "2Z17.zer");
            domainNameToFileNameMap.put("SCRIB-1", "2W4F.zer");
            domainNameToFileNameMap.put("SCRIB-2", "1WHA.zer");
            domainNameToFileNameMap.put("SLC9A3R2-2", "2HE4.zer");
            domainNameToFileNameMap.put("SNTA1-1", "SWISSMODEL-SNTA1-1.zer");

            domainNameToFileNameMap.put("APBA1-1","SWISSMODEL-APBA1-1.zer");

        }
        else if (organism.equals(Constants.MOUSE)||
               organism.equals(Constants.MOUSE_ORPHAN))
        {

            domainNameToFileNameMap.put("DVL1-1","1MC7.zer");
            domainNameToFileNameMap.put("PTP-BL-2","1VJ6.zer");
            //domainNameToFileNameMap.put("PDZ-RGS3-1","1WHD.zer");
            domainNameToFileNameMap.put("A1-SYNTROPHIN-1","1Z86.zer");
            domainNameToFileNameMap.put("PDZK1-1","2EDZ.zer");
            domainNameToFileNameMap.put("B1-SYNTROPHIN-1","SWISSMODEL-B1-SYNTROPHIN-1.zer");
            domainNameToFileNameMap.put("CHAPSYN-110-2","SWISSMODEL-CHAPSYN-110-2.zer");
            domainNameToFileNameMap.put("CHAPSYN-110-3","SWISSMODEL-CHAPSYN-110-3.zer");
            domainNameToFileNameMap.put("CIPP-10","SWISSMODEL-CIPP-10.zer");
            domainNameToFileNameMap.put("CIPP-3","SWISSMODEL-CIPP-3.zer");
            domainNameToFileNameMap.put("CIPP-5","SWISSMODEL-CIPP-5.zer");
            domainNameToFileNameMap.put("CIPP-8","SWISSMODEL-CIPP-8.zer");
            domainNameToFileNameMap.put("CIPP-9","SWISSMODEL-CIPP-9.zer");
            domainNameToFileNameMap.put("DVL3-1","SWISSMODEL-DVL3-1.zer");
            domainNameToFileNameMap.put("ERBIN-1","SWISSMODEL-ERBIN-1.zer");
            domainNameToFileNameMap.put("GRIP1-6","SWISSMODEL-GRIP1-6.zer");
            domainNameToFileNameMap.put("HARMONIN-2","SWISSMODEL-HARMONIN-2.zer");
            domainNameToFileNameMap.put("LARG-1","SWISSMODEL-LARG-1.zer");
            domainNameToFileNameMap.put("LIN-7C-1","SWISSMODEL-LIN-7C-1.zer");
            ///domainNameToFileNameMap.put("LNX1-2","SWISSMODEL-LNX1-2");
            domainNameToFileNameMap.put("LRRC7-1","SWISSMODEL-LRRC7-1.zer");
            domainNameToFileNameMap.put("MAGI-1-6","SWISSMODEL-MAGI-1-6.zer");
            domainNameToFileNameMap.put("MAGI-2-2","SWISSMODEL-MAGI-2-2.zer");
            domainNameToFileNameMap.put("MAGI-2-5","SWISSMODEL-MAGI-2-5.zer");
            domainNameToFileNameMap.put("MAGI-2-6","SWISSMODEL-MAGI-2-6.zer");
            domainNameToFileNameMap.put("MAGI-3-1","SWISSMODEL-MAGI-3-1.zer");
            domainNameToFileNameMap.put("MAGI-3-2","SWISSMODEL-MAGI-3-2.zer");
            domainNameToFileNameMap.put("MAGI-3-5","SWISSMODEL-MAGI-3-5.zer");
            domainNameToFileNameMap.put("MALS2-1","SWISSMODEL-MALS2-1.zer");
            domainNameToFileNameMap.put("MPP7-1","SWISSMODEL-MPP7-1.zer");
            domainNameToFileNameMap.put("MUPP1-1","SWISSMODEL-MUPP1-1.zer");
            domainNameToFileNameMap.put("MUPP1-10","SWISSMODEL-MUPP1-10.zer");
            domainNameToFileNameMap.put("MUPP1-11","SWISSMODEL-MUPP1-11.zer");
            domainNameToFileNameMap.put("MUPP1-12","SWISSMODEL-MUPP1-12.zer");
            domainNameToFileNameMap.put("MUPP1-13","SWISSMODEL-MUPP1-13.zer");
            domainNameToFileNameMap.put("MUPP1-5","SWISSMODEL-MUPP1-5.zer");
            //domainNameToFileNameMap.put("NHERF-1-1","SWISSMODEL-NHERF-1-1.zer");
            domainNameToFileNameMap.put("NHERF-2-2","SWISSMODEL-NHERF-2-2.zer");
            domainNameToFileNameMap.put("NNOS-1","SWISSMODEL-NNOS-1.zer");
            domainNameToFileNameMap.put("OMP25-1","SWISSMODEL-OMP25-1.zer");
            domainNameToFileNameMap.put("PAR6B-1","SWISSMODEL-PAR6B-1.zer");
            domainNameToFileNameMap.put("PDZK1-3","SWISSMODEL-PDZK1-3.zer");
            domainNameToFileNameMap.put("PDZK11-1","SWISSMODEL-PDZK11-1.zer");
            //domainNameToFileNameMap.put("PSD95-1","SWISSMODEL-PSD95-1.zer");
            domainNameToFileNameMap.put("PSD95-2","SWISSMODEL-PSD95-2.zer");
            domainNameToFileNameMap.put("PSD95-3","SWISSMODEL-PSD95-3.zer");
            domainNameToFileNameMap.put("SAP102-2","SWISSMODEL-SAP102-2.zer");
            domainNameToFileNameMap.put("SAP102-3","SWISSMODEL-SAP102-3.zer");
            domainNameToFileNameMap.put("SAP97-1","SWISSMODEL-SAP97-1.zer");
            domainNameToFileNameMap.put("SAP97-2","SWISSMODEL-SAP97-2.zer");
            domainNameToFileNameMap.put("SAP97-3","SWISSMODEL-SAP97-3.zer");
            domainNameToFileNameMap.put("SCRB1-1","SWISSMODEL-SCRB1-1.zer");
            domainNameToFileNameMap.put("SCRB1-2","SWISSMODEL-SCRB1-2.zer");
            domainNameToFileNameMap.put("SCRB1-3","SWISSMODEL-SCRB1-3.zer");
            domainNameToFileNameMap.put("SEMCAP3-1","SWISSMODEL-SEMCAP3-1.zer");
            domainNameToFileNameMap.put("SHANK1-1","SWISSMODEL-SHANK1-1.zer");
            domainNameToFileNameMap.put("SHANK3-1","SWISSMODEL-SHANK3-1.zer");
            domainNameToFileNameMap.put("SHROOM-1","SWISSMODEL-SHROOM-1.zer");
            domainNameToFileNameMap.put("SLIM-1","SWISSMODEL-SLIM-1.zer");
            //domainNameToFileNameMap.put("TIP-1-1","SWISSMODEL-TIP-1-1");
            domainNameToFileNameMap.put("ZO-1-1","SWISSMODEL-ZO-1-1.zer");
            domainNameToFileNameMap.put("ZO-2-1","SWISSMODEL-ZO-2-1.zer");
            domainNameToFileNameMap.put("ZO-3-1","SWISSMODEL-ZO-3-1.zer");

        //}
        //else if (type.equals(Constants.CHEN_MOUSE_ORPHAN_PDB))
        //{
            //CHEN_MOUSE_ORPHAN_PDB
            /*domainNameToFileNameMap.put("GOPC1-1", "SWISSMODEL-GOPC1-1.zer");
            domainNameToFileNameMap.put("MAGI-2-3", "SWISSMODEL-MAGI2-3.zer");
            domainNameToFileNameMap.put("MAGI-2-4", "SWISSMODEL-MAGI2-4.zer");
            domainNameToFileNameMap.put("MUPP1-2", "SWISSMODEL-MUPP1-2.zer");
            domainNameToFileNameMap.put("NHERF1-2", "SWISSMODEL-NHERF1-2.zer");
            domainNameToFileNameMap.put("PDZK1-4", "SWISSMODEL-PDZK1-4.zer");
            domainNameToFileNameMap.put("SCRB-1-4", "SWISSMODEL-SCRIB-4.zer");
            */
        }
        else if (organism.equals(Constants.FLY))
        {
            // CHEN FLY PDB
            domainNameToFileNameMap.put("DLG-1-1", "SWISSMODEL-DLG1-1.zer");
            domainNameToFileNameMap.put("DSH-1", "SWISSMODEL-DSH-1.zer");
            domainNameToFileNameMap.put("MAGI-4", "SWISSMODEL-MAGI-4.zer");
            domainNameToFileNameMap.put("PATJ-2", "SWISSMODEL-PATJ-2.zer");
            domainNameToFileNameMap.put("PAR6-1", "1RY4.zer");
        }
        else if (organism.equals(Constants.WORM))
        {
            // CHEN WORM PDB
            domainNameToFileNameMap.put("DLG1-1", "SWISSMODEL-DLG1-1.zer");
            domainNameToFileNameMap.put("DLG1-3", "SWISSMODEL-DLG1-3.zer");
            domainNameToFileNameMap.put("DSH-1", "SWISSMODEL-DSH-1.zer");
            domainNameToFileNameMap.put("LIN7-1", "SWISSMODEL-LIN7-1.zer");
            domainNameToFileNameMap.put("STN2-1", "SWISSMODEL-STN2-1.zer");

        }
    }
    public Features encodeFeatures(String domainName)
    {
        featureValues = new ArrayList();
        String filename = (String)domainNameToFileNameMap.get(domainName);
        String zerFileName = zerDir+filename ;
        try
        {
            BufferedReader br = new BufferedReader(new FileReader(new File(zerFileName)));
            String line = "";
            while((line=br.readLine())!=null)
            {
                String[] splitTokens = line.split("\\s+");
                double zernikeValue = Double.parseDouble(splitTokens[1]);
                featureValues.add(zernikeValue);
            }
            br.close();
        }
        catch (Exception e)
        {
            System.out.println("Exception: " + e);
            e.printStackTrace();
        }
        Features f = new Features();
        f.addFeatureValues(featureValues);
        return f;
    }
    public List encodeFeature(String domainName)
    {
        return new ArrayList();
    }
    public static void main(String[] args)
    {
        ZernikeFeatureEncoding zer = new ZernikeFeatureEncoding(Constants.HUMAN);
        //ZernikeFeatureEncoding zer = new ZernikeFeatureEncoding(Constants.MOUSE);
        //ZernikeFeatureEncoding zer = new ZernikeFeatureEncoding(Constants.FLY);
        //ZernikeFeatureEncoding zer = new ZernikeFeatureEncoding(Constants.WORM);

        HashMap map = zer.domainNameToFileNameMap;
        Set keys= map.keySet();
        List keyList = new ArrayList(keys);
        for (int i=0; i < keyList.size();i++)
        {
            String domainName = (String)keyList.get(i);
            Features ft = zer.encodeFeatures(domainName);
            System.out.println(domainName +"\t" + ft.numFeatures());
            System.out.println(ft.getFeatureValues());
        }

    }
}
