/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.entity;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeMap;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtResource
implements Cloneable {
    public static final String RES_ENSEMBL = "Ensembl";
    public static final String RES_ENTREZ = "Entrez";
    public static final String RES_TAIR = "TAIR";
    public static final String RES_UNIPROT = "Uniprot";
    public static final String RES_GO = "GO";
    public static final String LIST_ID = "ExtID";
    public static final String LIST_SYN = "Synonyms";
    public static final String LIST_DEFN = "Defn";
    public static final String LIST_REFSEQ_RNA = "RefSeqRNA";
    public static final String LIST_REFSEQ_PRO = "RefSeqPro";
    public static final String LIST_UNIPROT = "Uniprot";
    public static final String LIST_MGD = "MGD";
    public static final String LIST_GI = "GI";
    public static final String STATUS_CURRENT = "C";
    public static final String STATUS_OLD = "O";
    protected int DBID = -1;
    protected String source;
    protected String speciesName;
    protected String ID;
    protected String name;
    protected String definition;
    protected String status;
    protected ArrayList<String> synList = new ArrayList();
    protected TreeMap<String, TreeMap<String, ExtResource>> xRefMap = new TreeMap();
    protected static ArrayList<String> xResTypesList = new ArrayList();
    protected static PrintWriter log;

    public void setDBID(int DBID) {
        GenUtil.validatePositiveInt(DBID);
        this.DBID = DBID;
    }

    public void setSpeciesName(String speciesName) {
        GenUtil.validateString(speciesName);
        this.speciesName = speciesName;
    }

    public void setID(String extID) {
        GenUtil.validateString(extID);
        this.ID = extID;
    }

    public void setName(String name) {
        GenUtil.validateString(name);
        this.name = name;
    }

    public void resetName() {
        this.name = null;
    }

    public void setDefinition(String definition) {
        GenUtil.validateString(definition);
        this.definition = definition;
    }

    public void setSource(String source) {
        GenUtil.validateString(source);
        this.source = source;
    }

    public void setStatus(String status) {
        GenUtil.validateString(status);
        this.status = status;
    }

    public void addSyn(String syn) {
        GenUtil.validateString(syn);
        if (!this.synList.contains(syn.trim())) {
            this.synList.add(syn);
        }
    }

    public void removeSyn(String syn) {
        GenUtil.validateString(syn);
        if (this.synList.contains(syn)) {
            this.synList.remove(syn);
        } else {
            System.out.println("removeSyn: No such syn: " + syn);
        }
    }

    public void addXRef(String xRefType, ExtResource er) {
        this.validateXRefType(xRefType);
        if (er == null) {
            throw new IllegalArgumentException("Invalid argument: " + er);
        }
        TreeMap<String, ExtResource> tempMap = this.xRefMap.get(xRefType);
        if (tempMap == null) {
            tempMap = new TreeMap();
        }
        tempMap.put(er.getID(), er);
        this.xRefMap.put(xRefType, tempMap);
    }

    public void removeXRef(String xRefType, ExtResource er) {
        this.removeXRef(xRefType, er.getID());
    }

    public void removeXRef(String xRefType, String xRefID) {
        this.validateXRefType(xRefType);
        GenUtil.validateString(xRefID);
        TreeMap<String, ExtResource> tempMap = this.xRefMap.get(xRefType);
        if (tempMap == null) {
            System.err.println("No such Xref: " + xRefType);
            return;
        }
        if (tempMap.containsKey(xRefID)) {
            tempMap.remove(xRefID);
            this.xRefMap.put(xRefType, tempMap);
        } else {
            System.out.println("removeXref: No such ID: " + xRefID);
        }
    }

    public void setXRef(String xRefType, TreeMap<String, ExtResource> tempMap) {
        if (tempMap == null || tempMap.size() == 0) {
            throw new IllegalArgumentException("Invalid argument: " + tempMap);
        }
        if (!xResTypesList.contains(xRefType)) {
            throw new IllegalArgumentException("Unsupported xRef type: " + xRefType);
        }
        this.xRefMap.put(xRefType, tempMap);
    }

    public int getDBID() {
        return this.DBID;
    }

    public String getSpeciesName() {
        return this.speciesName;
    }

    public String getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getSource() {
        return this.source;
    }

    public String getStatus() {
        return this.status;
    }

    public TreeMap<String, ExtResource> getXRef(String xRefType) {
        this.validateXRefType(xRefType);
        TreeMap<String, ExtResource> tempMap = this.xRefMap.get(xRefType);
        return tempMap;
    }

    public ArrayList<String> getSynList() {
        return this.synList;
    }

    private void validateXRefType(String xRefType) {
        GenUtil.validateString(xRefType);
        if (!xResTypesList.contains(xRefType)) {
            throw new IllegalArgumentException("Unsupported xRef type: " + xRefType);
        }
        if (this.source.equals(xRefType)) {
            throw new IllegalArgumentException("Source and xRef identical: " + this.source + " " + xRefType);
        }
    }

    public String toString() {
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = this.name != null ? tempStr + this.name : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = this.definition != null ? tempStr + this.definition : tempStr + "N/A";
        tempStr = tempStr + "\t";
        return tempStr;
    }

    static {
        xResTypesList.add(RES_ENSEMBL);
        xResTypesList.add(RES_ENTREZ);
        xResTypesList.add(RES_TAIR);
        xResTypesList.add("Uniprot");
        xResTypesList.add(RES_GO);
        log = GenUtil.getDefaultLog();
    }
}

