/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.entity;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.genemania.dw.db.ExtResourceGeneTable;
import org.genemania.dw.entity.EntrezGene;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtResourceGene
extends ExtResource {
    public static final String TYPE_PROTEIN_CODING_ENSEMBL = "protein_coding";
    public static final String TYPE_PROTEIN_CODING_ENTREZ = "protein-coding";
    public static final String TYPE_PROTEIN_CODING_TAIR = "protein_coding";
    protected String type;
    protected ArrayList<String> uniprotList = new ArrayList();
    protected ArrayList<String> MGDList = new ArrayList();

    public abstract String toStringLeftOver(String var1);

    public static void saveAll(TreeMap<String, ExtResource> extResMap) {
        if (extResMap == null) {
            throw new IllegalArgumentException("Invalid argument: " + extResMap);
        }
        try {
            ExtResourceGeneTable.saveAll(extResMap);
        }
        catch (SQLException sqlEx) {
            throw new RuntimeException(sqlEx);
        }
    }

    public void setType(String type) {
        GenUtil.validateString(type);
        this.type = type;
    }

    public void addUniprotID(String uniprotID) {
        GenUtil.validateString(uniprotID);
        if (!this.uniprotList.contains(uniprotID)) {
            this.uniprotList.add(uniprotID);
        }
    }

    public void removeUniprotID(String uniprotID) {
        GenUtil.validateString(uniprotID);
        if (this.uniprotList.contains(uniprotID)) {
            this.uniprotList.remove(uniprotID);
        } else {
            System.out.println("removeUniprot: No such ID " + uniprotID);
        }
    }

    public void addMGDID(String MGDID) {
        if (!this.speciesName.equals("Mm")) {
            throw new UnsupportedOperationException("MGD IDs are supported for Mm only.");
        }
        GenUtil.validateString(MGDID);
        if (!this.MGDList.contains(MGDID)) {
            this.MGDList.add(MGDID);
        }
    }

    public void removeMGDID(String MGDID) {
        if (!this.speciesName.equals("Mm")) {
            throw new UnsupportedOperationException("MGD IDs are supported for Mm only.");
        }
        GenUtil.validateString(MGDID);
        if (this.MGDList.contains(MGDID)) {
            this.MGDList.remove(MGDID);
        } else {
            System.out.println("remove MGD: No such ID " + MGDID);
        }
    }

    public String getType() {
        return this.type;
    }

    public ArrayList<String> getUniprotList() {
        return this.uniprotList;
    }

    public ArrayList<String> getMGDList() {
        if (!this.speciesName.equals("Mm")) {
            throw new UnsupportedOperationException("MGD IDs are supported for Mm only.");
        }
        return this.MGDList;
    }

    public ArrayList<String> getRefinedSynList() {
        ArrayList<String> refSynList = new ArrayList<String>();
        ArrayList<String> tempList = this.getRefinedXrefList("Synonyms");
        tempList.addAll(this.getSynList());
        for (int i = 0; i < tempList.size(); ++i) {
            if (refSynList.contains(tempList.get(i))) continue;
            refSynList.add(tempList.get(i));
        }
        return refSynList;
    }

    public ArrayList<String> getRefinedXrefList(String attName) {
        ArrayList<String> refList = new ArrayList<String>();
        for (int i = 0; i < xResTypesList.size(); ++i) {
            TreeMap<String, ExtResource> extMap;
            if (((String)xResTypesList.get(i)).equals(this.getSource()) || (extMap = this.getXRef((String)xResTypesList.get(i))) == null) continue;
            for (String extID : extMap.keySet()) {
                ExtResource er = extMap.get(extID);
                if (er == null) {
                    System.err.println("getRefinedXrefList: xRef not found: " + extID);
                }
                if (attName.equals("ExtID")) {
                    if (refList.contains(er.getID())) continue;
                    refList.add(er.getID());
                    continue;
                }
                if (attName.equals("Defn")) {
                    if (er.getDefinition() == null || refList.contains(er.getDefinition().trim())) continue;
                    refList.add(er.getDefinition().trim());
                    continue;
                }
                ArrayList<String> tempList = null;
                if (attName.equals("Uniprot")) {
                    tempList = ((ExtResourceGene)er).getUniprotList();
                } else if (attName.equals("MGD")) {
                    tempList = ((ExtResourceGene)er).getMGDList();
                } else if (attName.equals("RefSeqRNA")) {
                    tempList = ((EntrezGene)er).getRefSeqRNAList();
                } else if (attName.equals("RefSeqPro")) {
                    tempList = ((EntrezGene)er).getRefSeqProList();
                } else if (attName.equals("Synonyms")) {
                    tempList = er.getSynList();
                    if (er.getName() != null) {
                        tempList.add(er.getName());
                    }
                }
                for (int j = 0; j < tempList.size(); ++j) {
                    if (refList.contains(tempList.get(j))) continue;
                    refList.add(tempList.get(j));
                }
            }
        }
        return refList;
    }

    @Override
    public String toString() {
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = TYPE_PROTEIN_CODING_ENTREZ.equals(this.getType()) ? tempStr + "True" : tempStr + "False";
        tempStr = tempStr + "\t";
        tempStr = this.name != null ? tempStr + this.name : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getUniprotList());
        tempStr = tempStr + "\t";
        if ("Mm".equals(this.speciesName)) {
            tempStr = GenUtil.addList(tempStr, this.getMGDList());
            tempStr = tempStr + "\t";
        }
        tempStr = GenUtil.addList(tempStr, this.getSynList());
        tempStr = tempStr + "\t";
        tempStr = this.definition != null ? tempStr + this.definition : tempStr + "N/A";
        tempStr = tempStr + "\t";
        return tempStr;
    }
}

