/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.entity;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.genemania.dw.db.TAIRMirrorTables;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.ExtResourceGene;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAIRGene
extends ExtResourceGene {
    private String annotation;
    private String description;

    public static TreeMap<String, ExtResource> loadAllExt() throws SQLException {
        TreeMap<String, ExtResource> tairMap = TAIRMirrorTables.loadAll();
        return tairMap;
    }

    public TAIRGene() {
        this.setSource("TAIR");
        this.setSpeciesName("At");
    }

    @Override
    public void addUniprotID(String uniprotID) {
        throw new UnsupportedOperationException("No implementation for  Uniprot for TAIR genes.");
    }

    @Override
    public void addMGDID(String MGDID) {
        throw new UnsupportedOperationException("No implementation for  MGD IDs for TAIR genes.");
    }

    public void setAnnotation(String annotation) {
        GenUtil.validateString(annotation);
        this.annotation = annotation;
    }

    public void setDescription(String description) {
        GenUtil.validateString(description);
        this.description = description;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public ArrayList<String> getUniprotList() {
        throw new UnsupportedOperationException("No implementation for  Uniprot for TAIR genes.");
    }

    @Override
    public ArrayList<String> getMGDList() {
        throw new UnsupportedOperationException("No implementation for  MGD IDs for TAIR genes.");
    }

    @Override
    public String toString() {
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = "protein_coding".equals(this.getType()) ? tempStr + "True" : tempStr + "False";
        tempStr = tempStr + "\t";
        tempStr = this.getName() != null ? tempStr + this.getName() : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("Uniprot"));
        tempStr = tempStr + "\t";
        TreeMap<String, ExtResource> xRefEntMap = this.getXRef("Entrez");
        if (xRefEntMap == null || xRefEntMap.size() == 0) {
            tempStr = tempStr + "N/A";
        } else {
            Iterator<String> iterator = xRefEntMap.keySet().iterator();
            boolean firstTime = true;
            while (iterator.hasNext()) {
                String entGeneID = iterator.next();
                tempStr = tempStr + entGeneID;
                if (firstTime) {
                    firstTime = false;
                    continue;
                }
                tempStr = tempStr + ";";
            }
        }
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("RefSeqRNA"));
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("RefSeqPro"));
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedSynList());
        tempStr = tempStr + "\t";
        tempStr = this.getDefinition() != null ? tempStr + this.getDefinition() : (this.getAnnotation() != null ? tempStr + this.getAnnotation() : (this.getDescription() != null ? tempStr + this.getDescription() : tempStr + "N/A"));
        return tempStr;
    }

    @Override
    public String toStringLeftOver(String xRefType) {
        if (!"Entrez".equals(xRefType)) {
            throw new IllegalArgumentException("No leftOvers support for " + xRefType);
        }
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = "protein_coding".equals(this.getType()) ? tempStr + "True" : tempStr + "False";
        tempStr = tempStr + "\t";
        tempStr = this.getName() != null ? tempStr + this.getName() : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("Uniprot"));
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("RefSeqRNA"));
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("RefSeqPro"));
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedSynList());
        tempStr = tempStr + "\t";
        tempStr = this.getDefinition() != null ? tempStr + this.getDefinition() : (this.getAnnotation() != null ? tempStr + this.getAnnotation() : (this.getDescription() != null ? tempStr + this.getDescription() : tempStr + "N/A"));
        return tempStr;
    }
}

