/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.util;

import java.sql.SQLException;
import java.util.ArrayList;
import org.genemania.dw.db.EntrezMirrorTables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DWUtil {
    public static final String SP_CRESS = "At";
    public static final String SP_HUMAN = "Hs";
    public static final String SP_MOUSE = "Mm";
    public static final String SP_RAT = "Rn";
    public static final String SP_WORM = "Ce";
    public static final String SP_YEAST = "Sc";
    public static final String SP_FLY = "Dm";
    public static final String SP_ECOLI = "Ec";
    public static final int TAXID_HS = 9606;
    public static final int TAXID_MM = 10090;
    public static final int TAXID_RN = 10116;
    public static final int TAXID_CE = 6239;
    public static final int TAXID_AT = 3702;
    public static final int TAXID_SC = 4932;
    public static final int TAXID_DM = 7227;
    public static final int TAXID_EC = 562;
    public static final String SP_NAME_COMMON = "genbank common name";
    public static final String SP_NAME_SCIENTIFIC = "scientific name";
    private static ArrayList<String> speciesNamesList = new ArrayList();

    private DWUtil() {
    }

    public static boolean isSupportedSpecies(String speciesName) {
        return speciesNamesList.contains(speciesName);
    }

    public static ArrayList<String> getSpeciesAbbNames() {
        return speciesNamesList;
    }

    public static int getTaxIDByName(String speciesName) {
        if (!DWUtil.isSupportedSpecies(speciesName)) {
            throw new IllegalArgumentException("Species not supported: " + speciesName);
        }
        if (SP_CRESS.equals(speciesName)) {
            return 3702;
        }
        if (SP_ECOLI.equals(speciesName)) {
            return 562;
        }
        if (SP_FLY.equals(speciesName)) {
            return 7227;
        }
        if (SP_HUMAN.equals(speciesName)) {
            return 9606;
        }
        if (SP_MOUSE.equals(speciesName)) {
            return 10090;
        }
        if (SP_RAT.equals(speciesName)) {
            return 10116;
        }
        if (SP_WORM.equals(speciesName)) {
            return 6239;
        }
        return 4932;
    }

    public static ArrayList<String> getSpeciesScientificName(int taxID) throws SQLException {
        ArrayList<String> tempList = EntrezMirrorTables.getSpeciesScientificName(taxID);
        if (tempList.size() > 1) {
            System.err.println("Warning: More than one scientific name listed: " + taxID);
        }
        return tempList;
    }

    public static ArrayList<String> getSpeciesCommonName(int taxID) throws SQLException {
        return EntrezMirrorTables.getSpeciesCommonName(taxID);
    }

    public static String dumpSpeciesNames(int taxID) throws SQLException {
        String scNameStr = "N/A";
        String cmNameStr = "";
        ArrayList<String> scNameList = DWUtil.getSpeciesScientificName(taxID);
        ArrayList<String> cmNameList = DWUtil.getSpeciesCommonName(taxID);
        if (scNameList.size() > 0) {
            scNameStr = scNameList.get(0);
        }
        for (int j = 0; j < cmNameList.size(); ++j) {
            cmNameStr = cmNameStr + cmNameList.get(j);
            if (j >= cmNameList.size() - 1) continue;
            cmNameStr = cmNameStr + ";";
        }
        if (cmNameStr.length() == 0) {
            cmNameStr = "N/A";
        }
        return taxID + "\t" + scNameStr + "\t" + cmNameStr;
    }

    static {
        speciesNamesList.add(SP_CRESS);
        speciesNamesList.add(SP_HUMAN);
        speciesNamesList.add(SP_MOUSE);
        speciesNamesList.add(SP_RAT);
        speciesNamesList.add(SP_WORM);
        speciesNamesList.add(SP_YEAST);
        speciesNamesList.add(SP_FLY);
        speciesNamesList.add(SP_ECOLI);
    }
}

