package org.genemania.dw.tools;

import java.util.ArrayList;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.ExtResourceGene;
import org.genemania.dw.util.GenUtil;

/**
 * Handles the details of the 'IV Detailed' report. An instance of this class
 * partially represents a single entry in that file.
 * refGeneID represents the geneID from the leftover source for leftovers.
 * This class offers a package level access for the class itself, and
 * all its methods.
 *
 * @author rashadbadrawi
 */

class IVReportDetail {

    private String refGeneID;
    private String IDValue;    //IDValue (for shared) or oldGeneID (for deprecated)
    private String IDType;     //IDType (for shared) or NewGeneID (for deprecated)

    protected IVReportDetail () {

       setIDType(GenUtil.NA);
    }

    protected void setSharedDetails (String attValue, ArrayList <ExtResource> sharedList) {

        setSharedList (sharedList);
        //setIDValue(attValue + "(count:" + sharedList.size () + ")");
        setIDValue(attValue);
    }

    protected void setLeftOverDetails (ExtResource leftOverGene) {

        GenUtil.validateNotNull (leftOverGene);
        setRefGeneID (leftOverGene.getID());
    }

    protected void setDepDetails (ExtResource referringGene,
            ExtResource oldGene, ArrayList <ExtResource> newGeneList) {

       setRefGeneID (referringGene.getID());
       setIDValue (oldGene.getID());
       String tempStr = "";
       for (int i = 0; i < newGeneList.size (); i++) {
           if (i > 0) {
               tempStr += GenUtil.SEMICOLON;
           }
           tempStr += newGeneList.get (i).getID();
       }
       if (tempStr.length () == 0) {
           tempStr = GenUtil.NA;
       }
       setIDType (tempStr);
    }

    protected void setSharedList (ArrayList <ExtResource> sharedList) {

       if (sharedList == null || sharedList.size () <= 1) {
           throw new IllegalArgumentException ("Invalid argument: " + sharedList);
       }
       String tempStr = "";
       for (int i = 0; i < sharedList.size (); i++) {
           if (i > 0) {
               tempStr += GenUtil.SEMICOLON;
           }
           tempStr += sharedList.get (i).getID();
       }
       setRefGeneID (tempStr);
    }

    protected void setRefGeneID (String refGeneID) {

        GenUtil.validateString(refGeneID);
        this.refGeneID = refGeneID;
    }

    private void setIDValue (String geneORIdentifierID) {

        GenUtil.validateString(geneORIdentifierID);
        this.IDValue = geneORIdentifierID;
    }

    protected void setIDType (String IDType) {

        GenUtil.validateString(IDType);
        this.IDType = IDType;
    }

    protected String getRefGeneID () { return refGeneID; }

    protected String getIDValue () { return IDValue; }

    protected String getIDType () { return IDType; }

    protected String toStringShared () {

        String tempStr = "";

        tempStr += getIDType();
        tempStr += GenUtil.TAB;

        tempStr += getIDValue();
        tempStr += GenUtil.TAB;

        tempStr += getRefGeneID ();

        return tempStr;
    }

    protected String toStringLO () {

        String tempStr = "";

        tempStr += getRefGeneID ();

        return tempStr;
    }

    protected String toStringDep () {

        String tempStr = "";

        tempStr += getRefGeneID ();
        tempStr += GenUtil.TAB;

        tempStr += getIDValue();
        tempStr += GenUtil.TAB;

        tempStr += getIDType();

        return tempStr;
    }
}
