package org.genemania.dw.tools;

import java.util.TreeMap;

import org.genemania.dw.entity.OBOTerm;
import org.genemania.dw.util.GenUtil;

/**
 * Utility class. Container for OBO terms.
 *
 * @author rashadbadrawi
 */

public class OBOContainer {

    private static TreeMap <String, OBOTerm> termsMap = new
                                             TreeMap <String, OBOTerm> ();

    public static void add (OBOTerm term) {

        if (term == null) {
            throw new IllegalArgumentException ("Invalid input: " + term);
        }
        //overwrites existing, if any
        termsMap.put (term.getID(), term);
    }

    public static TreeMap <String, OBOTerm> getAll () {

        return termsMap;
    }

    public static OBOTerm getByID (String ID) {

        GenUtil.validateString (ID);
        return termsMap.get (ID);
    }
}

