package org.genemania.dw.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

/**
 * Connects to all the default names for files and command line args for the
 * different classes.
 * Supports both GeneMania and PathwayCommons classes.
 *
 * @author rashadbadrawi
 */

public class DefParams {

    //DW props
    //DB access
    public static final String DB_SERVER_PROP = "DefDBServer";
    public static final String DB_USER_PROP = "DefDBUser";
    public static final String DB_PASSWD_PROP = "DefDBPasswd";
    //current schema names
    public static final String ENSEMBL_HUMAN_SCHEMA_NAME = DWUtil.SP_HUMAN;
    public static final String ENSEMBL_MOUSE_SCHEMA_NAME = DWUtil.SP_MOUSE;
    public static final String ENSEMBL_RAT_SCHEMA_NAME = DWUtil.SP_RAT;
    public static final String ENSEMBL_YEAST_SCHEMA_NAME = DWUtil.SP_YEAST;
    public static final String ENSEMBL_WORM_SCHEMA_NAME = DWUtil.SP_WORM;
    public static final String ENSEMBL_FLY_SCHEMA_NAME = DWUtil.SP_FLY;
    public static final String ENTREZ_MIRROR = "EntrezMirror";
    public static final String TAIR_MIRROR = "TAIRMirror";
    public static final String UNIPROT_MIRROR = "UniprotMirror";
    //tools
    public static final String TOOLS_PATH_PROP = "DefToolsPath";
    public static final String IV_FIX_PROP = "DefIVFix";
    public static final String IV_SUM_FILE_PROP = "DefIVReportSummary";
    public static final String IV_DET_FILE_PROP = "DefIVReportDetail";
    //general
    public static final String LOG_FILE_PROP = "DefLogFile";
    public static final String PROP_FILE_NAME_PROP = "DW_PC_Props";

    //PC props
    public static final String FROM_SCHEMA_PATH_PROP = "DefFromSchemaPath";
    public static final String TO_SCHEMA_PATH_PROP = "DefToSchemaPath";
    public static final String XMLSTATS_FILE_PROP = "DefXMLStatsFile";
    //BIND Trans specific
    public static final String SUPP_FILE1_NAME_PROP = "SuppFile1";
    public static final String OBO_FILE_PROP = "DefOBOFile";
    public static final String BIND_PSIMI_CV_FILE_PROP = "DefBINDPSIMICVFile";
    public static final String BIND_TRANS_COM_PROP = "DefBINDTransComplexes";
    public static final String BIND_MAP_ID_PROP = "DefBINDMapIDs";
    public static final String BIND_TRANS_PRO_PROP = "DefBINDTransProOnly";
    public static final String BIND_CLEAN_DATA_PROP = "DefBINDCleanData";

    private static ArrayList <String> defParamsList;
    private static final String PROP_FILE_PATH_DW = "./DW_PC.properties";

    //a command line argument that is set to the default value by the 
    //respective program
    private static Properties props;
    
    static {
        try {
            props = new Properties ();
            String propsFileName = System.getProperty (DefParams.PROP_FILE_NAME_PROP);
            if (propsFileName == null) {
                propsFileName = DefParams.PROP_FILE_PATH_DW;
            }
            props.load (new FileInputStream (propsFileName));
        } catch (IOException e) {
            e.printStackTrace ();
        }
        defParamsList = new ArrayList <String> ();
        defParamsList.add (DefParams.LOG_FILE_PROP);
        defParamsList.add (DefParams.DB_SERVER_PROP);
        defParamsList.add (DefParams.DB_USER_PROP);
        defParamsList.add (DefParams.DB_PASSWD_PROP);
        defParamsList.add (DefParams.ENSEMBL_HUMAN_SCHEMA_NAME);
        defParamsList.add (DefParams.ENSEMBL_MOUSE_SCHEMA_NAME);
        defParamsList.add (DefParams.ENSEMBL_RAT_SCHEMA_NAME);
        defParamsList.add (DefParams.ENSEMBL_YEAST_SCHEMA_NAME);
        defParamsList.add (DefParams.ENSEMBL_WORM_SCHEMA_NAME);
        defParamsList.add (DefParams.ENSEMBL_FLY_SCHEMA_NAME);
        defParamsList.add (DefParams.ENTREZ_MIRROR);
        defParamsList.add (DefParams.TAIR_MIRROR);
        defParamsList.add (DefParams.UNIPROT_MIRROR);
        defParamsList.add (DefParams.TOOLS_PATH_PROP);
        defParamsList.add (DefParams.IV_FIX_PROP);
        defParamsList.add (DefParams.IV_SUM_FILE_PROP);
        defParamsList.add (DefParams.IV_DET_FILE_PROP);

        defParamsList.add (DefParams.XMLSTATS_FILE_PROP);
        defParamsList.add (DefParams.FROM_SCHEMA_PATH_PROP);
        defParamsList.add (DefParams.TO_SCHEMA_PATH_PROP);
        defParamsList.add (DefParams.SUPP_FILE1_NAME_PROP);
        defParamsList.add (DefParams.BIND_PSIMI_CV_FILE_PROP);
        defParamsList.add (DefParams.OBO_FILE_PROP);
        defParamsList.add (BIND_TRANS_COM_PROP);
        defParamsList.add (BIND_MAP_ID_PROP);
        defParamsList.add (BIND_TRANS_PRO_PROP);
        defParamsList.add (BIND_CLEAN_DATA_PROP);
    }

    private DefParams () {}                         //no instances allowed
    
    public static String [] getCommandLineArgs (String className) {
        
        if (className == null || className.length () == 0) {
            throw new IllegalArgumentException ("Invalid argument: " +
                className);
        }
        String [] tempArr = className.split ("\\" + GenUtil.DOT);
        className = tempArr [tempArr.length - 1];
        String argNumStr = props.getProperty (className);
        if (argNumStr == null) {
            throw new RuntimeException ("No args found for class: " +
                className);
        }
        int argNum = Integer.parseInt (argNumStr);
        String [] args = new String [argNum];
        for (int i = 0; i < argNum; i++) {
            args [i] = props.getProperty (className + GenUtil.UNDERSCORE + i).trim();
            System.out.println ("args[" + i + "]: " + args[i]);
        }
        
        return args;
    }
        
    public static String getDefaultProp (String propName) {

        if (!defParamsList.contains (propName)) {
            throw new IllegalArgumentException ("Invalid property name: " + 
                propName);
        }
        String propVal = props.getProperty (propName);
        
        return propVal == null ? null : propVal.trim ();
    }
}
