/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.ITunesRatingTableCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class RatingStarEditorPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int lastX = Integer.MIN_VALUE;
    private int lastY = Integer.MIN_VALUE;
    private int xoffset = 5;
    private int yoffset = 2;

    public RatingStarEditorPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.processCoordinates(e);
        this.repaint();
    }

    private void recordCoordinates(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    private boolean validateCoordinates(MouseEvent e) {
        Point location = this.getLocation();
        Dimension size = this.getSize();
        if ((double)e.getX() < location.getX() || (double)e.getX() > location.getX() + size.getWidth()) {
            return false;
        }
        return !((double)e.getY() < location.getY()) && !((double)e.getY() > location.getY() + size.getHeight());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processCoordinates(e);
        this.repaint();
    }

    private void processCoordinates(MouseEvent e) {
        if (e != null && this.validateCoordinates(e)) {
            this.recordCoordinates(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processCoordinates(e);
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public int getLevel() {
        if (this.lastX == Integer.MIN_VALUE || this.lastY == Integer.MIN_VALUE) {
            return 0;
        }
        int min = (int)this.getLocation().getX();
        int max = min + (int)this.getSize().getWidth();
        return (int)Math.ceil((double)(this.lastX - min) / (double)(max - min) * 5.0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Image star = new ImageIcon(ITunesRatingTableCellRenderer.class.getResource("/com/explodingpixels/macwidgets/images/itunes_star_unselected.png")).getImage();
        int level = this.getLevel();
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < level; ++i) {
            g2.drawImage(star, i * star.getWidth(null) + this.xoffset, this.yoffset, null, null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processCoordinates(e);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

