/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.border.FocusStateMatteBorder;
import com.explodingpixels.macwidgets.MacColorUtils;
import com.explodingpixels.macwidgets.MacPainterFactory;
import com.explodingpixels.macwidgets.MacUtils;
import com.explodingpixels.macwidgets.TriAreaComponent;
import com.explodingpixels.widgets.WindowDragger;
import com.explodingpixels.widgets.WindowUtils;
import com.jgoodies.forms.factories.Borders;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class UnifiedToolBar {
    private final TriAreaComponent fUnifiedToolBar;

    public UnifiedToolBar() {
        this(true);
    }

    public UnifiedToolBar(boolean forceSameWidth) {
        this.fUnifiedToolBar = new TriAreaComponent(4, forceSameWidth);
        UnifiedToolBar.fixUnifiedToolBarOnMacIfNeccessary(this.fUnifiedToolBar);
        this.fUnifiedToolBar.getComponent().setBorder(Borders.createEmptyBorder((String)"3dlu, 4dlu, 3dlu, 4dlu"));
        UnifiedToolBar.installUnifiedToolBarBorder(this.fUnifiedToolBar.getComponent());
        WindowUtils.installJComponentRepainterOnWindowFocusChanged(this.fUnifiedToolBar.getComponent());
    }

    public void addComponentToLeft(JComponent toolToAdd) {
        this.fUnifiedToolBar.addComponentToLeft(toolToAdd);
    }

    public void addComponentToCenter(JComponent toolToAdd) {
        this.fUnifiedToolBar.addComponentToCenter(toolToAdd);
    }

    public void addComponentToRight(JComponent toolToAdd) {
        this.fUnifiedToolBar.addComponentToRight(toolToAdd);
    }

    public void installWindowDraggerOnWindow(Window window) {
        new WindowDragger(window, this.getComponent());
    }

    public JComponent getComponent() {
        return this.fUnifiedToolBar.getComponent();
    }

    public void disableBackgroundPainter() {
        this.fUnifiedToolBar.setBackgroundPainter(null);
    }

    private static void fixUnifiedToolBarOnMacIfNeccessary(TriAreaComponent unifiedToolBar) {
        if (MacUtils.shouldManuallyPaintTexturedWindowBackground()) {
            unifiedToolBar.setBackgroundPainter(MacPainterFactory.createTexturedWindowWorkaroundPainter());
        }
    }

    static void installUnifiedToolBarBorder(JComponent component) {
        FocusStateMatteBorder border = new FocusStateMatteBorder(0, 0, 1, 0, MacColorUtils.getTexturedWindowToolbarBorderFocusedColor(), MacColorUtils.getTexturedWindowToolbarBorderUnfocusedColor(), component);
        component.setBorder(BorderFactory.createCompoundBorder(border, component.getBorder()));
    }
}

