/*
 * Decompiled with CFR 0.152.
 */
package ch.enterag.utils.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DiskFile
extends RandomAccessFile {
    private static final String sMODE_READ = "r";
    private static final String sMODE_READ_WRITE = "rw";
    private static final int iBUFFER_SIZE = 4096;
    private String m_sFileName = null;
    private boolean m_bReadOnly = false;

    public String getFileName() {
        return this.m_sFileName;
    }

    public boolean isReadOnly() {
        return this.m_bReadOnly;
    }

    public DiskFile(String sFileName, boolean bReadOnly) throws FileNotFoundException {
        super(sFileName, bReadOnly ? sMODE_READ : sMODE_READ_WRITE);
        File file = new File(sFileName);
        this.m_sFileName = file.getAbsolutePath();
        this.m_bReadOnly = bReadOnly;
    }

    public DiskFile(File file, boolean bReadOnly) throws FileNotFoundException {
        super(file, bReadOnly ? sMODE_READ : sMODE_READ_WRITE);
        this.m_sFileName = file.getAbsolutePath();
        this.m_bReadOnly = bReadOnly;
    }

    public DiskFile(String sFileName) throws FileNotFoundException {
        super(sFileName, sMODE_READ_WRITE);
        File file = new File(sFileName);
        this.m_sFileName = file.getAbsolutePath();
    }

    public DiskFile(File file) throws FileNotFoundException {
        super(file, sMODE_READ_WRITE);
        this.m_sFileName = file.getAbsolutePath();
    }

    public byte[] digest(String sAlgorithm, long lStart, long lEnd) throws IOException {
        if (!sAlgorithm.equals("MD5") && !sAlgorithm.equals("SHA-1")) {
            throw new IllegalArgumentException("Digest algorithm must be MD5 or SHA-1!");
        }
        long lFilePointer = this.getFilePointer();
        byte[] bufDigest = null;
        try {
            MessageDigest md = MessageDigest.getInstance(sAlgorithm);
            byte[] buf = new byte[4096];
            int iRead = 0;
            long lPosition = lStart;
            while (lPosition < lEnd) {
                this.seek(lPosition);
                int iLength = buf.length;
                if (lEnd - lPosition < (long)iLength) {
                    iLength = (int)(lEnd - lPosition);
                }
                if ((iRead = this.read(buf, 0, iLength)) != iLength) {
                    throw new IOException("Could not read " + String.valueOf(iLength) + " bytes at position " + String.valueOf(lPosition));
                }
                md.update(buf, 0, iRead);
                lPosition += (long)iRead;
            }
            bufDigest = md.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            System.err.println(String.valueOf(nsae.getClass().getName()) + ": " + nsae.getMessage());
        }
        this.seek(lFilePointer);
        return bufDigest;
    }

    public long move(long lSource, long lDestination) throws IOException {
        long lMoved = 0L;
        byte[] buf = new byte[4096];
        if (lSource < lDestination) {
            this.setLength(this.length() + (lDestination - lSource));
            int iLength = buf.length;
            long lPos = this.length() - (long)iLength;
            if (lPos < lSource) {
                iLength -= (int)(lSource - lPos);
                lPos = lSource;
            }
            this.seek(lPos);
            while (iLength > 0) {
                this.seek(lPos);
                lMoved += (long)iLength;
                this.readFully(buf, 0, iLength);
                this.seek(lPos + lDestination - lSource);
                this.write(buf, 0, iLength);
                if ((lPos -= (long)iLength) >= lSource) continue;
                iLength -= (int)(lSource - lPos);
                lPos = lSource;
            }
        } else if (lDestination < lSource) {
            long lPos = lSource;
            int iLength = buf.length;
            long lLength = this.length();
            if (lPos + (long)iLength > lLength) {
                iLength = (int)(lLength - lPos);
            }
            while (iLength > 0) {
                this.seek(lPos);
                lMoved += (long)iLength;
                this.readFully(buf, 0, iLength);
                this.seek(lPos - lSource + lDestination);
                this.write(buf, 0, iLength);
                if ((lPos += (long)iLength) + (long)iLength <= lLength) continue;
                iLength = (int)(lLength - lPos);
            }
            this.seek(lLength - lSource + lDestination);
        }
        this.setLength(this.getFilePointer());
        return lMoved;
    }

    public long lastIndexOf(byte[] bufPattern) throws IOException {
        long lLastIndex = -1L;
        int iBufferSize = 2 * bufPattern.length;
        if (iBufferSize < 4096) {
            iBufferSize = 4096;
        }
        byte[] buf = new byte[iBufferSize];
        long lFilePointer = this.getFilePointer();
        if (lFilePointer >= (long)bufPattern.length) {
            long lPos = lFilePointer;
            int iStart = 0;
            int iEnd = 0;
            int iReadSize = iBufferSize / 2;
            if (lPos < (long)iReadSize) {
                iStart = iReadSize - (int)lPos;
                iReadSize = (int)lPos;
            }
            this.seek(lPos -= (long)iReadSize);
            this.readFully(buf, iStart, iReadSize);
            while (lLastIndex < 0L && iReadSize > 0) {
                System.arraycopy(buf, iStart, buf, iBufferSize / 2, iReadSize);
                iEnd = iBufferSize / 2 + iReadSize;
                if (lPos < (long)iReadSize) {
                    iStart = iBufferSize / 2 - (int)lPos;
                    iReadSize = (int)lPos;
                }
                this.seek(lPos -= (long)iReadSize);
                this.readFully(buf, iStart, iReadSize);
                int iPos = iEnd - bufPattern.length;
                while (iPos >= iStart && lLastIndex < 0L) {
                    boolean bMatch = true;
                    int i = 0;
                    while (bMatch && i < bufPattern.length) {
                        bMatch = buf[iPos + i] == bufPattern[i];
                        ++i;
                    }
                    if (bMatch) {
                        lLastIndex = lPos + (long)iPos - (long)iStart;
                    }
                    --iPos;
                }
            }
            this.seek(lFilePointer);
        }
        return lLastIndex;
    }
}

