/*
 * Decompiled with CFR 0.152.
 */
package ch.enterag.utils.zip;

import ch.enterag.utils.zip.FileEntry;
import ch.enterag.utils.zip.Zip64File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class EntryInputStream
extends InputStream {
    private static final int iBUFFER_SIZE = 4096;
    private Zip64File m_zf = null;
    private FileEntry m_feLocal = null;
    private final Inflater m_inf = new Inflater(true);
    private final CRC32 m_crc = new CRC32();
    private long m_lRemainingSize = 0L;
    private long m_lRemainingCompressedSize = 0L;
    private long m_lCompressedSize = 0L;
    private long m_lSize = 0L;
    private long m_lFilePointer = 0L;

    FileEntry getFileEntryLocal() {
        return this.m_feLocal;
    }

    long getFilePointer() {
        return this.m_lFilePointer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    EntryInputStream(Zip64File zf, String sEntryName) throws ZipException, IOException, FileNotFoundException {
        this.m_zf = zf;
        FileEntry fe = this.m_zf.getFileEntry(sEntryName);
        if (fe == null) throw new FileNotFoundException("File entry " + sEntryName + " not in ZIP file!");
        long lFilePointer = this.m_zf.getDiskFile().getFilePointer();
        try {
            this.m_feLocal = this.m_zf.getLocalFileEntry(fe);
            this.m_lFilePointer = this.m_zf.getDiskFile().getFilePointer();
            this.m_inf.reset();
            this.m_crc.reset();
            this.m_lRemainingSize = fe.getSize();
            this.m_lRemainingCompressedSize = fe.getCompressedSize();
            this.m_lCompressedSize = 0L;
            this.m_lSize = 0L;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_zf.getDiskFile().seek(lFilePointer);
            throw throwable;
        }
        {
            Object var6_7 = null;
            this.m_zf.getDiskFile().seek(lFilePointer);
            return;
        }
    }

    public int available() throws IOException {
        int iAvailable = Integer.MAX_VALUE;
        if (this.m_lRemainingSize <= (long)iAvailable) {
            iAvailable = (int)this.m_lRemainingSize;
        }
        return iAvailable;
    }

    private int readDeflated(byte[] buf, int iOffset, int iLength) throws IOException, DataFormatException {
        int iRead = -1;
        if ((long)iLength > this.m_lRemainingSize) {
            iLength = (int)this.m_lRemainingSize;
        }
        if ((iRead = this.m_inf.inflate(buf, iOffset, iLength)) <= 0 && this.m_inf.needsInput()) {
            int iCompressedSize = 4096;
            if ((long)iCompressedSize > this.m_lRemainingCompressedSize) {
                iCompressedSize = (int)this.m_lRemainingCompressedSize;
            }
            if (iCompressedSize > 0) {
                byte[] bufCompressed = new byte[iCompressedSize];
                int iReadCompressed = this.m_zf.getDiskFile().read(bufCompressed);
                if (iReadCompressed >= 0) {
                    this.m_lRemainingCompressedSize -= (long)iReadCompressed;
                    this.m_lCompressedSize += (long)iReadCompressed;
                } else {
                    throw new ZipException("Unexpected end of file!");
                }
                this.m_inf.setInput(bufCompressed, 0, iCompressedSize);
                iRead = this.m_inf.inflate(buf, iOffset, iLength);
            } else if (this.m_inf.getRemaining() == 0) {
                iRead = -1;
            } else {
                throw new ZipException("All bytes produced before all were consumed!");
            }
        }
        return iRead;
    }

    private int readStored(byte[] buf, int iOffset, int iLength) throws IOException {
        int iRead = -1;
        if ((long)iLength > this.m_lRemainingSize) {
            iLength = (int)this.m_lRemainingSize;
        }
        if (iLength > 0 && (iRead = this.m_zf.getDiskFile().read(buf, iOffset, iLength)) >= 0) {
            this.m_lRemainingCompressedSize -= (long)iRead;
            this.m_lCompressedSize += (long)iRead;
        }
        return iRead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] buf, int iOffset, int iLength) throws IOException {
        int iRead = 0;
        long lFilePointer = this.m_zf.getDiskFile().getFilePointer();
        try {
            block12: {
                try {
                    if (iOffset < 0) throw new IndexOutOfBoundsException();
                    if (iLength < 0) throw new IndexOutOfBoundsException();
                    if (iOffset > buf.length - iLength) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (iLength != 0) {
                        iRead = -1;
                        if (this.m_lSize + this.m_lRemainingSize <= 0L) break block12;
                        if (this.m_feLocal == null) throw new ZipException("File not open for reading!");
                        this.m_zf.getDiskFile().seek(this.m_lFilePointer);
                        switch (this.m_feLocal.getMethod()) {
                            case 8: {
                                iRead = this.readDeflated(buf, iOffset, iLength);
                                break;
                            }
                            case 0: {
                                iRead = this.readStored(buf, iOffset, iLength);
                                break;
                            }
                        }
                        this.m_lFilePointer = this.m_zf.getDiskFile().getFilePointer();
                        if (iRead >= 0) {
                            this.m_lRemainingSize -= (long)iRead;
                            this.m_lSize += (long)iRead;
                            this.m_crc.update(buf, iOffset, iRead);
                        }
                        break block12;
                    }
                    iRead = 0;
                }
                catch (DataFormatException dfe) {
                    throw new IOException(String.valueOf(dfe.getClass().getName()) + ": " + dfe.getMessage());
                }
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.m_zf.getDiskFile().seek(lFilePointer);
            throw throwable;
        }
        this.m_zf.getDiskFile().seek(lFilePointer);
        return iRead;
    }

    public int read(byte[] b) throws IOException {
        int iRead = this.read(b, 0, b.length);
        return iRead;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int iRead = this.read(buf);
        if (iRead == 1) {
            iRead = buf[0] >= 0 ? buf[0] : 256 + buf[0];
        }
        return iRead;
    }

    public long skip(long n) throws IOException {
        long lSkipped = 0L;
        byte[] buf = new byte[4096];
        int iRead = this.read(buf);
        while (iRead >= 0 && lSkipped < n) {
            lSkipped += (long)iRead;
            iRead = this.read(buf);
        }
        return lSkipped;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        if (this.m_feLocal == null) return;
        long lFilePointer = this.m_zf.getDiskFile().getFilePointer();
        try {
            this.m_zf.getDiskFile().seek(this.m_lFilePointer);
            if (this.m_lRemainingSize > 0L) {
                byte[] buf = new byte[4096];
                int iRead = this.read(buf, 0, buf.length);
                while (iRead >= 0) {
                    iRead = this.read(buf, 0, buf.length);
                }
            } else {
                this.m_zf.getDataDescriptor(this.m_feLocal);
                if (this.m_feLocal.getSize() != this.m_lSize) {
                    throw new ZipException("invalid size (expected from local header/data descriptor " + String.valueOf(this.m_feLocal.getSize()) + " but actually found " + String.valueOf(this.m_lSize) + " bytes)");
                }
                if (this.m_feLocal.getCompressedSize() != this.m_lCompressedSize) {
                    throw new ZipException("invalid compressed size (expected from local header/data descriptor " + String.valueOf(this.m_feLocal.getCompressedSize()) + " but actually read " + String.valueOf(this.m_lCompressedSize) + " bytes)");
                }
                if (this.m_feLocal.getCrc() != this.m_crc.getValue()) {
                    throw new ZipException("invalid CRC (expected from local header/data descriptor 0x" + Long.toHexString(this.m_feLocal.getCrc()) + " but got 0x" + Long.toHexString(this.m_crc.getValue()) + ")");
                }
                this.m_feLocal = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_zf.getDiskFile().seek(lFilePointer);
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        this.m_zf.getDiskFile().seek(lFilePointer);
    }
}

