/*
 * Decompiled with CFR 0.152.
 */
package ch.enterag.utils.zip;

import java.util.Date;

public class FileEntry
implements Cloneable {
    private int m_iVersionNeeded;
    private int m_iFlags = 0;
    private int m_iMethod = -1;
    private long m_lDateTime = 0L;
    private String m_sName = null;
    private long m_lCrc = 0L;
    private long m_lSize = -1L;
    private long m_lCompressedSize = -1L;
    private byte[] m_bufExtra = new byte[0];
    private String m_sComment = "";
    private long m_lOffset = -1L;
    public static final int iMETHOD_STORED = 0;
    public static final int iMETHOD_DEFLATED = 8;
    public static final int iFLAG_ENCRYPTED = 1;
    public static final int iFLAG_DEFERRED = 4;
    public static final int iFLAG_EFS = 2048;
    public static final int iVERSION_NEEDED_ZIP64 = 45;
    public static final int iVERSION_NEEDED_ZIP = 20;

    public int getVersionNeeded() {
        return this.m_iVersionNeeded;
    }

    public void setVersionNeeded(int iVersionNeeded) {
        this.m_iVersionNeeded = iVersionNeeded;
    }

    public int getFlags() {
        return this.m_iFlags;
    }

    public void setFlags(int iFlags) {
        this.m_iFlags = iFlags;
    }

    public int getMethod() {
        return this.m_iMethod;
    }

    public void setMethod(int iMethod) {
        if (iMethod != 0 && iMethod != 8) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.m_iMethod = iMethod;
    }

    public long getDateTime() {
        return this.m_lDateTime;
    }

    public Date getTimestamp() {
        return new Date(FileEntry.dosToJavaTime(this.m_lDateTime));
    }

    public void setDateTime(long lDateTime) {
        this.m_lDateTime = lDateTime;
    }

    public void setTimeStamp(Date dateTimestamp) {
        this.m_lDateTime = FileEntry.javaToDosTime(dateTimestamp.getTime());
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public long getCrc() {
        return this.m_lCrc;
    }

    public void setCrc(long lCrc) {
        if (lCrc < 0L || lCrc > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.m_lCrc = lCrc;
    }

    public long getSize() {
        return this.m_lSize;
    }

    public void setSize(long lSize) {
        this.m_lSize = lSize;
    }

    public long getCompressedSize() {
        return this.m_lCompressedSize;
    }

    public void setCompressedSize(long lCompressedSize) {
        this.m_lCompressedSize = lCompressedSize;
    }

    public byte[] getExtra() {
        return this.m_bufExtra;
    }

    public void setExtra(byte[] bufExtra) {
        if (bufExtra != null && bufExtra.length > 65535) {
            throw new IllegalArgumentException("invalid extra field length");
        }
        this.m_bufExtra = bufExtra;
    }

    public String getComment() {
        return this.m_sComment;
    }

    public void setComment(String sComment) {
        if (sComment != null && sComment.length() > 65535) {
            throw new IllegalArgumentException("invalid entry comment length");
        }
        this.m_sComment = sComment;
    }

    public long getOffset() {
        return this.m_lOffset;
    }

    public void setOffset(long lOffset) {
        this.m_lOffset = lOffset;
    }

    public String toString() {
        return this.getName();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public FileEntry(String sName) {
        if (sName == null) {
            throw new NullPointerException();
        }
        if (sName.length() > 65535) {
            throw new IllegalArgumentException("entry name too long");
        }
        this.m_sName = sName;
    }

    public boolean isDirectory() {
        return this.m_sName.endsWith("/");
    }

    private static long dosToJavaTime(long dtime) {
        Date d = new Date((int)((dtime >> 25 & 0x7FL) + 80L), (int)((dtime >> 21 & 0xFL) - 1L), (int)(dtime >> 16 & 0x1FL), (int)(dtime >> 11 & 0x1FL), (int)(dtime >> 5 & 0x3FL), (int)(dtime << 1 & 0x3EL));
        return d.getTime();
    }

    private static long javaToDosTime(long time) {
        Date d = new Date(time);
        int year = d.getYear() + 1900;
        if (year < 1980) {
            return 0x210000L;
        }
        return year - 1980 << 25 | d.getMonth() + 1 << 21 | d.getDate() << 16 | d.getHours() << 11 | d.getMinutes() << 5 | d.getSeconds() >> 1;
    }
}

