/*
 * Decompiled with CFR 0.152.
 */
package ch.enterag.utils.zip;

import ch.enterag.utils.BU;
import ch.enterag.utils.SU;
import ch.enterag.utils.io.DiskFile;
import ch.enterag.utils.zip.EntryInputStream;
import ch.enterag.utils.zip.EntryOutputStream;
import ch.enterag.utils.zip.FileEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;

public class Zip64File {
    private static int iBUFFER_SIZE = 4096;
    private static int iMAX16 = 65535;
    private static long lMAX32 = 0xFFFFFFFFL;
    private static short wZIP64EIEF_ID = 1;
    private DiskFile m_df = null;
    private String m_sComment = null;
    private byte[] m_bufExtensibleData = new byte[0];
    private int m_iFileEntries = 0;
    private long m_lCentralDirectoryStart = 0L;
    private final List m_listFileEntries = new ArrayList();
    private final Map m_mapFileEntries = new HashMap();
    private boolean m_bChanged = false;
    private final Deflater m_def = new Deflater(-1, true);
    private FileEntry m_feLocal = null;
    private final CRC32 m_crc = new CRC32();
    private long m_lCompressedSize = 0L;
    private long m_lSize = 0L;

    private int readInt16() throws IOException {
        byte[] bufInt = new byte[4];
        Arrays.fill(bufInt, (byte)0);
        this.m_df.readFully(bufInt, 0, 2);
        return BU.toInt(bufInt);
    }

    private void writeInt16(int iInt) throws IOException {
        byte[] bufInt = BU.fromInt(iInt);
        this.m_df.write(bufInt, 0, 2);
    }

    private int readInt32() throws IOException {
        byte[] bufInt = new byte[4];
        this.m_df.readFully(bufInt);
        return BU.toInt(bufInt);
    }

    private void writeInt32(int iInt) throws IOException {
        byte[] bufInt = BU.fromInt(iInt);
        this.m_df.write(bufInt);
    }

    private long readLong32() throws IOException {
        byte[] bufLong = new byte[8];
        Arrays.fill(bufLong, (byte)0);
        this.m_df.readFully(bufLong, 0, 4);
        return BU.toLong(bufLong);
    }

    private void writeLong32(long lLong) throws IOException {
        byte[] bufInt = BU.fromLong(lLong);
        this.m_df.write(bufInt, 0, 4);
    }

    private long readLong64() throws IOException {
        byte[] bufLong = new byte[8];
        this.m_df.readFully(bufLong);
        return BU.toLong(bufLong);
    }

    private void writeLong64(long lLong) throws IOException {
        byte[] bufLong = BU.fromLong(lLong);
        this.m_df.write(bufLong);
    }

    private static boolean analyzeExtraField(FileEntry fe) {
        boolean bExtendedInformation = false;
        int iPos = 0;
        while (iPos < fe.getExtra().length && (fe.getSize() == lMAX32 || fe.getCompressedSize() == lMAX32 || fe.getOffset() == lMAX32)) {
            short wHeaderId = BU.toShort(fe.getExtra(), iPos);
            int iDataLength = BU.toShort(fe.getExtra(), iPos += 2) & iMAX16;
            iPos += 2;
            if (wHeaderId == wZIP64EIEF_ID) {
                bExtendedInformation = true;
                int iOffset = iPos;
                if (iOffset + 8 <= iPos + iDataLength && fe.getSize() == lMAX32) {
                    fe.setSize(BU.toLong(fe.getExtra(), iOffset));
                    iOffset += 8;
                }
                if (iOffset + 8 <= iPos + iDataLength && fe.getCompressedSize() == lMAX32) {
                    fe.setCompressedSize(BU.toLong(fe.getExtra(), iOffset));
                    iOffset += 8;
                }
                if (iOffset + 8 <= iPos + iDataLength && fe.getOffset() == lMAX32) {
                    fe.setOffset(BU.toLong(fe.getExtra(), iOffset));
                    iOffset += 8;
                }
            }
            iPos += iDataLength;
        }
        return bExtendedInformation;
    }

    private static void updateExtraField(FileEntry fe) {
        byte[] bufExtra = fe.getExtra();
        int iPos = 0;
        while (iPos < bufExtra.length) {
            short wHeaderId = BU.toShort(bufExtra, iPos);
            int iDataLength = BU.toShort(bufExtra, iPos += 2) & iMAX16;
            iPos += 2;
            if (wHeaderId == wZIP64EIEF_ID) {
                byte[] buf = new byte[bufExtra.length - (iDataLength + 4)];
                System.arraycopy(bufExtra, 0, buf, 0, iPos - 4);
                System.arraycopy(bufExtra, iPos + iDataLength, buf, iPos - 4, bufExtra.length - (iPos + iDataLength));
                bufExtra = buf;
                continue;
            }
            iPos += iDataLength;
        }
        short wDataSize = 0;
        if (fe.getSize() >= lMAX32) {
            wDataSize = (short)(wDataSize + 8);
        }
        if (fe.getCompressedSize() >= lMAX32) {
            wDataSize = (short)(wDataSize + 8);
        }
        if (fe.getOffset() >= lMAX32) {
            wDataSize = (short)(wDataSize + 8);
        }
        if (wDataSize > 0) {
            byte[] buf = new byte[4 + wDataSize + bufExtra.length];
            short wHeaderId = wZIP64EIEF_ID;
            int iPos2 = 0;
            byte[] bufHeaderId = BU.fromShort(wHeaderId);
            System.arraycopy(bufHeaderId, 0, buf, iPos2, bufHeaderId.length);
            byte[] bufDataSize = BU.fromShort(wDataSize);
            System.arraycopy(bufDataSize, 0, buf, iPos2 += bufHeaderId.length, bufDataSize.length);
            iPos2 += bufDataSize.length;
            if (fe.getSize() >= lMAX32) {
                byte[] bufOriginalSize = BU.fromLong(fe.getSize());
                System.arraycopy(bufOriginalSize, 0, buf, iPos2, bufOriginalSize.length);
                iPos2 += bufOriginalSize.length;
            }
            if (fe.getCompressedSize() >= lMAX32) {
                byte[] bufCompressedSize = BU.fromLong(fe.getCompressedSize());
                System.arraycopy(bufCompressedSize, 0, buf, iPos2, bufCompressedSize.length);
                iPos2 += bufCompressedSize.length;
            }
            if (fe.getOffset() >= lMAX32) {
                byte[] bufOffset = BU.fromLong(fe.getOffset());
                System.arraycopy(bufOffset, 0, buf, iPos2, bufOffset.length);
                iPos2 += bufOffset.length;
            }
            System.arraycopy(bufExtra, 0, buf, iPos2, bufExtra.length);
            bufExtra = buf;
        }
        fe.setExtra(bufExtra);
    }

    void getDataDescriptor(FileEntry fe) throws IOException {
        if ((fe.getFlags() & 4) != 0) {
            boolean bZip64 = Zip64File.analyzeExtraField(fe);
            long l = this.readLong32();
            if (l != 134695760L) {
                fe.setCrc(l);
            } else {
                fe.setCrc(this.readLong32());
            }
            if (!bZip64) {
                fe.setCompressedSize(this.readLong32());
                fe.setSize(this.readLong32());
            } else {
                fe.setCompressedSize(this.readLong64());
                fe.setSize(this.readLong64());
            }
        }
    }

    FileEntry getLocalFileEntry(FileEntry feGlobal) throws IOException, ZipException {
        this.m_df.seek(feGlobal.getOffset());
        FileEntry fe = null;
        int iSignature = this.readInt32();
        if (iSignature != 67324752) {
            throw new ZipException("Invalid signature of local  file header entry!");
        }
        int iVersionNeeded = this.readInt16();
        int iFlags = this.readInt16();
        if ((iFlags & 1) != 0) {
            throw new ZipException("Encryption not supported!");
        }
        int iCompressionMethod = this.readInt16();
        if (iCompressionMethod != 0 && iCompressionMethod != 8) {
            throw new ZipException("Compression method " + String.valueOf(iCompressionMethod) + " not supported!");
        }
        long lLastModFileDateTime = this.readLong32();
        long lCrc = this.readLong32();
        long lCompressedSize = this.readLong32();
        long lSize = this.readLong32();
        int iFileNameLength = this.readInt16();
        int iExtraFieldLength = this.readInt16();
        byte[] bufFileName = new byte[iFileNameLength];
        this.m_df.readFully(bufFileName);
        String sFileName = (iFlags & 0x800) != 0 ? SU.getUtf8String(bufFileName) : SU.getCp437String(bufFileName);
        byte[] bufExtraField = new byte[iExtraFieldLength];
        this.m_df.readFully(bufExtraField);
        fe = new FileEntry(sFileName);
        fe.setOffset(feGlobal.getOffset());
        fe.setVersionNeeded(iVersionNeeded);
        fe.setDateTime(lLastModFileDateTime);
        fe.setFlags(iFlags);
        fe.setCrc(lCrc);
        fe.setExtra(bufExtraField);
        fe.setMethod(iCompressionMethod);
        fe.setCompressedSize(lCompressedSize);
        fe.setSize(lSize);
        if (lSize == lMAX32 || lCompressedSize == lMAX32) {
            Zip64File.analyzeExtraField(fe);
            if ((fe.getFlags() & 4) != 0) {
                fe.setCompressedSize(lCompressedSize);
                fe.setSize(lSize);
            }
        }
        return fe;
    }

    private FileEntry getCentralDirectoryEntry() throws IOException {
        FileEntry fe = null;
        int iSignature = this.readInt32();
        if (iSignature != 33639248) {
            throw new ZipException("Invalid signature of central directory entry!");
        }
        this.readInt16();
        int iVersionNeeded = this.readInt16();
        int iFlags = this.readInt16();
        if ((iFlags & 1) != 0) {
            throw new ZipException("Encryption not supported!");
        }
        int iCompressionMethod = this.readInt16();
        if (iCompressionMethod != 0 && iCompressionMethod != 8) {
            throw new ZipException("Compression method " + String.valueOf(iCompressionMethod) + " not supported!");
        }
        long lLastModFileDateTime = this.readLong32();
        long lCrc = this.readLong32();
        long lCompressedSize = this.readLong32();
        long lSize = this.readLong32();
        int iFileNameLength = this.readInt16();
        int iExtraFieldLength = this.readInt16();
        int iFileCommentLength = this.readInt16();
        int iDiskNumberStart = this.readInt16();
        if (iDiskNumberStart != 0) {
            throw new ZipException("Split or spanned ZIP files are not supported!");
        }
        this.readInt16();
        this.readLong32();
        long lOffsetLocalHeader = this.readLong32();
        byte[] bufFileName = new byte[iFileNameLength];
        this.m_df.readFully(bufFileName);
        String sFileName = (iFlags & 0x800) != 0 ? SU.getUtf8String(bufFileName) : SU.getCp437String(bufFileName);
        byte[] bufExtraField = new byte[iExtraFieldLength];
        this.m_df.readFully(bufExtraField);
        byte[] bufFileComment = new byte[iFileCommentLength];
        this.m_df.readFully(bufFileComment);
        String sFileComment = (iFlags & 0x800) != 0 ? SU.getUtf8String(bufFileComment) : SU.getCp437String(bufFileComment);
        fe = new FileEntry(sFileName);
        fe.setComment(sFileComment);
        fe.setCompressedSize(lCompressedSize);
        fe.setCrc(lCrc);
        fe.setExtra(bufExtraField);
        fe.setOffset(lOffsetLocalHeader);
        fe.setMethod(iCompressionMethod);
        fe.setSize(lSize);
        fe.setDateTime(lLastModFileDateTime);
        fe.setFlags(iFlags);
        fe.setVersionNeeded(iVersionNeeded);
        if (lSize == lMAX32 || lCompressedSize == lMAX32 || lOffsetLocalHeader == lMAX32) {
            Zip64File.analyzeExtraField(fe);
        }
        return fe;
    }

    private long getZip64CenDirStart(long lStart) throws IOException {
        long lCenDirStart = -1L;
        this.m_df.seek(lStart);
        int iSignature = this.readInt32();
        if (iSignature != 101075792) {
            throw new ZipException("Invalid signature of Zip64 end of central directory record!");
        }
        long lSizeRecord = this.readLong64();
        this.readInt16();
        this.readInt16();
        int iDiskNumber = this.readInt32();
        if (iDiskNumber != 0) {
            throw new ZipException("Split or spanned ZIP files are not supported!");
        }
        int iDiskCenDirStart = this.readInt32();
        if (iDiskCenDirStart != 0) {
            throw new ZipException("Split or spanned ZIP files are not supported!");
        }
        this.readLong64();
        long lFileEntries = this.readLong64();
        if (lFileEntries > Integer.MAX_VALUE) {
            throw new ZipException("Too many files! Cannot handle " + String.valueOf(lFileEntries) + ".");
        }
        this.m_iFileEntries = (int)lFileEntries;
        this.readLong64();
        lCenDirStart = this.readLong64();
        int iExtensibleDataSize = (int)lSizeRecord - 44;
        this.m_bufExtensibleData = new byte[iExtensibleDataSize];
        this.m_df.read(this.m_bufExtensibleData);
        return lCenDirStart;
    }

    private long getZip64EndOfCenDirStart(long lEndCenDirStart) throws IOException {
        long lZip64EndOfCenDirStart = -1L;
        this.m_df.seek(lEndCenDirStart - 20L);
        int iSignature = this.readInt32();
        if (iSignature != 117853008) {
            throw new ZipException("Invalid signature of Zip64 end of central directory locator!");
        }
        int iDiskZip64Eocdr = this.readInt32();
        if (iDiskZip64Eocdr != 0) {
            throw new ZipException("Split or spanned ZIP files are not supported!");
        }
        lZip64EndOfCenDirStart = this.readLong64();
        int iTotalNumberOfDisks = this.readInt32();
        if (iTotalNumberOfDisks != 1) {
            throw new ZipException("Split or spanned ZIP files are not supported!");
        }
        return lZip64EndOfCenDirStart;
    }

    private long getCenDirStart() throws IOException {
        long lCenDirStart = -1L;
        this.m_df.seek(this.m_df.length());
        long lEndCenDirRecord = this.m_df.lastIndexOf(BU.fromInt(101010256));
        while (this.m_sComment == null && lEndCenDirRecord >= 0L) {
            this.m_df.seek(lEndCenDirRecord + 20L);
            int iCommentLength = this.readInt16();
            if (this.m_df.length() != lEndCenDirRecord + 22L + (long)iCommentLength) continue;
            byte[] bufComment = new byte[iCommentLength];
            this.m_df.readFully(bufComment, 0, iCommentLength);
            this.m_sComment = SU.getUtf8String(bufComment);
        }
        if (this.m_sComment == null) {
            throw new ZipException("End of cental directory not found! (Invalid ZIP file?)");
        }
        this.m_df.seek(lEndCenDirRecord + 4L);
        int iLastDisk = this.readInt16();
        int iCdDisk = this.readInt16();
        if (iLastDisk != 0 || iCdDisk != 0) {
            throw new ZipException("Split or spanned ZIP files are not supported!");
        }
        this.readInt16();
        this.m_iFileEntries = this.readInt16();
        long lCdSize = this.readLong32();
        lCenDirStart = this.readLong32();
        if (this.m_iFileEntries == iMAX16 || lCdSize == lMAX32 || lCenDirStart == lMAX32) {
            long lPos = this.getZip64EndOfCenDirStart(lEndCenDirRecord);
            lPos = this.getZip64CenDirStart(lPos);
            if (lCenDirStart == lMAX32) {
                lCenDirStart = lPos;
            }
        }
        return lCenDirStart;
    }

    private void getCentralDirectory() throws IOException {
        if (this.m_df.length() > 0L) {
            this.m_lCentralDirectoryStart = this.getCenDirStart();
            this.m_df.seek(this.m_lCentralDirectoryStart);
            int i = 0;
            while (i < this.m_iFileEntries) {
                FileEntry fe = this.getCentralDirectoryEntry();
                this.m_listFileEntries.add(fe);
                this.m_mapFileEntries.put(fe.getName(), fe);
                ++i;
            }
            this.m_df.seek(this.m_lCentralDirectoryStart);
        } else {
            this.m_sComment = "";
        }
    }

    private void putDataDescriptor(FileEntry fe, long lCompressedSize, long lSize) throws IOException {
        if ((fe.getFlags() & 4) != 0) {
            boolean bZip64 = Zip64File.analyzeExtraField(fe);
            fe.setSize(lSize);
            fe.setCompressedSize(lCompressedSize);
            this.writeInt32(134695760);
            this.writeLong32(fe.getCrc());
            if (!bZip64) {
                this.writeLong32(fe.getCompressedSize());
                this.writeLong32(fe.getSize());
            } else {
                this.writeLong64(fe.getCompressedSize());
                this.writeLong64(fe.getSize());
            }
        }
    }

    private void putLocalFileEntry(FileEntry fe) throws IOException, ZipException {
        fe.setOffset(this.m_df.getFilePointer());
        int iSignature = 67324752;
        this.writeInt32(iSignature);
        this.writeInt16(fe.getVersionNeeded());
        this.writeInt16(fe.getFlags());
        this.writeInt16(fe.getMethod());
        this.writeLong32(fe.getDateTime());
        this.writeLong32(fe.getCrc());
        this.writeLong32(fe.getCompressedSize());
        this.writeLong32(fe.getSize());
        byte[] bufFileName = null;
        bufFileName = (fe.getFlags() & 0x800) != 0 ? SU.putUtf8String(fe.getName()) : SU.putCp437String(fe.getName());
        this.writeInt16(bufFileName.length);
        this.writeInt16(fe.getExtra().length);
        this.m_df.write(bufFileName);
        this.m_df.write(fe.getExtra());
    }

    private void putCentralDirectoryEntry(FileEntry fe) throws IOException {
        this.writeInt32(33639248);
        this.writeInt16(45);
        this.writeInt16(45);
        this.writeInt16(fe.getFlags());
        this.writeInt16(fe.getMethod());
        this.writeLong32(fe.getDateTime());
        this.writeLong32(fe.getCrc());
        if (fe.getCompressedSize() < lMAX32) {
            this.writeLong32(fe.getCompressedSize());
        } else {
            this.writeLong32(lMAX32);
        }
        if (fe.getSize() < lMAX32) {
            this.writeLong32(fe.getSize());
        } else {
            this.writeLong32(lMAX32);
        }
        byte[] bufFileName = null;
        bufFileName = (fe.getFlags() & 0x800) != 0 ? SU.putUtf8String(fe.getName()) : SU.putCp437String(fe.getName());
        this.writeInt16(bufFileName.length);
        this.writeInt16(fe.getExtra().length);
        byte[] bufComment = null;
        bufComment = (fe.getFlags() & 0x800) != 0 ? SU.putUtf8String(fe.getComment()) : SU.putCp437String(fe.getComment());
        this.writeInt16(bufComment.length);
        this.writeInt16(0);
        this.writeInt16(0);
        this.writeInt32(0);
        if (fe.getOffset() < lMAX32) {
            this.writeLong32(fe.getOffset());
        } else {
            this.writeLong32(lMAX32);
        }
        this.m_df.write(bufFileName);
        this.m_df.write(fe.getExtra());
        this.m_df.write(bufComment);
        this.m_bChanged = false;
    }

    private void putCentralDirectoryEnd() throws IOException {
        long lCentralDirectoryEnd = this.m_df.getFilePointer();
        long lCenDirSize = this.m_df.getFilePointer() - this.m_lCentralDirectoryStart;
        if (this.m_iFileEntries >= iMAX16 || lCenDirSize >= lMAX32 || this.m_lCentralDirectoryStart >= lMAX32) {
            this.writeInt32(101075792);
            this.writeLong64(44 + this.m_bufExtensibleData.length);
            this.writeInt16(45);
            this.writeInt16(45);
            this.writeInt32(0);
            this.writeInt32(0);
            this.writeLong64(this.m_iFileEntries);
            this.writeLong64(this.m_iFileEntries);
            this.writeLong64(lCenDirSize);
            this.writeLong64(this.m_lCentralDirectoryStart);
            this.m_df.write(this.m_bufExtensibleData);
            this.writeInt32(117853008);
            this.writeInt32(0);
            this.writeLong64(lCentralDirectoryEnd);
            this.writeInt32(1);
        }
        this.writeInt32(101010256);
        this.writeInt16(0);
        this.writeInt16(0);
        if (this.m_iFileEntries >= iMAX16) {
            this.writeInt16(iMAX16);
            this.writeInt16(iMAX16);
        } else {
            this.writeInt16(this.m_iFileEntries);
            this.writeInt16(this.m_iFileEntries);
        }
        if (lCenDirSize >= lMAX32) {
            this.writeLong32(lMAX32);
        } else {
            this.writeLong32(lCenDirSize);
        }
        if (this.m_lCentralDirectoryStart >= lMAX32) {
            this.writeLong32(lMAX32);
        } else {
            this.writeLong32(this.m_lCentralDirectoryStart);
        }
        byte[] bufComment = SU.putUtf8String(this.m_sComment);
        this.writeInt16(bufComment.length);
        if (bufComment.length > 0) {
            this.m_df.write(bufComment);
        }
    }

    private void putCentralDirectory() throws IOException {
        int i = 0;
        Iterator iterFileEntries = this.m_listFileEntries.iterator();
        while (iterFileEntries.hasNext()) {
            FileEntry fe = (FileEntry)iterFileEntries.next();
            this.putCentralDirectoryEntry(fe);
            ++i;
        }
        this.putCentralDirectoryEnd();
    }

    public Zip64File(String sFileName, boolean bReadOnly) throws FileNotFoundException, IOException {
        this.m_df = new DiskFile(sFileName, bReadOnly);
        this.getCentralDirectory();
    }

    public Zip64File(File file, boolean bReadOnly) throws FileNotFoundException, IOException {
        this.m_df = new DiskFile(file, bReadOnly);
        this.getCentralDirectory();
    }

    public Zip64File(String sFileName) throws FileNotFoundException, IOException {
        this.m_df = new DiskFile(sFileName);
        this.getCentralDirectory();
    }

    public Zip64File(File file) throws FileNotFoundException, IOException {
        this.m_df = new DiskFile(file);
        this.getCentralDirectory();
    }

    public DiskFile getDiskFile() {
        return this.m_df;
    }

    public int getFileEntries() {
        return this.m_iFileEntries;
    }

    public FileEntry getFileEntry(String sEntryName) {
        return (FileEntry)this.m_mapFileEntries.get(sEntryName);
    }

    public List getListFileEntries() {
        return this.m_listFileEntries;
    }

    public String getComment() {
        return this.m_sComment;
    }

    public void setComment(String sComment) throws IOException {
        if (!this.m_sComment.equals(sComment)) {
            this.m_bChanged = true;
            this.m_df.setLength(this.m_lCentralDirectoryStart);
            this.m_sComment = sComment;
        }
    }

    public EntryInputStream openEntryInputStream(String sEntryName) throws FileNotFoundException, IOException, ZipException {
        return new EntryInputStream(this, sEntryName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openWrite(String sEntryName, int iMethod, Date dateModified) throws FileNotFoundException, IOException, ZipException {
        if (iMethod != 8 && iMethod != 0) {
            throw new IllegalArgumentException("Invalid method!");
        }
        if (this.m_mapFileEntries.get(sEntryName) != null) throw new ZipException("File " + sEntryName + " cannot be added twice to ZIP file!");
        if (this.m_feLocal != null) throw new ZipException("Only one file entry can be opened for reading or writing at a time!");
        this.m_df.setLength(this.m_lCentralDirectoryStart);
        this.m_bChanged = true;
        this.m_feLocal = new FileEntry(sEntryName);
        this.m_feLocal.setOffset(this.m_lCentralDirectoryStart);
        if (!this.m_feLocal.isDirectory()) {
            this.m_feLocal.setVersionNeeded(45);
            this.m_feLocal.setFlags(2052);
            this.m_feLocal.setSize(lMAX32);
            this.m_feLocal.setCompressedSize(lMAX32);
            this.m_feLocal.setMethod(iMethod);
            if (dateModified != null) {
                this.m_feLocal.setTimeStamp(dateModified);
            }
            short wHeaderId = wZIP64EIEF_ID;
            short wDataSize = 16;
            byte[] bufExtra = new byte[4 + wDataSize];
            int iPos = 0;
            byte[] bufHeaderId = BU.fromShort(wHeaderId);
            System.arraycopy(bufHeaderId, 0, bufExtra, iPos, bufHeaderId.length);
            byte[] bufDataSize = BU.fromShort(wDataSize);
            System.arraycopy(bufDataSize, 0, bufExtra, iPos += bufHeaderId.length, bufDataSize.length);
            byte[] bufOriginalSize = BU.fromLong(0L);
            System.arraycopy(bufOriginalSize, 0, bufExtra, iPos += bufDataSize.length, bufOriginalSize.length);
            byte[] bufCompressedSize = BU.fromLong(0L);
            System.arraycopy(bufCompressedSize, 0, bufExtra, iPos += bufOriginalSize.length, bufCompressedSize.length);
            iPos += bufCompressedSize.length;
            this.m_feLocal.setExtra(bufExtra);
        } else {
            this.m_feLocal.setVersionNeeded(20);
            this.m_feLocal.setFlags(2048);
            this.m_feLocal.setSize(0L);
            this.m_feLocal.setCompressedSize(0L);
            this.m_feLocal.setMethod(0);
            this.m_feLocal.setExtra(new byte[0]);
        }
        this.m_feLocal.setOffset(this.m_df.getFilePointer());
        this.putLocalFileEntry(this.m_feLocal);
        this.m_def.reset();
        this.m_crc.reset();
        this.m_lCompressedSize = 0L;
        this.m_lSize = 0L;
    }

    private void writeDeflated(byte[] buf, int iOffset, int iLength) throws IOException {
        if (iLength > 0) {
            this.m_def.setInput(buf, iOffset, iLength);
            byte[] bufCompressed = new byte[iBUFFER_SIZE];
            while (!this.m_def.needsInput()) {
                int iWriteSize = this.m_def.deflate(bufCompressed);
                if (iWriteSize <= 0) continue;
                this.m_lCompressedSize += (long)iWriteSize;
                this.m_df.write(bufCompressed, 0, iWriteSize);
            }
        }
    }

    private void writeStored(byte[] buf, int iOffset, int iLength) throws IOException {
        this.m_df.write(buf, iOffset, iLength);
        this.m_lCompressedSize += (long)iLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void write(byte[] buf, int iOffset, int iLength) throws IOException {
        if (iOffset < 0 || iLength < 0 || iOffset > buf.length - iLength) {
            throw new IndexOutOfBoundsException();
        }
        if (iLength == 0) return;
        if (this.m_feLocal == null) throw new ZipException("File not open for writing!");
        if (this.m_feLocal.isDirectory()) throw new ZipException("Data cannot be written to directory entry!");
        this.m_crc.update(buf, iOffset, iLength);
        this.m_lSize += (long)iLength;
        switch (this.m_feLocal.getMethod()) {
            case 8: {
                this.writeDeflated(buf, iOffset, iLength);
                return;
            }
            case 0: {
                this.writeStored(buf, iOffset, iLength);
            }
            default: {
                return;
            }
        }
    }

    void closeWrite() throws IOException {
        if (this.m_feLocal != null) {
            if (this.m_lSize > 0L && this.m_feLocal.getMethod() == 8) {
                this.m_def.finish();
                byte[] bufCompressed = new byte[iBUFFER_SIZE];
                while (!this.m_def.finished()) {
                    int iWriteSize = this.m_def.deflate(bufCompressed);
                    if (iWriteSize <= 0) continue;
                    this.m_lCompressedSize += (long)iWriteSize;
                    this.m_df.write(bufCompressed, 0, iWriteSize);
                }
            }
            this.m_feLocal.setCrc(this.m_crc.getValue());
            this.putDataDescriptor(this.m_feLocal, this.m_lCompressedSize, this.m_lSize);
            Zip64File.updateExtraField(this.m_feLocal);
            ++this.m_iFileEntries;
            this.m_listFileEntries.add(this.m_feLocal);
            this.m_mapFileEntries.put(this.m_feLocal.getName(), this.m_feLocal);
            this.m_feLocal = null;
            this.m_lCentralDirectoryStart = this.m_df.getFilePointer();
        }
    }

    public EntryOutputStream openEntryOutputStream(String sEntryName, int iMethod, Date dateModified) throws FileNotFoundException, IOException, ZipException {
        this.openWrite(sEntryName, iMethod, dateModified);
        return new EntryOutputStream(this);
    }

    private long getSize(FileEntry feGlobal) throws ZipException, IOException {
        long lSize = 0L;
        try {
            feGlobal = (FileEntry)feGlobal.clone();
        }
        catch (CloneNotSupportedException cnse) {
            System.err.println(cnse.getMessage());
        }
        EntryInputStream eis = this.openEntryInputStream(feGlobal.getName());
        FileEntry feLocal = eis.getFileEntryLocal();
        try {
            feLocal = (FileEntry)feLocal.clone();
        }
        catch (CloneNotSupportedException cnse) {
            System.err.println(cnse.getMessage());
        }
        lSize = eis.getFilePointer() - feGlobal.getOffset();
        this.m_df.seek(eis.getFilePointer() + feGlobal.getCompressedSize());
        lSize += feGlobal.getCompressedSize();
        this.getDataDescriptor(feLocal);
        long lFilePointer = this.m_df.getFilePointer();
        lSize += this.m_df.getFilePointer() - (feGlobal.getOffset() + lSize);
        eis.close();
        this.m_df.seek(lFilePointer);
        return lSize;
    }

    public FileEntry delete(String sEntryName) throws IOException {
        FileEntry feDelete = (FileEntry)this.m_mapFileEntries.get(sEntryName);
        if (feDelete != null) {
            this.m_df.setLength(this.m_lCentralDirectoryStart);
            this.m_bChanged = true;
            long lDeleteSize = this.getSize(feDelete);
            Iterator iterFileEntry = this.m_listFileEntries.iterator();
            while (iterFileEntry.hasNext()) {
                FileEntry fe = (FileEntry)iterFileEntry.next();
                if (fe.getOffset() <= feDelete.getOffset()) continue;
                fe.setOffset(fe.getOffset() - lDeleteSize);
                Zip64File.updateExtraField(fe);
            }
            this.m_df.move(feDelete.getOffset() + lDeleteSize, feDelete.getOffset());
            this.m_lCentralDirectoryStart -= lDeleteSize;
            if (this.m_lCentralDirectoryStart != this.m_df.getFilePointer() || this.m_lCentralDirectoryStart != this.m_df.length()) {
                throw new ZipException("move produced unexpected result!");
            }
            this.m_df.seek(this.m_lCentralDirectoryStart);
            this.m_df.setLength(this.m_lCentralDirectoryStart);
            --this.m_iFileEntries;
        } else {
            throw new ZipException("File " + sEntryName + " cannot be deleted, because it does not exist!");
        }
        this.m_listFileEntries.remove(feDelete);
        this.m_mapFileEntries.remove(feDelete.getName());
        return feDelete;
    }

    public void close() throws IOException {
        if (this.m_bChanged) {
            this.putCentralDirectory();
        }
        this.m_df.close();
    }
}

