/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms.magiceye;

import java.util.ArrayList;
import java.util.Collections;
import pedviz.algorithms.HierarchieUpDown;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Hierarchy;
import pedviz.graph.Node;

public class MagicHierarchieBuilder
extends HierarchieUpDown {
    public void buildHirarchie(Graph graph) {
        Hierarchy hierachie = new Hierarchy(graph);
        for (Node node : graph.getNodes()) {
            if (node.getInDegree() == 0) {
                hierachie.addNode(1, node);
                continue;
            }
            hierachie.addNode(-1, node);
        }
        int currentLayer = 1;
        ArrayList<Node> currentNodes = hierachie.getNodes(1);
        while (currentNodes != null) {
            ArrayList<Integer> newNodesLayer = new ArrayList<Integer>();
            ArrayList<Node> newNode = new ArrayList<Node>();
            for (Node node : currentNodes) {
                for (Edge pre : node.getInEdges()) {
                    if (pre.getStart().getLevel() < currentLayer) continue;
                    newNode.add(node);
                    newNodesLayer.add(currentLayer + 1);
                }
                for (Edge pre : node.getOutEdges()) {
                    Node end = pre.getEnd();
                    if (end.getLevel() > currentLayer) continue;
                    newNode.add(end);
                    newNodesLayer.add(currentLayer + 1);
                }
            }
            for (int i = 0; i < newNode.size(); ++i) {
                hierachie.addNode((Integer)newNodesLayer.get(i), (Node)newNode.get(i));
            }
            currentNodes = hierachie.getNodes(currentLayer);
            ++currentLayer;
            for (Node node : currentNodes) {
                for (Edge outEdge : node.getOutEdges()) {
                    Node parent = outEdge.getEnd();
                    int maxLayer = -1;
                    for (Edge pre : parent.getInEdges()) {
                        Node start = pre.getStart();
                        if (start.getLevel() <= maxLayer) continue;
                        maxLayer = start.getLevel();
                    }
                    if (parent.getLevel() >= 0 || maxLayer >= currentLayer) continue;
                    hierachie.addNode(currentLayer, parent);
                }
            }
            currentNodes = hierachie.getNodes(currentLayer);
        }
        this.shuffle(graph, 0);
        for (int i = 0; i < graph.getHierachiesCount(); ++i) {
            this.insertDummyNodes(graph, i);
        }
        Node root = new Node(graph.getFreeId());
        root.setDummy(true);
        root.setIdDad(null);
        root.setIdMom(null);
        graph.addNode(root);
        graph.getHierachy(0).addNode(0, root);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : graph.getAllNodes()) {
            if (node.getInDegree() != 0 || node == root) continue;
            nodes.add(node);
        }
        for (Node node : nodes) {
            if (node.getLevel() > 1) {
                Node n = root;
                for (int w = 1; w < node.getLevel(); ++w) {
                    Node dummy = new Node(graph.getFreeId());
                    dummy.setDummy(true);
                    dummy.setIdMom(n.getId());
                    dummy.setIdDad(n.getId());
                    graph.addNode(dummy);
                    graph.getHierachy(0).addNode(w, dummy);
                    Edge e = new Edge(n, dummy);
                    e.setDummy(true);
                    graph.addEdge(e);
                    n = dummy;
                }
                Edge e = new Edge(n, node);
                e.setDummy(true);
                graph.addEdge(e);
                continue;
            }
            Edge e = new Edge(root, node);
            e.setDummy(true);
            graph.addEdge(e);
        }
        nodes.clear();
    }

    private void shuffle(Graph graph, int id) {
        for (int i = 0; i < graph.getHierachiesDepth(); ++i) {
            ArrayList<Node> layer = graph.getHierachy(id).getNodes(i);
            if (layer == null) continue;
            Collections.shuffle(layer);
        }
    }

    private void insertDummyNodes(Graph graph, int id) {
        Hierarchy hierarchie = graph.getHierachy(id);
        for (int i = 0; i < graph.getHierachiesDepth() - 1; ++i) {
            ArrayList<Node> currentNodes = hierarchie.getNodes(i);
            if (currentNodes == null) continue;
            ArrayList copyOfCurrentNodes = (ArrayList)currentNodes.clone();
            for (Node node : copyOfCurrentNodes) {
                ArrayList copyOfEdges = (ArrayList)node.getOutEdges().clone();
                for (Edge in : copyOfEdges) {
                    Node end = in.getEnd();
                    if (end.getLevel() - i <= 1) continue;
                    if (node.getInDegree() == 0) {
                        hierarchie.addNode(i + 1, node);
                        continue;
                    }
                    Node dummy = new Node(graph.getFreeId());
                    dummy.setDummy(true);
                    dummy.setIdMom(in.getEnd().getIdMom());
                    dummy.setIdDad(in.getEnd().getIdDad());
                    graph.addNode(dummy);
                    hierarchie.addNode(i + 1, dummy);
                    graph.addEdge(new Edge(node, dummy));
                    graph.addEdge(new Edge(dummy, in.getEnd()));
                    graph.removeEdge(in);
                }
                copyOfEdges.clear();
            }
            copyOfCurrentNodes.clear();
        }
    }
}

