/*
 * Decompiled with CFR 0.152.
 */
package pedviz.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import pedviz.graph.Edge;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster {
    private HashMap<Object, Node> nodes = new HashMap();
    private ArrayList<Edge> edges = new ArrayList();

    public Cluster() {
    }

    public Cluster(Vector<Node> nodes) {
        this();
        for (Node node : nodes) {
            this.addNode(node);
        }
    }

    public Cluster(Set<Node> nodes) {
        this();
        for (Node node : nodes) {
            this.addNode(node);
        }
    }

    public void addNode(Node node) {
        if (node.getParent() != null) {
            this.addNode(node.getParent());
        } else if (!this.nodes.containsKey(node.getId())) {
            Edge newEdge;
            Node newNode = (Node)node.clone();
            this.nodes.put(node.getId(), newNode);
            for (Edge edge : node.getInEdges()) {
                if (!this.nodes.containsKey(edge.getStart().getId())) continue;
                newEdge = new Edge(this.nodes.get(edge.getStart().getId()), newNode);
                this.edges.add(newEdge);
            }
            for (Edge edge : node.getOutEdges()) {
                if (!this.nodes.containsKey(edge.getEnd().getId())) continue;
                newEdge = new Edge(newNode, this.nodes.get(edge.getEnd().getId()));
                this.edges.add(newEdge);
            }
        }
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }
}

