/*
 * Decompiled with CFR 0.152.
 */
package pedviz.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Node;
import pedviz.loader.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayGraphLoader
extends Loader {
    private String[] data;
    private String separator;
    private String format;
    private ArrayList<String> attributes;
    private HashMap<String, Integer> types;
    public static final int INTEGER = 0;
    public static final int DOUBLE = 1;

    public ArrayGraphLoader(String format, String separator, String[] data) {
        this.data = data;
        this.format = format;
        this.separator = separator;
        this.attributes = new ArrayList();
        this.types = new HashMap();
    }

    public void setColumnType(String column, int type) {
        this.types.put(column, type);
    }

    @Override
    public void load(Graph graph) {
        int colId = -1;
        int colIdMom = -1;
        int colIdDad = -1;
        ArrayList<Object[]> myEdges = new ArrayList<Object[]>();
        graph.setName("Pedigree");
        String[] colStrings = this.format.split(this.separator);
        for (int i = 0; i < colStrings.length; ++i) {
            String colString = colStrings[i].toUpperCase();
            if (colString.equals(this.getIdColumn().toUpperCase())) {
                colId = i;
            }
            if (colString.equals(this.getMomColumn().toUpperCase())) {
                colIdMom = i;
            }
            if (colString.equals(this.getDadColumn().toUpperCase())) {
                colIdDad = i;
            }
            this.attributes.add(colString);
        }
        for (String row : this.data) {
            String[] columns = row.split(this.separator);
            Integer id = Integer.parseInt(columns[colId]);
            Node node = new Node(id);
            Integer idMom = null;
            if (!columns[colIdMom].equals("")) {
                idMom = Integer.parseInt(columns[colIdMom]);
            }
            Integer idDad = null;
            if (!columns[colIdDad].equals("")) {
                idDad = Integer.parseInt(columns[colIdDad]);
            }
            node.setIdDad(idDad);
            node.setIdMom(idMom);
            myEdges.add(new Object[]{idDad, id});
            myEdges.add(new Object[]{idMom, id});
            graph.addNode(node);
            for (int i = 0; i < columns.length; ++i) {
                String value = columns[i];
                if (i == colIdMom) {
                    node.setUserData(colStrings[i], idMom);
                    continue;
                }
                if (i == colIdDad) {
                    node.setUserData(colStrings[i], idDad);
                    continue;
                }
                Integer type = this.types.get(colStrings[i]);
                if (type != null) {
                    switch (type) {
                        case 0: {
                            node.setUserData(colStrings[i], Integer.parseInt(value));
                            break;
                        }
                        case 1: {
                            node.setUserData(colStrings[i], Double.parseDouble(value));
                            break;
                        }
                        default: {
                            node.setUserData(colStrings[i], value);
                            break;
                        }
                    }
                    continue;
                }
                node.setUserData(colStrings[i], value);
            }
        }
        for (Object[] edge : myEdges) {
            Node start = graph.getNode(edge[0]);
            Node end = graph.getNode(edge[1]);
            if (start == null || end == null) continue;
            Edge edge2 = new Edge(start, end);
            graph.addEdge(edge2);
        }
    }

    public ArrayList<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public Vector<String> getColumns() {
        String[] tiles;
        Vector<String> colStrings = new Vector<String>();
        for (String tile : tiles = this.format.split(this.separator)) {
            colStrings.add(tile);
        }
        return colStrings;
    }
}

