/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import pedviz.graph.LayoutedGraph;
import pedviz.graph.Node;
import pedviz.view.DefaultEdgeView;
import pedviz.view.DefaultNodeView;
import pedviz.view.NodeEvent;
import pedviz.view.NodeListener;
import pedviz.view.NodeView;
import pedviz.view.effects.Effect;
import pedviz.view.rules.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphView {
    protected Vector<NodeListener> nodeListeners;
    protected LayoutedGraph graph;
    protected double translateX = 0.0;
    protected double translateY = 0.0;
    protected double scale = 1.0;
    protected boolean edgeVisible = true;
    protected boolean selectionEnabled = false;
    protected boolean zoomEnabled = true;
    protected boolean movingEnabled = true;
    protected boolean multiselection = false;
    protected HashMap<Object, NodeView> selectedNodes;
    protected HashMap<Object, NodeView> highlightedNodes;
    protected HashMap<Object, NodeView> hiddenNodes;
    protected Vector<Rule> rules;
    protected Color backgroundColor = new Color(255, 255, 255);
    protected boolean autozoom = true;
    protected float alpha = 0.2f;
    protected Effect effect;
    protected DefaultEdgeView defaultEdge;
    protected DefaultNodeView defaultNode;

    public GraphView() {
        this.selectedNodes = new HashMap();
        this.hiddenNodes = new HashMap();
        this.highlightedNodes = new HashMap();
        this.rules = new Vector();
        this.effect = new Effect();
        this.nodeListeners = new Vector();
        this.setTranslate(0.0, 0.0);
        this.setScale(1.0);
    }

    public GraphView(LayoutedGraph graph) {
        this();
        this.setGraph(graph);
    }

    public void setGraph(LayoutedGraph graph) {
        this.deselect();
        this.unHighlightAll();
        this.showAll();
        this.graph = graph;
        this.defaultEdge = graph.getDefaultEdgeView();
        this.defaultNode = graph.getDefaultNodeView();
        if (this.effect != null) {
            this.effect.setBounds(graph.getBounds());
        }
        for (Object o : graph.getAllNodes().values()) {
            NodeView node = (NodeView)o;
            node.setBounds(node.getPosX(), node.getPosY(), node.getSize());
            for (Rule rule : this.getRules()) {
                if (!rule.isEnabled()) continue;
                rule.applyRule(node);
            }
        }
        this.updateGraphView();
    }

    public LayoutedGraph getGraph() {
        return this.graph;
    }

    public void deselect(Node node) {
        Object nodeview = this.graph.getNodeView(node.getId());
        ((NodeView)nodeview).setSelected(false);
        this.selectedNodes.values().remove(nodeview);
    }

    public void select(Node node) {
        if (!this.isMultiselection()) {
            for (NodeView nodeview : this.selectedNodes.values()) {
                nodeview.setSelected(false);
            }
            this.selectedNodes.clear();
        }
        Object nodeview = this.graph.getNodeView(node.getId());
        ((NodeView)nodeview).setSelected(true);
        this.selectedNodes.put(node.getId(), (NodeView)nodeview);
    }

    public void select(ArrayList<Node> Nodes) {
        if (!this.isMultiselection()) {
            for (NodeView nodeview : this.selectedNodes.values()) {
                nodeview.setSelected(false);
            }
            this.selectedNodes.clear();
        }
        for (Node node : Nodes) {
            Object nodeview = this.graph.getNodeView(node.getId());
            ((NodeView)nodeview).setSelected(true);
            this.selectedNodes.put(node.getId(), (NodeView)nodeview);
        }
    }

    public boolean isSelected(Node node) {
        return this.selectedNodes.containsKey(node.getId());
    }

    public void deselect() {
        for (NodeView nodeview : this.selectedNodes.values()) {
            nodeview.setSelected(false);
        }
        this.selectedNodes.clear();
        this.updateGraphView();
    }

    public ArrayList<Node> getSelection() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Object id : this.selectedNodes.keySet()) {
            result.add(this.graph.getGraph().getNode(id));
        }
        return result;
    }

    public int getSelectionCount() {
        return this.selectedNodes.size();
    }

    public void setSelectionEnabled(boolean enabled) {
        this.selectionEnabled = enabled;
    }

    public boolean isMultiselection() {
        return this.multiselection;
    }

    public void setMultiselection(boolean multiSelection) {
        this.multiselection = multiSelection;
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void show(Node node) {
        Object nodeview = this.graph.getNodeView(node.getId());
        ((NodeView)nodeview).setHidden(false);
        this.hiddenNodes.values().remove(nodeview);
    }

    public void showAll() {
        for (NodeView nodeview : this.hiddenNodes.values()) {
            nodeview.setHidden(false);
        }
        this.hiddenNodes.values().clear();
        this.updateGraphView();
    }

    public void hideAll() {
        for (Object o : this.graph.getAllNodes().values()) {
            NodeView nodeview = (NodeView)o;
            this.hide(nodeview.getNode());
        }
        this.updateGraphView();
    }

    public void hide(Node node) {
        Object nodeview = this.graph.getNodeView(node.getId());
        ((NodeView)nodeview).setHidden(true);
        this.hiddenNodes.put(node.getId(), (NodeView)nodeview);
    }

    public void unHighlightAll() {
        for (NodeView nodeview : this.highlightedNodes.values()) {
            nodeview.setHighlighted(false);
        }
        this.highlightedNodes.clear();
        this.updateGraphView();
    }

    public void highlight(Node node) {
        Object nodeview = this.graph.getNodeView(node.getId());
        ((NodeView)nodeview).setHighlighted(true);
        this.highlightedNodes.put(node.getId(), (NodeView)nodeview);
        this.updateGraphView();
    }

    public void highlight(Collection<Node> nodes) {
        for (Node node : nodes) {
            Object nodeview = this.graph.getNodeView(node.getId());
            ((NodeView)nodeview).setHighlighted(true);
            this.highlightedNodes.put(node.getId(), (NodeView)nodeview);
        }
        this.updateGraphView();
    }

    public void centerGraph() {
        this.autozoom = true;
    }

    public void updateGraphView() {
    }

    public void updateGraphModel() {
        this.graph.updateModel();
    }

    public boolean isEdgeVisible() {
        return this.edgeVisible;
    }

    public void setEdgeVisible(boolean flag) {
        this.edgeVisible = flag;
        this.updateGraphView();
    }

    public void exportJPEG(String filename, float scale, boolean grayscale) {
    }

    public Component getComponent() {
        return null;
    }

    public void addRule(Rule filter) {
        this.rules.add(filter);
        if (this.graph != null) {
            this.setGraph(this.graph);
        }
    }

    public void removeRule(Rule filter) {
        this.rules.remove(filter);
    }

    public Vector<Rule> getRules() {
        return this.rules;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setScale(double scale) {
        this.scale = Math.max(0.05, scale);
        this.setTranslateX(this.getTranslateX());
        this.setTranslateY(this.getTranslateY());
    }

    public double getScale() {
        return this.scale;
    }

    public void setTranslateX(double translateX) {
        this.translateX = translateX;
    }

    public void setTranslateY(double translateY) {
        this.translateY = translateY;
    }

    public void setTranslate(double translateX, double translateY) {
        this.setTranslateX(translateX);
        this.setTranslateY(translateY);
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public boolean isMovingEnabled() {
        return this.movingEnabled;
    }

    public void setMovingEnabled(boolean movingEnabled) {
        this.movingEnabled = movingEnabled;
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public void setZoomEnabled(boolean zoomEnabled) {
        this.zoomEnabled = zoomEnabled;
    }

    public void setRules(Vector<Rule> rules) {
        this.rules = rules;
    }

    public void updateRules() {
        if (this.getGraph() != null) {
            for (Object o : this.getGraph().getAllNodes().values()) {
                NodeView node = (NodeView)o;
                node.reset(this.graph.getDefaultNodeView());
                for (Rule rule : this.getRules()) {
                    if (!rule.isEnabled()) continue;
                    rule.applyRule(node);
                }
            }
            this.updateGraphView();
        }
    }

    public void updateNodes(Set<Node> nodes) {
    }

    public void setCursor(int cursor) {
        this.getComponent().setCursor(Cursor.getPredefinedCursor(cursor));
    }

    public boolean removeNodeListener(NodeListener nodeListener) {
        return this.nodeListeners.remove(nodeListener);
    }

    public boolean addNodeListener(NodeListener nodeListener) {
        return this.nodeListeners.add(nodeListener);
    }

    public void fireNodeEvent(NodeEvent event) {
        for (NodeListener listener : this.nodeListeners) {
            listener.onNodeEvent(event);
        }
    }
}

