/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class ResizableFrame
extends JFrame
implements ResizableSupport {
    protected ResizablePanel _resizablePanel;
    private boolean _routingKeyStrokes;

    public ResizableFrame() throws HeadlessException {
        this.initComponents();
    }

    public ResizableFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initComponents();
    }

    public ResizableFrame(String title) throws HeadlessException {
        super(title);
        this.initComponents();
    }

    public ResizableFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initComponents();
    }

    protected void initComponents() {
        this.setUndecorated(true);
        this._resizablePanel = new ResizablePanel(){

            protected Resizable createResizable() {
                return new Resizable(this){

                    public void resizing(int resizeDir, int newX, int newY, int newW, int newH) {
                        Container container = ResizableFrame.this.getContentPane();
                        PortingUtils.setPreferredSize(container, new Dimension(newW, newH));
                        if (ResizableFrame.this.isUndecorated()) {
                            ResizableFrame.this.setBounds(newX, newY, newW, newH);
                        }
                        ResizableFrame.this.resizing();
                    }

                    public void beginResizing(int resizeCorner) {
                        super.beginResizing(resizeCorner);
                        ResizableFrame.this.beginResizing();
                    }

                    public void endResizing(int resizeCorner) {
                        super.endResizing(resizeCorner);
                        ResizableFrame.this.endResizing();
                    }

                    public boolean isTopLevel() {
                        return true;
                    }
                };
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                boolean processed = super.processKeyBinding(ks, e, condition, pressed);
                if (processed || e.isConsumed() || !ResizableFrame.this.isRoutingKeyStrokes()) {
                    return processed;
                }
                if (e.getSource() instanceof JComponent) {
                    Class<?> componentClass;
                    JRootPane rootPane = ((JComponent)e.getSource()).getRootPane();
                    for (componentClass = rootPane.getClass(); componentClass != JComponent.class && componentClass != null; componentClass = componentClass.getSuperclass()) {
                    }
                    try {
                        if (componentClass != null) {
                            Method m = componentClass.getDeclaredMethod("processKeyBinding", KeyStroke.class, KeyEvent.class, Integer.TYPE, Boolean.TYPE);
                            m.setAccessible(true);
                            processed = (Boolean)m.invoke((Object)rootPane, ks, e, 2, pressed);
                        }
                    }
                    catch (NoSuchMethodException e1) {
                        e1.printStackTrace();
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                }
                if (processed || e.isConsumed()) {
                    return processed;
                }
                Component routingParent = ResizableFrame.this.getRoutingComponent();
                if (routingParent == null) {
                    return false;
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(routingParent, e);
                return e.isConsumed();
            }
        };
        this.setContentPane(this._resizablePanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ResizableFrame.this._resizablePanel.setSize(ResizableFrame.this.getSize());
            }
        });
    }

    protected void beginResizing() {
    }

    protected void resizing() {
    }

    protected void endResizing() {
    }

    public void setBorder(Border border) {
        this._resizablePanel.setBorder(border);
    }

    public Border getBorder() {
        return this._resizablePanel.getBorder();
    }

    public Resizable getResizable() {
        return this._resizablePanel.getResizable();
    }

    public Component getRoutingComponent() {
        return this.getOwner();
    }

    public void setRoutingKeyStrokes(boolean routingKeyStrokes) {
        this._routingKeyStrokes = routingKeyStrokes;
    }

    public boolean isRoutingKeyStrokes() {
        return this._routingKeyStrokes;
    }
}

