/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.db;

public enum ColumnType {
    VARCHAR,
    BLOB,
    BOOLEAN,
    INTEGER,
    FLOAT,
    DECIMAL,
    DATE,
    TEXT,
    DATETIME,
    TIMESTAMP;


    public String toString() {
        switch (this) {
            case INTEGER: {
                return "int";
            }
            case BLOB: {
                return "blob";
            }
            case FLOAT: {
                return "float";
            }
            case BOOLEAN: {
                return "tinyint";
            }
            case VARCHAR: {
                return "varchar";
            }
            case DECIMAL: {
                return "decimal";
            }
            case DATE: {
                return "date";
            }
            case DATETIME: {
                return "datetime";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case TEXT: {
                return "text";
            }
        }
        throw new IllegalArgumentException("Invalid column type.");
    }

    public static ColumnType fromString(String typeNameSQL) {
        if ((typeNameSQL = typeNameSQL.toLowerCase()).contains("float")) {
            return FLOAT;
        }
        if (typeNameSQL.contains("boolean") || typeNameSQL.contains("int") && typeNameSQL.contains("(1)")) {
            return BOOLEAN;
        }
        if (typeNameSQL.contains("int")) {
            return INTEGER;
        }
        if (typeNameSQL.contains("varchar")) {
            return VARCHAR;
        }
        if (typeNameSQL.contains("blob")) {
            return BLOB;
        }
        if (typeNameSQL.contains("tinyint")) {
            return INTEGER;
        }
        if (typeNameSQL.contains("datetime")) {
            return DATE;
        }
        if (typeNameSQL.contains("decimal")) {
            return DECIMAL;
        }
        if (typeNameSQL.contains("date")) {
            return DATE;
        }
        if (typeNameSQL.contains("text")) {
            return TEXT;
        }
        if (typeNameSQL.contains("datetime")) {
            return DATETIME;
        }
        if (typeNameSQL.contains("timestamp")) {
            return TIMESTAMP;
        }
        throw new IllegalArgumentException("Unable to parse \"" + typeNameSQL + "\" as column type.");
    }

    public boolean isNumeric() {
        return this == INTEGER || this == FLOAT || this == DECIMAL;
    }

    public boolean isInt() {
        return this == INTEGER;
    }

    public boolean isFloat() {
        return this == FLOAT || this == DECIMAL;
    }

    public boolean isBoolean() {
        return this == BOOLEAN;
    }
}

