/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.format;

import java.io.Serializable;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;

public class AnnotationFormat
implements Serializable {
    public static final String ANNOTATION_FORMAT_DEFAULT = "VCF";
    public static final String ANNOTATION_FORMAT_CUSTOM_VCF = "VCF Info";
    private final String program;
    private final String version;
    private final String referenceName;
    private final String path;
    private final boolean hasRef;
    private final boolean hasAlt;
    private final CustomField[] fields;
    private final AnnotationType type;
    private final boolean isEndInclusive;

    public AnnotationFormat(String program, String version, String referenceName, String path, boolean hasRef, boolean hasAlt, AnnotationType type, boolean isEndInclusive, CustomField[] fields) {
        this.program = program;
        this.version = version;
        this.referenceName = referenceName;
        this.path = path;
        this.hasRef = hasRef;
        this.hasAlt = hasAlt;
        this.fields = fields;
        this.type = type;
        this.isEndInclusive = isEndInclusive;
    }

    public int getNumNonDefaultFields() {
        return this.fields.length;
    }

    public boolean hasRef() {
        return this.hasRef;
    }

    public boolean hasAlt() {
        return this.hasAlt;
    }

    public CustomField[] getCustomFields() {
        return this.fields;
    }

    public String getProgram() {
        return this.program;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public AnnotationType getType() {
        return this.type;
    }

    public boolean isEndInclusive() {
        return this.isEndInclusive;
    }

    public String toString() {
        return "AnnotationFormat{program=" + this.program + ", version=" + this.version + ", referenceName=" + this.referenceName + ", path=" + this.path + ", hasRef=" + this.hasRef + ", hasAlt=" + this.hasAlt + ", fields=" + this.fields + ", type=" + (Object)((Object)this.type) + ", isEndInclusive=" + this.isEndInclusive + '}';
    }

    public static AnnotationFormat getDefaultAnnotationFormat() {
        return new AnnotationFormat(ANNOTATION_FORMAT_DEFAULT, ANNOTATION_FORMAT_DEFAULT, "0", "", true, true, AnnotationType.POSITION, false, BasicVariantColumns.REQUIRED_VARIANT_FIELDS);
    }

    public static AnnotationFormat getCustomFieldAnnotationFormat(CustomField[] customFields) {
        return new AnnotationFormat(ANNOTATION_FORMAT_CUSTOM_VCF, ANNOTATION_FORMAT_CUSTOM_VCF, "0", "", true, true, AnnotationType.POSITION, false, customFields);
    }

    public static enum AnnotationType {
        POSITION,
        INTERVAL;


        public static AnnotationType fromInt(int type) {
            switch (type) {
                case 0: {
                    return POSITION;
                }
                case 1: {
                    return INTERVAL;
                }
            }
            return null;
        }

        public static int toInt(AnnotationType type) {
            switch (type) {
                case POSITION: {
                    return 0;
                }
                case INTERVAL: {
                    return 1;
                }
            }
            return -1;
        }

        public static AnnotationType fromString(String s) {
            if (s.toLowerCase().equals("interval")) {
                return INTERVAL;
            }
            return POSITION;
        }

        public String toString() {
            switch (this) {
                case POSITION: {
                    return "Position";
                }
                case INTERVAL: {
                    return "Interval";
                }
            }
            return "";
        }
    }
}

