/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.model;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.ut.biolab.medsavant.shared.model.OntologyType;

public class OntologyTerm
implements Serializable,
Comparable<OntologyTerm> {
    private final OntologyType ontology;
    private final String id;
    private final String name;
    private final String def;
    private final String[] altIDs;
    private final String[] parentIDs;

    public OntologyTerm(OntologyType ontology, String id, String name, String def, String[] altIDs, String[] parentIDs) {
        this.ontology = ontology;
        this.id = id;
        this.name = name;
        this.def = def;
        this.altIDs = altIDs;
        this.parentIDs = parentIDs;
    }

    @Override
    public int compareTo(OntologyTerm t) {
        int c = this.ontology.name().compareTo(t.ontology.name());
        if (c == 0) {
            return this.id.compareTo(t.id);
        }
        return c;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.ontology != null ? this.ontology.hashCode() : 0);
        hash = 41 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof OntologyTerm) {
            OntologyTerm t = (OntologyTerm)o;
            if (this.id == null || t.id == null || this.ontology == null || t.ontology == null) {
                System.out.println("How did I get null?");
            }
            return this.id.equals(t.id) && this.ontology.equals((Object)t.ontology);
        }
        return false;
    }

    public String toString() {
        return this.id + " " + this.name;
    }

    public OntologyType getOntology() {
        return this.ontology;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDef() {
        return this.def;
    }

    public String[] getAltIDs() {
        return this.altIDs;
    }

    public String[] getParentIDs() {
        return this.parentIDs;
    }

    public OntologyTerm[] getChildren(OntologyTerm[] allTerms) {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        block0: for (OntologyTerm t : allTerms) {
            if (t.parentIDs == null) continue;
            for (String parent : t.parentIDs) {
                if (!parent.equals(this.id)) continue;
                result.add(t);
                continue block0;
            }
        }
        return result.toArray(new OntologyTerm[0]);
    }

    public URL getInfoURL() throws MalformedURLException {
        switch (this.ontology) {
            case GO: {
                return new URL("http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=" + this.id);
            }
            case HPO: {
                return new URL("http://www.human-phenotype-ontology.org/hpoweb/showterm?id=" + this.id);
            }
            case OMIM: {
                return new URL("http://omim.org/entry/" + this.id.substring(4));
            }
        }
        return null;
    }
}

