/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.model;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Range
implements Comparable<Range>,
Serializable {
    private static final Log LOG = LogFactory.getLog(Range.class);
    private static final String RANGE_STRING = " - ";
    private double min;
    private double max;

    public Range(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public Range(double[] rangeArray) {
        this.min = rangeArray[0];
        this.max = rangeArray[1];
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public static List<Range> merge(Collection<Range> range) {
        ArrayList<Range> mergedList = new ArrayList<Range>();
        TreeSet<Range> allRangesInOrder = new TreeSet<Range>();
        allRangesInOrder.addAll(range);
        Range curMerged = null;
        for (Range r : allRangesInOrder) {
            if (curMerged != null && curMerged.canBeMergedWith(r)) {
                curMerged.max = Math.max(curMerged.max, r.max);
                curMerged.min = Math.min(curMerged.min, r.min);
                continue;
            }
            if (curMerged != null) {
                mergedList.add(curMerged);
            }
            curMerged = new Range(r.min, r.max);
        }
        if (curMerged != null) {
            mergedList.add(curMerged);
        }
        return mergedList;
    }

    @Override
    public int compareTo(Range range) {
        if (this.min < range.min) {
            return -1;
        }
        if (this.min > range.min) {
            return 1;
        }
        if (this.max < range.max) {
            return -1;
        }
        if (this.max > range.max) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (that instanceof Range) {
            Range r = (Range)that;
            return r.min == this.min && r.max == this.max;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.min) ^ Double.doubleToLongBits(this.min) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.max) ^ Double.doubleToLongBits(this.max) >>> 32);
        return hash;
    }

    public boolean canBeMergedWith(Range r) {
        return this.min <= r.max && this.max >= r.min;
    }

    public String toString() {
        return NumberFormat.getInstance().format(this.min) + RANGE_STRING + NumberFormat.getInstance().format(this.max);
    }

    public static Range rangeFromString(String range) {
        String[] values = range.split(RANGE_STRING);
        double minValue = 0.0;
        double maxValue = 0.0;
        try {
            minValue = NumberFormat.getInstance().parse(values[0]).doubleValue();
            maxValue = NumberFormat.getInstance().parse(values[1]).doubleValue();
        }
        catch (ParseException ex) {
            LOG.error((Object)("Unable to parse " + range + " as a range."), (Throwable)ex);
        }
        return new Range(minValue, maxValue);
    }

    public void bound(int min, int max, boolean defaultMin) {
        if (this.min > this.max) {
            if (defaultMin) {
                this.max = this.min;
            } else {
                this.min = this.max;
            }
        }
        if (this.min < (double)min || this.min > (double)max) {
            this.min = Math.min((double)max, Math.max((double)min, this.min));
        }
        if (this.max > (double)max || this.max < (double)min) {
            this.max = Math.max((double)min, Math.min((double)max, this.max));
        }
    }
}

