/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.samtools.util.SeekableBufferedStream;
import net.sf.samtools.util.SeekableFileStream;
import net.sf.samtools.util.SeekableHTTPStream;
import net.sf.samtools.util.SeekableStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import org.ut.biolab.medsavant.shared.util.SeekableFTPStream;

public class NetworkUtils {
    private static final Log LOG = LogFactory.getLog(NetworkUtils.class);
    public static final int CONNECT_TIMEOUT = 30000;
    public static final int READ_TIMEOUT = 30000;
    public static final int NONCRITICAL_CONNECT_TIMEOUT = 5000;
    public static final int NONCRITICAL_READ_TIMEOUT = 5000;
    public static final int BUF_SIZE = 8192;
    public static final boolean ALLOW_URL_REDIRECTS = true;

    public static InputStream openStream(URL url) throws IOException {
        return NetworkUtils.openStream(url, 30000, 30000);
    }

    public static InputStream openStream(URL url, int connectTimeout, int readTimeout) throws IOException, SocketTimeoutException {
        HttpURLConnection huc = (HttpURLConnection)url.openConnection();
        HttpURLConnection.setFollowRedirects(true);
        huc.setConnectTimeout(connectTimeout);
        huc.setReadTimeout(readTimeout);
        huc.setRequestMethod("GET");
        huc.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 (.NET CLR 3.5.30729)");
        huc.connect();
        InputStream input = huc.getInputStream();
        return input;
    }

    public static URL getKnownGoodURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ignored) {
            throw new IllegalArgumentException();
        }
    }

    public static URL getKnownGoodURL(URL base, String spec) {
        try {
            String baseStr = base.toString();
            if (!baseStr.endsWith("/")) {
                baseStr = baseStr + "/";
            }
            return new URL(baseStr + spec);
        }
        catch (MalformedURLException ignored) {
            throw new IllegalArgumentException();
        }
    }

    public static File downloadFile(URL u, File destDir, String fileName) throws IOException {
        int bytesRead;
        File f = new File(destDir, fileName != null ? fileName : MiscUtils.getFilenameFromPath(u.getPath()));
        LOG.info((Object)("Downloading file " + u + " into directory " + f.getAbsolutePath()));
        InputStream in = NetworkUtils.openStream(u);
        FileOutputStream out = new FileOutputStream(f);
        byte[] buf = new byte[8192];
        int totalRead = 0;
        while ((bytesRead = in.read(buf)) != -1) {
            ((OutputStream)out).write(buf, 0, bytesRead);
            totalRead += bytesRead;
        }
        in.close();
        ((OutputStream)out).close();
        LOG.info((Object)("Downloaded " + totalRead + " bytes"));
        return f;
    }

    public static String downloadFile(URL u) throws IOException {
        int bytesRead;
        StringBuilder result = new StringBuilder();
        InputStream in = NetworkUtils.openStream(u);
        byte[] buf = new byte[8192];
        while ((bytesRead = in.read(buf)) != -1) {
            char[] r = new String(buf).toCharArray();
            result.append(r, 0, bytesRead);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHash(URL url) throws IOException {
        String proto = url.getProtocol().toLowerCase();
        if (proto.equals("http") || proto.equals("https")) {
            URLConnection conn = null;
            try {
                conn = url.openConnection();
                String string = conn.getHeaderField("ETag");
                return string;
            }
            finally {
                if (conn != null && conn instanceof HttpURLConnection) {
                    ((HttpURLConnection)conn).disconnect();
                }
            }
        }
        if (proto.equals("ftp")) {
            SeekableFTPStream ftp = new SeekableFTPStream(url, "anonymous", "");
            try {
                FTPFile[] files = ftp.listFiles(url.getFile());
                if (files.length > 0) {
                    String string = String.format("%016x-%016x", files[0].getTimestamp().getTimeInMillis(), files[0].getSize());
                    return string;
                }
                throw new IOException("URL not found: " + url);
            }
            finally {
                ftp.close();
            }
        }
        if (proto.equals("file")) {
            try {
                File f = new File(url.toURI());
                return String.format("%016x-%016x", f.lastModified(), f.length());
            }
            catch (URISyntaxException x) {
                throw new IllegalArgumentException("Invalid argument; cannot parse " + url + " as a file.");
            }
        }
        throw new IllegalArgumentException("Invalid argument; cannot get hash for " + proto + " URLs.");
    }

    public static SeekableStream getSeekableStreamForURI(URI uri) throws IOException {
        SeekableHTTPStream result;
        String proto = uri.getScheme().toLowerCase();
        if (proto.equals("file")) {
            result = new SeekableBufferedStream((SeekableStream)new SeekableFileStream(new File(uri)));
        } else {
            if (!proto.equals("http") && !proto.equals("https")) {
                throw new IOException("Unknown URI scheme " + uri.toString());
            }
            result = new SeekableHTTPStream(uri.toURL());
            result = new SeekableBufferedStream((SeekableStream)result);
        }
        return result;
    }

    static {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

