/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import java.awt.geom.Point2D;
import java.util.List;
import org.apache.commons.math.linear.RealMatrixImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolynomialFitter
implements CurveFitter {
    private int a;

    public PolynomialFitter(int n) {
        this.setOrder(n);
    }

    public void setOrder(int n) {
        block5: {
            int n2;
            block4: {
                n2 = b;
                if (Polynomial.b != 0) break block4;
                if (n2 != 0) break block5;
                n2 = n;
            }
            if (n2 < 0) {
                throw new AssertionError();
            }
        }
        this.a = n;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        double d2;
        int n;
        int n2;
        double[][] dArray;
        int n3;
        block4: {
            n3 = Polynomial.b;
            dArray = new double[this.a + 1][this.a + 1];
            int n4 = 0;
            while (n4 <= this.a) {
                block5: {
                    n2 = 0;
                    if (n3 != 0) break block4;
                    for (n = v132850; n <= this.a; ++n) {
                        dArray[n4][n] = d2 = this.a(chartModel, n4 + n, 0);
                        if (n3 == 0) {
                            if (n3 == 0) continue;
                        }
                        break block5;
                    }
                    ++n4;
                }
                if (n3 == 0) continue;
            }
            n2 = this.a + 1;
        }
        double[] dArray2 = new double[n2];
        for (n = 0; n <= this.a; ++n) {
            dArray2[n] = d2 = this.a(chartModel, n, 1);
            if (n3 == 0) continue;
        }
        RealMatrixImpl realMatrixImpl = new RealMatrixImpl(dArray);
        double[] dArray3 = realMatrixImpl.solve(dArray2);
        return new Polynomial(dArray3);
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, range, n);
    }

    @Override
    public AnnotatedChartModel createModel(Polynomial polynomial, Range<?> range, int n) {
        return this.createModel(null, polynomial, range, n);
    }

    @Override
    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n) {
        DefaultChartModel defaultChartModel;
        block2: {
            int n2 = Polynomial.b;
            double d2 = range.minimum();
            double d3 = range.maximum();
            DefaultChartModel defaultChartModel2 = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
            double d4 = (d3 - d2) / (double)(n - 1);
            for (int i2 = 0; i2 < n; ++i2) {
                double d5 = d2 + (double)i2 * d4;
                double d6 = polynomial.eval(d5);
                defaultChartModel = defaultChartModel2.addPoint(d5, d6);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            defaultChartModel = defaultChartModel2;
        }
        return defaultChartModel;
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel;
        block2: {
            int n = Polynomial.b;
            DefaultChartModel defaultChartModel2 = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
            for (int i2 = 0; i2 < doubleArray.length; ++i2) {
                double d2 = doubleArray[i2];
                double d3 = polynomial.eval(d2);
                defaultChartModel = defaultChartModel2.addPoint(d2, d3);
                if (n == 0) {
                    if (n == 0) continue;
                }
                break block2;
            }
            defaultChartModel = defaultChartModel2;
        }
        return defaultChartModel;
    }

    public Polynomial performRegression(List<? extends Point2D> list) {
        throw new UnsupportedOperationException();
    }

    private double a(ChartModel chartModel, int n, int n2) {
        double d2;
        block2: {
            int n3 = Polynomial.b;
            double d3 = 0.0;
            for (Chartable chartable : chartModel) {
                d2 = d3 + Math.pow(chartable.getX().position(), n) * Math.pow(chartable.getY().position(), n2);
                if (n3 == 0) {
                    d3 = d2;
                    if (n3 == 0) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }
}

