/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.JideTable;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class SpinnerCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor,
ChangeListener {
    public static EditorContext CONTEXT = new EditorContext("Spinner");
    protected JSpinner _spinner;
    private static final long serialVersionUID = -2261305860140664189L;

    public SpinnerCellEditor() {
        this(new SpinnerNumberModel());
    }

    public SpinnerCellEditor(SpinnerModel spinnerModel) {
        this.setAutoStopCellEditing(false);
        this._spinner = this.createSpinner(spinnerModel);
    }

    protected void customizeSpinner() {
        this._spinner.setOpaque(false);
        this._spinner.setBorder(DEFAULT_CELL_EDITOR_BORDER);
    }

    protected JSpinner createSpinner(SpinnerModel spinnerModel) {
        JSpinner jSpinner = new JSpinner(spinnerModel){

            protected JComponent createEditor(SpinnerModel spinnerModel) {
                int n2 = JideTable.jb;
                boolean bl = spinnerModel instanceof SpinnerDateModel;
                if (n2 == 0) {
                    if (bl) {
                        return new JSpinner.DateEditor(this){

                            public void stateChanged(ChangeEvent changeEvent) {
                                block3: {
                                    1 v0;
                                    block2: {
                                        v0 = this;
                                        if (JideTable.jb != 0) break block2;
                                        if (v0.SpinnerCellEditor.this.getEditorStyle() == 2) break block3;
                                        v0 = this;
                                    }
                                    super.stateChanged(changeEvent);
                                }
                            }
                        };
                    }
                    bl = spinnerModel instanceof SpinnerListModel;
                }
                if (n2 == 0) {
                    if (bl) {
                        return new JSpinner.ListEditor(this){

                            public void stateChanged(ChangeEvent changeEvent) {
                                block3: {
                                    3 v0;
                                    block2: {
                                        v0 = this;
                                        if (JideTable.jb != 0) break block2;
                                        if (v0.SpinnerCellEditor.this.getEditorStyle() == 2) break block3;
                                        v0 = this;
                                    }
                                    super.stateChanged(changeEvent);
                                }
                            }
                        };
                    }
                    bl = spinnerModel instanceof SpinnerNumberModel;
                }
                if (bl) {
                    return new JSpinner.NumberEditor(this){

                        public void stateChanged(ChangeEvent changeEvent) {
                            block3: {
                                4 v0;
                                block2: {
                                    v0 = this;
                                    if (JideTable.jb != 0) break block2;
                                    if (v0.SpinnerCellEditor.this.getEditorStyle() == 2) break block3;
                                    v0 = this;
                                }
                                super.stateChanged(changeEvent);
                            }
                        }
                    };
                }
                return new JSpinner.DefaultEditor(this){

                    public void stateChanged(ChangeEvent changeEvent) {
                        block3: {
                            2 v0;
                            block2: {
                                v0 = this;
                                if (JideTable.jb != 0) break block2;
                                if (v0.SpinnerCellEditor.this.getEditorStyle() == 2) break block3;
                                v0 = this;
                            }
                            super.stateChanged(changeEvent);
                        }
                    }
                };
            }
        };
        SpinnerWheelSupport.installMouseWheelSupport((JSpinner)jSpinner);
        return jSpinner;
    }

    public Object getCellEditorValue() {
        try {
            this._spinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this._spinner.getValue();
    }

    public void setCellEditorValue(Object object) {
        this._spinner.setValue(object);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        JSpinner jSpinner;
        block14: {
            SpinnerCellEditor spinnerCellEditor;
            block16: {
                block15: {
                    int n4;
                    block13: {
                        SpinnerCellEditor spinnerCellEditor2;
                        block11: {
                            block12: {
                                JTable jTable2;
                                block10: {
                                    n4 = JideTable.jb;
                                    jTable2 = jTable;
                                    if (n4 != 0) break block10;
                                    if (jTable2 != null) {
                                        this.customizeSpinner();
                                        JideSwingUtilities.installColorsAndFont((Component)this._spinner, (Color)jTable.getBackground(), (Color)jTable.getForeground(), (Font)jTable.getFont());
                                    }
                                    spinnerCellEditor2 = this;
                                    if (n4 != 0) break block11;
                                    spinnerCellEditor2.setCellEditorValue(object);
                                    jTable2 = jTable;
                                }
                                if (jTable2 == null) break block12;
                                jSpinner = this.getSpinner();
                                if (n4 != 0) break block13;
                                if (jSpinner != null) {
                                    this.getSpinner().addChangeListener(this);
                                }
                            }
                            spinnerCellEditor2 = this;
                        }
                        jSpinner = spinnerCellEditor2.getSpinner();
                    }
                    if (n4 != 0) break block14;
                    if (jSpinner == null) break block15;
                    jSpinner = this.getSpinner();
                    if (n4 != 0) break block14;
                    if (!(jSpinner.getEditor() instanceof JSpinner.DefaultEditor)) break block15;
                    jSpinner = this.getSpinner();
                    if (n4 != 0) break block14;
                    JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField();
                    if (jFormattedTextField == null) break block15;
                    spinnerCellEditor = this;
                    if (n4 != 0) break block16;
                    if (spinnerCellEditor.getEditorStyle() != 0) {
                        boolean bl2 = this.getEditorStyle();
                        if (n4 == 0) {
                            bl2 = bl2;
                        }
                        jFormattedTextField.setEditable(bl2);
                    }
                }
                spinnerCellEditor = this;
            }
            jSpinner = spinnerCellEditor._spinner;
        }
        return jSpinner;
    }

    public JSpinner getSpinner() {
        return this._spinner;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        block3: {
            JSpinner jSpinner;
            block4: {
                SpinnerCellEditor spinnerCellEditor;
                int n2;
                block2: {
                    n2 = JideTable.jb;
                    spinnerCellEditor = this;
                    if (n2 != 0) break block2;
                    if (!spinnerCellEditor.isAutoStopCellEditing()) break block3;
                    spinnerCellEditor = this;
                }
                jSpinner = spinnerCellEditor.getSpinner();
                if (n2 != 0) break block4;
                if (jSpinner == null) break block3;
                jSpinner = this.getSpinner();
            }
            jSpinner.removeChangeListener(this);
            this.stopCellEditing();
        }
    }

    public boolean isEditorStyleSupported(int n2) {
        return true;
    }
}

