/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.Metadata;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.IConfiguration;
import org.genemania.plugin.data.Version;
import org.genemania.plugin.selection.NetworkSelectionManager;
import org.genemania.plugin.task.GeneManiaTask;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.DownloadDialog;
import org.genemania.plugin.view.components.WrappedOptionPane;
import org.genemania.plugin.view.util.FileSelectionMode;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.util.ChildProgressReporter;
import org.genemania.util.ProgressReporter;
import org.xml.sax.SAXException;

public abstract class AbstractGeneMania<NETWORK, NODE, EDGE>
implements GeneMania<NETWORK, NODE, EDGE> {
    protected static final String SETTINGS_DIRECTORY = "genemania_plugin";
    public static final String RELEASE_VERSION = "releaseVersion";
    public static final String MIN_DATA_VERSION = "minDataVersion";
    public static final String BUILD_NUMBER = "buildNumber";
    protected Component rootMenuItem;
    protected JMenuItem showResultsMenu;
    protected final NetworkSelectionManager<NETWORK, NODE, EDGE> selectionManager;
    protected final Metadata metadata;
    protected final UiUtils uiUtils;
    protected final DataSetManager dataSetManager;
    protected final FileUtils fileUtils;
    protected final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    protected final NetworkUtils networkUtils;
    protected final TaskDispatcher taskDispatcher;

    protected abstract void startUp();

    protected abstract void shutDown();

    public AbstractGeneMania(DataSetManager dataSetManager, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, UiUtils uiUtils, FileUtils fileUtils, NetworkUtils networkUtils, TaskDispatcher taskDispatcher) {
        this.dataSetManager = dataSetManager;
        this.cytoscapeUtils = cytoscapeUtils;
        this.uiUtils = uiUtils;
        this.fileUtils = fileUtils;
        this.networkUtils = networkUtils;
        this.taskDispatcher = taskDispatcher;
        this.metadata = new Metadata();
        this.selectionManager = new NetworkSelectionManager<NETWORK, NODE, EDGE>(this, cytoscapeUtils);
    }

    public static File getSettingsDirectory() {
        File settingsDirectory;
        String path = System.getProperty("genemania.plugin.settings");
        if (path == null) {
            FileSystemView view = FileSystemView.getFileSystemView();
            File defaultDirectory = view.getDefaultDirectory();
            path = defaultDirectory.getPath();
        }
        if (!(settingsDirectory = new File(String.format("%s%s%s", path, File.separator, SETTINGS_DIRECTORY))).exists()) {
            settingsDirectory.mkdirs();
        }
        return settingsDirectory;
    }

    public String getVersion() {
        return "1.1";
    }

    @Override
    public DataSetManager getDataSetManager() {
        return this.dataSetManager;
    }

    public void setDataSet(DataSet data, ProgressReporter progress) {
        if (data != null && !this.isCompatible(data.getVersion()) && WrappedOptionPane.showConfirmDialog((Component)this.taskDispatcher.getTaskDialog(), Strings.incompatibleData_prompt, Strings.default_title, 0, 3, 40) == 1) {
            return;
        }
        this.dataSetManager.setDataSet(data, progress);
    }

    private boolean isCompatible(Version version) {
        String minVersion = this.metadata.getConfigProperty(MIN_DATA_VERSION);
        if (minVersion == null) {
            return true;
        }
        return version.getBaseVersion().compareTo(minVersion) >= 0;
    }

    @Override
    public void handleCheck() {
        final boolean[] requiresConfiguration = new boolean[1];
        GeneManiaTask task = new GeneManiaTask(Strings.dataUpdateCheck_title){

            @Override
            protected void runTask() throws Throwable {
                requiresConfiguration[0] = AbstractGeneMania.this.checkForUpdates(this.progress);
            }
        };
        this.taskDispatcher.executeTask(task, this.uiUtils.getFrame(this.cytoscapeUtils.getFrame()), true, true);
        this.handleConfiguration(requiresConfiguration[0]);
    }

    @Override
    public void handleSwitch() {
        try {
            this.chooseDataSet(this.cytoscapeUtils.getFrame());
        }
        catch (ApplicationException e) {
            LogUtils.log(this.getClass(), e);
        }
    }

    @Override
    public void handleDownload() {
        final boolean[] requiresConfiguration = new boolean[1];
        GeneManiaTask task = new GeneManiaTask(Strings.dataUpdateDownload_title){

            @Override
            protected void runTask() throws Throwable {
                requiresConfiguration[0] = AbstractGeneMania.this.showDownloadDialog(this.progress);
            }
        };
        this.taskDispatcher.executeTask(task, this.cytoscapeUtils.getFrame(), true, true);
        this.handleConfiguration(requiresConfiguration[0]);
    }

    private void handleConfiguration(boolean requiresConfiguration) {
        DataSet data = this.dataSetManager.getDataSet();
        if (data == null || !requiresConfiguration) {
            return;
        }
        IConfiguration configuration = data.getConfiguration();
        if (configuration.hasUi()) {
            configuration.showUi(this.cytoscapeUtils.getFrame());
        }
    }

    private boolean showDownloadDialog(ProgressReporter progress) throws ApplicationException {
        DownloadDialog dialog = new DownloadDialog(this.taskDispatcher.getTaskDialog(), Strings.default_title, true, Strings.dataUpdateDownload_label, this.dataSetManager, this.uiUtils, this.fileUtils);
        dialog.setVisible(true);
        String dataId = dialog.getSelectedDataSetId();
        DownloadDialog.Action action = dialog.getAction();
        if (dataId != null && action == DownloadDialog.Action.download) {
            File settings = AbstractGeneMania.getSettingsDirectory();
            this.downloadDataSet(dataId, settings, progress);
            return true;
        }
        if (dataId != null && action == DownloadDialog.Action.select) {
            File path = this.findDataSetById(dataId);
            this.loadDataSet(path, progress, false, true);
        }
        return false;
    }

    protected File findDataSetById(String dataId) {
        Pattern pattern = Pattern.compile(".*?gmdata-(.*?)");
        List<File> paths = this.dataSetManager.getDataSetPaths();
        for (File file : paths) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.matches() || !matcher.group(1).equals(dataId)) continue;
            return file;
        }
        return null;
    }

    protected void validateMenu() {
        NetworkSelectionManager<NETWORK, NODE, EDGE> manager = this.getNetworkSelectionManager();
        this.showResultsMenu.setEnabled(manager.isGeneManiaNetwork(this.cytoscapeUtils.getCurrentNetwork()));
    }

    public boolean checkForUpdates(ProgressReporter progress) throws ApplicationException {
        try {
            List<String> dataSets = this.fileUtils.getCompatibleDataSets("http://www.genemania.org/plugin", "1.1");
            if (dataSets.size() == 0) {
                throw new ApplicationException(Strings.checkForUpdates_error);
            }
            String url = dataSets.get(0);
            String[] parts = url.split("/");
            String dataId = parts[parts.length - 1];
            Pattern pattern = Pattern.compile("gmdata-(.*)");
            Matcher matcher = pattern.matcher(dataId);
            if (!matcher.matches()) {
                throw new ApplicationException(Strings.checkForUpdates_error);
            }
            Version version = Version.parse(matcher.group(1));
            DataSet dataSet = this.dataSetManager.getDataSet();
            if (dataSet == null) {
                ChildProgressReporter childProgress = new ChildProgressReporter(progress);
                this.initializeData(this.cytoscapeUtils.getFrame(), (ProgressReporter)childProgress, false);
                childProgress.close();
            }
            File latestDataSet = null;
            for (File path : this.dataSetManager.getDataSetPaths()) {
                Version otherVersion;
                matcher = pattern.matcher(path.getName());
                if (!matcher.matches() || !version.isEquivalentTo(otherVersion = Version.parse(matcher.group(1)))) continue;
                latestDataSet = path;
                break;
            }
            if (latestDataSet != null || dataSet != null && dataSet.getVersion().isEquivalentTo(version)) {
                JOptionPane.showMessageDialog(this.taskDispatcher.getTaskDialog(), Strings.checkForUpdatesOk_label, Strings.checkForUpdates_title, 1);
                if (dataSet == null) {
                    this.loadDataSet(latestDataSet, progress, false, false);
                }
                return false;
            }
            return this.showDownloadDialog(progress);
        }
        catch (IOException e) {
            throw new ApplicationException(String.format(Strings.checkForUpdates_error2, e.getMessage()), (Throwable)e);
        }
    }

    public void downloadDataSet(String dataId, File path, ProgressReporter progress) throws ApplicationException {
        try {
            String baseUrl;
            if (dataId == null) {
                List<String> dataSets = this.fileUtils.getCompatibleDataSets("http://www.genemania.org/plugin", "1.1");
                if (dataSets.size() == 0) {
                    throw new ApplicationException(Strings.checkForUpdates_error);
                }
                baseUrl = dataSets.get(0);
            } else {
                baseUrl = this.fileUtils.findDataSetBaseUrl("http://www.genemania.org/plugin", dataId);
            }
            URL url = new URL(String.format("%s.zip", baseUrl));
            File dataZipFile = this.fileUtils.download(url, path, progress);
            if (dataZipFile == null) {
                return;
            }
            File dataPath = this.unzipDataSet(dataZipFile, progress);
            dataZipFile.delete();
            this.loadDataSet(dataPath, progress, false, true);
        }
        catch (IOException e) {
            throw new ApplicationException(String.format(Strings.downloadData_error, e.getMessage()), (Throwable)e);
        }
    }

    private File unzipDataSet(File path, ProgressReporter progress) throws IOException {
        this.fileUtils.unzip(path, path.getParentFile(), progress);
        String fileName = path.getName();
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            fileName = fileName.substring(0, index);
        }
        return new File(String.format("%s%s%s", path.getParent(), File.separator, fileName));
    }

    public void chooseDataSet(Container parent) throws ApplicationException {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("xml");
        File dataSourcePath = this.dataSetManager.getDataSourcePath();
        File initialFile = dataSourcePath != null && dataSourcePath.exists() ? dataSourcePath : this.fileUtils.getUserHome();
        File path = this.uiUtils.getFile(parent, Strings.changeData_title, initialFile, "genemania.xml", extensions, FileSelectionMode.OPEN_FILE);
        if (path == null) {
            return;
        }
        if ("genemania.xml".equals(path.getName())) {
            path = path.getParentFile();
        }
        final File dataPath = path;
        GeneManiaTask task = new GeneManiaTask(Strings.loadData_title){

            @Override
            protected void runTask() throws Throwable {
                AbstractGeneMania.this.loadDataSet(dataPath, this.progress, false, true);
            }
        };
        this.taskDispatcher.executeTask(task, this.uiUtils.getFrame(parent), true, true);
        LogUtils.log(this.getClass(), task.getLastError());
    }

    @Override
    public void loadDataSet(File path, ProgressReporter progress, boolean promptToUpdate, boolean reportErrors) throws ApplicationException {
        block7: {
            try {
                if (path == null) {
                    this.setDataSet(null, progress);
                    break block7;
                }
                DataSet loadedData = this.dataSetManager.open(path);
                if (!this.isCompatible(loadedData.getVersion()) && promptToUpdate) {
                    try {
                        if (WrappedOptionPane.showConfirmDialog((Component)this.taskDispatcher.getTaskDialog(), Strings.incompatibleData2_prompt, Strings.default_title, 0, 3, 40) == 0) {
                            File settings = AbstractGeneMania.getSettingsDirectory();
                            this.downloadDataSet(null, settings, progress);
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        this.setDataSet(null, progress);
                    }
                    break block7;
                }
                this.setDataSet(loadedData, progress);
            }
            catch (SAXException e) {
                if (!reportErrors) break block7;
                WrappedOptionPane.showConfirmDialog((Component)this.taskDispatcher.getTaskDialog(), String.format(Strings.loadData_error, path.getPath()), Strings.loadData_title, -1, 0, 40);
            }
        }
    }

    @Override
    public NetworkSelectionManager<NETWORK, NODE, EDGE> getNetworkSelectionManager() {
        return this.selectionManager;
    }

    @Override
    public boolean initializeData(ProgressReporter progress, boolean reportErrors) throws ApplicationException {
        File path = this.dataSetManager.getDataSourcePath();
        if (path == null || !path.exists()) {
            List<File> paths = this.dataSetManager.getDataSetPaths();
            if (paths.size() == 0) {
                DownloadDialog dialog = new DownloadDialog(this.taskDispatcher.getTaskDialog(), Strings.default_title, true, Strings.missingData_prompt, this.dataSetManager, this.uiUtils, this.fileUtils);
                dialog.setVisible(true);
                String dataId = dialog.getSelectedDataSetId();
                if (dataId != null) {
                    File settings = AbstractGeneMania.getSettingsDirectory();
                    this.downloadDataSet(dataId, settings, progress);
                    return true;
                }
                this.loadDataSet(null, progress, false, false);
            } else {
                this.loadDataSet(paths.get(0), progress, true, reportErrors);
            }
        } else {
            this.loadDataSet(path, progress, true, reportErrors);
        }
        return false;
    }

    @Override
    public void initializeData(Window parent, final boolean reportErrors) {
        final boolean[] requiresConfiguration = new boolean[1];
        GeneManiaTask task = new GeneManiaTask(Strings.loadData_title){

            @Override
            protected void runTask() throws Throwable {
                requiresConfiguration[0] = AbstractGeneMania.this.initializeData(this.progress, reportErrors);
            }
        };
        this.taskDispatcher.executeTask(task, this.uiUtils.getFrame(parent), true, true);
        LogUtils.log(this.getClass(), task.getLastError());
        if (requiresConfiguration[0]) {
            DataSet data = this.dataSetManager.getDataSet();
            if (data == null) {
                return;
            }
            IConfiguration config = data.getConfiguration();
            if (config.hasUi()) {
                config.showUi(parent);
            }
        }
    }

    public void initializeData(Window parent, ProgressReporter progress, boolean reportErrors) throws ApplicationException {
        boolean requiresConfiguration = this.initializeData(progress, reportErrors);
        if (requiresConfiguration) {
            DataSet data = this.dataSetManager.getDataSet();
            if (data == null) {
                return;
            }
            IConfiguration config = data.getConfiguration();
            if (config.hasUi()) {
                config.showUi(parent);
            }
        }
    }
}

