/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneData;
import org.genemania.domain.Interaction;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.domain.Node;
import org.genemania.domain.OntologyCategory;
import org.genemania.domain.Organism;
import org.genemania.domain.Tag;
import org.genemania.dto.AttributeDto;
import org.genemania.dto.EnrichmentEngineResponseDto;
import org.genemania.dto.InteractionDto;
import org.genemania.dto.NetworkDto;
import org.genemania.dto.NodeDto;
import org.genemania.dto.OntologyCategoryDto;
import org.genemania.dto.RelatedGenesEngineRequestDto;
import org.genemania.dto.RelatedGenesEngineResponseDto;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.AttributeMediator;
import org.genemania.mediator.GeneMediator;
import org.genemania.mediator.NodeMediator;
import org.genemania.mediator.OntologyMediator;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.IMediatorProvider;
import org.genemania.plugin.model.AnnotationEntry;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.SearchResultBuilder;
import org.genemania.plugin.model.impl.SearchResultImpl;
import org.genemania.util.GeneLinkoutGenerator;

public class NetworkUtils {
    public Map<Long, Gene> createQueryNodes(GeneMediator geneMediator, List<String> geneNames, Organism organism) {
        try {
            List genes = geneMediator.getGenes(geneNames, organism.getId());
            HashMap<Long, Gene> nodes = new HashMap<Long, Gene>();
            for (Gene gene : genes) {
                Node node = gene.getNode();
                nodes.put(node.getId(), gene);
            }
            return nodes;
        }
        catch (DataStoreException e) {
            return Collections.emptyMap();
        }
    }

    public Map<Long, Collection<Interaction>> createInteractionMap(Map<InteractionNetwork, Collection<Interaction>> sourceInteractions) {
        HashMap<Long, Collection<Interaction>> networks = new HashMap<Long, Collection<Interaction>>();
        for (Map.Entry<InteractionNetwork, Collection<Interaction>> entry : sourceInteractions.entrySet()) {
            InteractionNetwork network = entry.getKey();
            networks.put(network.getId(), entry.getValue());
        }
        return networks;
    }

    public Gene getPreferredGene(Node node) {
        Gene best = null;
        byte bestRank = -128;
        Collection genes = node.getGenes();
        for (Gene gene : genes) {
            byte rank = gene.getNamingSource().getRank();
            if (rank <= bestRank) continue;
            best = gene;
            bestRank = rank;
        }
        return best;
    }

    public double[] sortScores(Map<?, Double> scores) {
        double[] values = new double[scores.size()];
        int i = 0;
        for (Map.Entry<?, Double> entry : scores.entrySet()) {
            values[i] = entry.getValue();
            ++i;
        }
        Arrays.sort(values);
        return values;
    }

    public <T> List<T> createSortedList(final Map<T, Double> scoredMap) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(scoredMap.keySet());
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                double score1 = (Double)scoredMap.get(o1);
                double score2 = (Double)scoredMap.get(o2);
                return (int)Math.signum(score2 - score1);
            }
        });
        return list;
    }

    public Comparator<Group<?, ?>> getNetworkGroupComparator() {
        return new Comparator<Group<?, ?>>(){

            @Override
            public int compare(Group<?, ?> group1, Group<?, ?> group2) {
                return group1.getName().compareToIgnoreCase(group2.getName());
            }
        };
    }

    public Comparator<Network<?>> getNetworkComparator() {
        return new Comparator<Network<?>>(){

            @Override
            public int compare(Network<?> network1, Network<?> network2) {
                return network1.getName().compareToIgnoreCase(network2.getName());
            }
        };
    }

    public Color getNetworkColor(DataSet data, Group<?, ?> group) {
        return new Color(data.getColor(group.getCode()).getRgb());
    }

    public String buildDescriptionHtml(Network<?> network, Group<?, ?> group) {
        InteractionNetwork adapted = network.adapt(InteractionNetwork.class);
        if (adapted != null) {
            return this.buildDescriptionHtml(adapted);
        }
        adapted = network.adapt(AttributeGroup.class);
        if (adapted != null) {
            return this.buildDescriptionHtml((AttributeGroup)adapted);
        }
        adapted = network.adapt(Attribute.class);
        Group<AttributeGroup, Attribute> adaptedGroup = group.adapt(AttributeGroup.class, Attribute.class);
        if (adapted != null && adaptedGroup != null) {
            return this.buildDescriptionHtml((Attribute)adapted, adaptedGroup.getModel());
        }
        return "";
    }

    private String buildDescriptionHtml(Attribute attribute, AttributeGroup group) {
        StringBuilder builder = new StringBuilder();
        builder.append("<div>");
        builder.append(attribute.getDescription());
        builder.append("</div>");
        builder.append(String.format("<div><strong>%s</strong> ", Strings.networkDetailPanelSource_label));
        builder.append(String.format(Strings.networkDetailPanelAttribute_description, group.getDescription(), this.formatLink(group.getPublicationName(), group.getPublicationUrl())));
        builder.append("</div>");
        builder.append(String.format("<div><strong>%s</strong> ", Strings.networkDetailPanelMoreAt_label));
        builder.append(this.formatLink(group.getLinkoutLabel(), group.getLinkoutUrl()));
        builder.append("</div>");
        return builder.toString();
    }

    private String buildDescriptionHtml(AttributeGroup group) {
        StringBuilder builder = new StringBuilder();
        builder.append("<div>");
        builder.append(String.format(Strings.networkDetailPanelAttribute_description, group.getDescription(), this.formatLink(group.getPublicationName(), group.getPublicationUrl())));
        builder.append("</div>");
        return builder.toString();
    }

    String buildDescriptionHtml(InteractionNetwork network) {
        String comment;
        String other;
        StringBuilder builder = new StringBuilder();
        NetworkMetadata data = network.getMetadata();
        if (data == null) {
            return network.getDescription();
        }
        String title = data.getTitle();
        if (!this.isEmpty(title)) {
            String publication;
            String yearPublished;
            builder.append("<div>");
            builder.append(this.formatLink(title, data.getUrl()));
            builder.append(". ");
            String authors = data.getAuthors();
            if (!this.isEmpty(authors)) {
                builder.append(this.htmlEscape(this.formatAuthors(authors)));
                builder.append(". ");
            }
            if (!this.isEmpty(yearPublished = data.getYearPublished())) {
                builder.append("(");
                builder.append(this.htmlEscape(yearPublished));
                builder.append("). ");
            }
            if (!this.isEmpty(publication = data.getPublicationName())) {
                builder.append(this.htmlEscape(data.getPublicationName()));
                builder.append(".");
            }
            builder.append("</div>");
        }
        if (!this.isEmpty(other = data.getOther())) {
            builder.append("<div>");
            builder.append(this.htmlEscape(other));
            builder.append("</div>");
        }
        if (!this.isEmpty(comment = data.getComment())) {
            builder.append(String.format("<div><strong>%s</strong> ", Strings.networkDetailPanelComment_label));
            builder.append(this.htmlEscape(comment));
            builder.append("</div>");
        }
        builder.append(String.format("<div><strong>%s</strong> ", Strings.networkDetailPanelSource_label));
        builder.append(String.format(Strings.networkDetailPanelSource_description, this.formatProcessingDescription(data.getProcessingDescription()), data.getInteractionCount(), this.formatLink(data.getSource(), data.getSourceUrl())));
        builder.append("</div>");
        Collection tags = network.getTags();
        if (tags.size() > 0) {
            builder.append("<div>");
            builder.append(String.format("<strong>%s</strong> ", Strings.networkDetailPanelTags_label));
            int i = 0;
            for (Tag tag : tags) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(tag.getName().toLowerCase());
                ++i;
            }
            builder.append("</div>");
        }
        return builder.toString();
    }

    private String formatProcessingDescription(String processingDescription) {
        return processingDescription;
    }

    private String formatAuthors(String authors) {
        String[] parts = authors.split(",");
        if (parts.length == 1) {
            return parts[0];
        }
        return parts[0] + ", et al";
    }

    private String formatLink(String title, String url) {
        if (this.isEmpty(url)) {
            return this.htmlEscape(title);
        }
        return "<a href=\"" + url + "\">" + this.htmlEscape(title) + "</a>";
    }

    private String htmlEscape(String comment) {
        return comment.replaceAll("&", "&amp;").replaceAll("<", "&lt;");
    }

    public String buildDescriptionReport(InteractionNetwork network) {
        Collection tags;
        String pubMed;
        String authors;
        StringBuilder builder = new StringBuilder();
        NetworkMetadata data = network.getMetadata();
        if (data == null) {
            return network.getDescription();
        }
        builder.append(String.format(Strings.reportMethod_label, data.getProcessingDescription()));
        String comment = data.getComment();
        if (!this.isEmpty(comment)) {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(comment);
        }
        if (!this.isEmpty(authors = data.getAuthors())) {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(String.format(Strings.reportAuthors_label, authors));
        }
        if (!this.isEmpty(pubMed = data.getPubmedId())) {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(String.format(Strings.reportPubMed_label, pubMed));
        }
        if (builder.length() > 0) {
            builder.append("|");
        }
        builder.append(String.format(Strings.reportInteraction_label, data.getInteractionCount()));
        String source = data.getSource();
        if (!this.isEmpty(source)) {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(String.format(Strings.reportSource_label, source));
        }
        if ((tags = network.getTags()).size() > 0) {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(Strings.reportTags_label);
            int i = 0;
            for (Tag tag : tags) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(tag.getName());
                ++i;
            }
        }
        return builder.toString();
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public String getGeneLabel(Gene gene) {
        Gene preferredGene = this.getPreferredGene(gene.getNode());
        if (preferredGene.getId() == gene.getId()) {
            return gene.getSymbol();
        }
        return String.format("%s (%s)", preferredGene.getSymbol(), gene.getSymbol());
    }

    public Collection<Interaction> computeCombinedInteractions(Map<InteractionNetwork, Collection<Interaction>> source) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        HashMap seenNodes = new HashMap();
        for (Collection<Interaction> network : source.values()) {
            for (Interaction interaction : network) {
                HashSet<Long> toIds;
                long toId;
                long fromId = interaction.getFromNode().getId();
                if (fromId > (toId = interaction.getToNode().getId())) {
                    fromId = toId;
                    toId = interaction.getFromNode().getId();
                }
                if ((toIds = (HashSet<Long>)seenNodes.get(fromId)) == null) {
                    toIds = new HashSet<Long>();
                    seenNodes.put(fromId, toIds);
                    toIds.add(toId);
                    interactions.add(interaction);
                    continue;
                }
                if (toIds.contains(toId)) continue;
                toIds.add(toId);
                interactions.add(interaction);
            }
        }
        return interactions;
    }

    public void computeSourceInteractions(List<NetworkDto> networks, Map<Long, InteractionNetwork> canonicalNetworks, Organism organism, DataSet data) {
        IMediatorProvider mediatorProvider = data.getMediatorProvider();
        NodeMediator nodeMediator = mediatorProvider.getNodeMediator();
        for (NetworkDto networkVo : networks) {
            InteractionNetwork network = canonicalNetworks.get(networkVo.getId());
            if (network == null) continue;
            ArrayList<Interaction> interactions = new ArrayList<Interaction>();
            for (InteractionDto interactionVo : networkVo.getInteractions()) {
                Node fromNode = nodeMediator.getNode(interactionVo.getNodeVO1().getId(), organism.getId());
                Node toNode = nodeMediator.getNode(interactionVo.getNodeVO2().getId(), organism.getId());
                Interaction interaction = new Interaction(fromNode, toNode, (float)interactionVo.getWeight(), null);
                interactions.add(interaction);
            }
            network.setInteractions(interactions);
        }
    }

    public Map<Gene, Double> computeGeneScores(List<NodeDto> nodes, Map<Long, Gene> queryGenes, Organism organism, NodeMediator nodeMediator) {
        HashMap<Long, NodeDto> uniqueNodes = new HashMap<Long, NodeDto>();
        for (NodeDto nodeDto : nodes) {
            uniqueNodes.put(nodeDto.getId(), nodeDto);
        }
        double maxScore = 0.0;
        HashMap<Gene, Double> scores = new HashMap<Gene, Double>();
        for (Map.Entry entry : uniqueNodes.entrySet()) {
            long nodeId = (Long)entry.getKey();
            Gene gene = queryGenes.get(nodeId);
            if (gene == null) {
                Node node = nodeMediator.getNode(nodeId, organism.getId());
                gene = this.getPreferredGene(node);
            }
            if (gene == null) continue;
            double score = ((NodeDto)entry.getValue()).getScore();
            maxScore = Math.max(maxScore, score);
            scores.put(gene, score);
        }
        for (Gene gene : queryGenes.values()) {
            if (scores.containsKey(gene)) continue;
            scores.put(gene, maxScore);
        }
        return scores;
    }

    public Map<InteractionNetwork, Double> computeNetworkWeights(List<NetworkDto> networks, Map<Long, InteractionNetwork> canonicalNetworks, Map<Attribute, Double> attributeWeights) {
        double totalAttributeWeight = 0.0;
        if (attributeWeights != null) {
            for (Double weight : attributeWeights.values()) {
                totalAttributeWeight += weight.doubleValue();
            }
        }
        double scaleFactor = 1.0 - totalAttributeWeight;
        HashMap<InteractionNetwork, Double> networkWeights = new HashMap<InteractionNetwork, Double>();
        for (NetworkDto networkVo : networks) {
            InteractionNetwork network = canonicalNetworks.get(networkVo.getId());
            if (network == null) {
                network = new InteractionNetwork();
                network.setId(networkVo.getId());
            }
            networkWeights.put(network, networkVo.getWeight() * scaleFactor);
        }
        return networkWeights;
    }

    public Map<Long, Gene> computeQueryGenes(List<String> geneSymbols, GeneCompletionProvider2 geneProvider) {
        HashMap<Long, Gene> genesByNodeId = new HashMap<Long, Gene>();
        for (String symbol : geneSymbols) {
            Gene gene = geneProvider.getGene(symbol);
            if (gene == null) continue;
            genesByNodeId.put(gene.getNode().getId(), gene);
        }
        return genesByNodeId;
    }

    public Map<Long, InteractionNetworkGroup> computeGroupsByNetwork(RelatedGenesEngineResponseDto response, DataSet data) {
        HashMap<Long, InteractionNetworkGroup> groups = new HashMap<Long, InteractionNetworkGroup>();
        HashMap<Long, InteractionNetworkGroup> groupsByNetwork = new HashMap<Long, InteractionNetworkGroup>();
        List networks = response.getNetworks();
        for (NetworkDto network : networks) {
            long networkId = network.getId();
            InteractionNetworkGroup group = data.getNetworkGroup(networkId);
            if (group == null) continue;
            InteractionNetworkGroup canonicalGroup = (InteractionNetworkGroup)groups.get(group.getId());
            if (canonicalGroup == null) {
                groups.put(group.getId(), group);
                canonicalGroup = group;
            }
            groupsByNetwork.put(networkId, canonicalGroup);
        }
        return groupsByNetwork;
    }

    public SearchResult createSearchOptions(Organism organism, RelatedGenesEngineRequestDto request, RelatedGenesEngineResponseDto response, EnrichmentEngineResponseDto enrichmentResponse, DataSet data, List<String> genes) {
        SearchResultImpl config = new SearchResultImpl();
        config.setOrganism(organism);
        GeneCompletionProvider2 geneProvider = data.getCompletionProvider(organism);
        Map<Long, Gene> queryGenes = this.computeQueryGenes(genes, geneProvider);
        config.setSearchQuery(queryGenes);
        config.setCombiningMethod(request.getCombiningMethod());
        config.setGeneSearchLimit(request.getLimitResults());
        config.setAttributeSearchLimit(request.getAttributesLimit());
        Map<Long, InteractionNetworkGroup> groupsByNetwork = this.computeGroupsByNetwork(response, data);
        config.setGroups(groupsByNetwork);
        IMediatorProvider provider = data.getMediatorProvider();
        NodeMediator nodeMediator = provider.getNodeMediator();
        List sourceNetworks = response.getNetworks();
        config.setGeneScores(this.computeGeneScores(response.getNodes(), queryGenes, organism, nodeMediator));
        Map<Long, InteractionNetwork> canonicalNetworks = this.computeCanonicalNetworks(groupsByNetwork);
        this.computeSourceInteractions(sourceNetworks, canonicalNetworks, organism, data);
        AttributeMediator attributeMediator = provider.getAttributeMediator();
        this.computeAttributes(config, organism, response.getAttributes(), response.getNodeToAttributes(), attributeMediator);
        config.setNetworkWeights(this.computeNetworkWeights(sourceNetworks, canonicalNetworks, config.getAttributeWeights()));
        if (enrichmentResponse != null) {
            config.setEnrichment(this.processAnnotations(enrichmentResponse.getAnnotations(), data));
        }
        return config.build();
    }

    private Map<Long, InteractionNetwork> computeCanonicalNetworks(Map<Long, InteractionNetworkGroup> groupsByNetwork) {
        HashMap<Long, InteractionNetwork> canonicalNetworks = new HashMap<Long, InteractionNetwork>();
        for (InteractionNetworkGroup group : groupsByNetwork.values()) {
            for (InteractionNetwork network : group.getInteractionNetworks()) {
                canonicalNetworks.put(network.getId(), network);
            }
        }
        return canonicalNetworks;
    }

    private void computeAttributes(SearchResultBuilder config, Organism organism, Collection<AttributeDto> source, Map<Long, Collection<AttributeDto>> nodeToAttributes, AttributeMediator mediator) {
        if (source == null || nodeToAttributes == null) {
            return;
        }
        HashMap<Long, Attribute> attributes = new HashMap<Long, Attribute>();
        HashMap<Long, AttributeGroup> groupsByAttribute = new HashMap<Long, AttributeGroup>();
        HashMap<Long, AttributeGroup> groups = new HashMap<Long, AttributeGroup>();
        HashMap<Long, Collection<Attribute>> attributesByNode = new HashMap<Long, Collection<Attribute>>();
        HashMap<Attribute, Double> weights = new HashMap<Attribute, Double>();
        long organismId = organism.getId();
        for (AttributeDto attributeDto : source) {
            Attribute attribute = mediator.findAttribute(organismId, attributeDto.getId());
            attributes.put(attribute.getId(), attribute);
            AttributeGroup group = (AttributeGroup)groups.get(attributeDto.getGroupId());
            if (group == null) {
                group = mediator.findAttributeGroup(organismId, attributeDto.getGroupId());
            }
            groupsByAttribute.put(attributeDto.getId(), group);
            groups.put(attributeDto.getGroupId(), group);
            weights.put(attribute, attributeDto.getWeight());
        }
        for (Map.Entry entry : nodeToAttributes.entrySet()) {
            Collection sourceAttributes = (Collection)entry.getValue();
            ArrayList<Attribute> nodeAttributes = new ArrayList<Attribute>(sourceAttributes.size());
            for (AttributeDto item : sourceAttributes) {
                Attribute attribute = (Attribute)attributes.get(item.getId());
                nodeAttributes.add(attribute);
            }
            attributesByNode.put((Long)entry.getKey(), (Collection<Attribute>)nodeAttributes);
        }
        config.setAttributes(attributesByNode);
        config.setAttributeWeights(weights);
        config.setGroupsByAttribute(groupsByAttribute);
    }

    private Map<Long, Collection<AnnotationEntry>> processAnnotations(Map<Long, Collection<OntologyCategoryDto>> annotations, DataSet data) {
        OntologyMediator mediator = data.getMediatorProvider().getOntologyMediator();
        HashMap<Long, Collection<AnnotationEntry>> result = new HashMap<Long, Collection<AnnotationEntry>>();
        HashMap<Long, AnnotationEntry> annotationCache = new HashMap<Long, AnnotationEntry>();
        for (Map.Entry<Long, Collection<OntologyCategoryDto>> entry : annotations.entrySet()) {
            long nodeId = entry.getKey();
            HashSet<AnnotationEntry> nodeAnnotations = new HashSet<AnnotationEntry>();
            for (OntologyCategoryDto categoryVo : entry.getValue()) {
                long categoryId = categoryVo.getId();
                AnnotationEntry annotation = (AnnotationEntry)annotationCache.get(categoryId);
                if (annotation == null) {
                    try {
                        OntologyCategory category = mediator.getCategory(categoryId);
                        annotation = new AnnotationEntry(category, categoryVo);
                        annotationCache.put(categoryId, annotation);
                    }
                    catch (DataStoreException e) {
                        Logger logger = Logger.getLogger(NetworkUtils.class);
                        logger.error((Object)String.format("Can't find category: %d", categoryId), (Throwable)e);
                        continue;
                    }
                }
                nodeAnnotations.add(annotation);
            }
            if (nodeAnnotations.size() <= 0) continue;
            result.put(nodeId, nodeAnnotations);
        }
        return result;
    }

    public void normalizeNetworkWeights(RelatedGenesEngineResponseDto result) {
        double totalWeight = 0.0;
        for (NetworkDto network : result.getNetworks()) {
            totalWeight += network.getWeight();
        }
        if (totalWeight == 0.0) {
            return;
        }
        double correctionFactor = 1.0 / totalWeight;
        for (NetworkDto network : result.getNetworks()) {
            network.setWeight(network.getWeight() * correctionFactor);
        }
    }

    public String buildGeneDescription(Gene gene) {
        Node node = gene.getNode();
        GeneData data = node.getGeneData();
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        Map linkouts = GeneLinkoutGenerator.instance().getLinkouts(gene.getOrganism(), node);
        for (Map.Entry entry : linkouts.entrySet()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(String.format("<a href=\"%s\">%s</a>", this.htmlEscape((String)entry.getValue()), entry.getKey()));
            first = false;
        }
        if (builder.length() == 0) {
            return String.format(Strings.geneDetailPanelDescription_label, this.htmlEscape(data.getDescription()), builder.toString());
        }
        return String.format(Strings.geneDetailPanelDescription2_label, this.htmlEscape(data.getDescription()), builder.toString());
    }
}

